/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.cluster;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.cluster.config.ClusterConfig;
import org.joyqueue.broker.cluster.config.ClusterConfigKey;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.EventType;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.event.AddConfigEvent;
import org.joyqueue.nsr.event.RemoveConfigEvent;
import org.joyqueue.nsr.event.UpdateConfigEvent;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.service.Service;

public class ClusterNameServiceCache
extends Service {
    private ClusterConfig config;
    private NameService nameService;
    private volatile Cache<String, TopicConfig> topicConfigCache;

    public ClusterNameServiceCache(ClusterConfig config, NameService nameService) {
        this.config = config;
        this.nameService = nameService;
    }

    protected void validate() throws Exception {
        this.nameService.addListener((EventListener)new EventListener<NameServerEvent>(){

            public void onEvent(NameServerEvent event) {
                RemoveConfigEvent removeConfigEvent;
                if (event.getEventType().equals((Object)EventType.UPDATE_CONFIG)) {
                    UpdateConfigEvent updateConfigEvent = (UpdateConfigEvent)event.getMetaEvent();
                    if (updateConfigEvent.getNewConfig().getKey().equals(ClusterConfigKey.GET_TOPIC_DYNAMIC_METADATA_CACHE_EXPIRE_TIME.getName())) {
                        ClusterNameServiceCache.this.rebuildTopicConfigCache();
                    }
                } else if (event.getEventType().equals((Object)EventType.ADD_CONFIG)) {
                    AddConfigEvent addConfigEvent = (AddConfigEvent)event.getMetaEvent();
                    if (addConfigEvent.getConfig().getKey().equals(ClusterConfigKey.GET_TOPIC_DYNAMIC_METADATA_CACHE_EXPIRE_TIME.getName())) {
                        ClusterNameServiceCache.this.rebuildTopicConfigCache();
                    }
                } else if (event.getEventType().equals((Object)EventType.REMOVE_CONFIG) && (removeConfigEvent = (RemoveConfigEvent)event.getMetaEvent()).getConfig().getKey().equals(ClusterConfigKey.GET_TOPIC_DYNAMIC_METADATA_CACHE_EXPIRE_TIME.getName())) {
                    ClusterNameServiceCache.this.rebuildTopicConfigCache();
                }
            }
        });
        this.rebuildTopicConfigCache();
    }

    protected void rebuildTopicConfigCache() {
        Cache<String, TopicConfig> oldTopicConfigCache = this.topicConfigCache;
        this.topicConfigCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.config.getTopicDynamicMetadataCacheExpireTime(), TimeUnit.MILLISECONDS).build();
        if (oldTopicConfigCache != null) {
            oldTopicConfigCache.cleanUp();
        }
    }

    public TopicConfig getTopicConfig(TopicName topicName, Callable<TopicConfig> callable) throws ExecutionException {
        return (TopicConfig)this.topicConfigCache.get((Object)topicName.getFullName(), callable);
    }
}

