/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.cluster.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.joyqueue.broker.cluster.ClusterNodeManager;
import org.joyqueue.broker.cluster.entry.ClusterNode;
import org.joyqueue.broker.cluster.entry.ClusterPartitionGroup;
import org.joyqueue.broker.cluster.entry.SplittedCluster;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;

public class ClusterSplitHelper {
    public static Map<Integer, List<Integer>> splitByReWrite(TopicConfig topicConfig) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry entry : topicConfig.getPartitionGroups().entrySet()) {
            ClusterPartitionGroup clusterPartitionGroup = (ClusterPartitionGroup)((Object)entry.getValue());
            if (clusterPartitionGroup.isRewrite()) continue;
            for (Integer replica : clusterPartitionGroup.getReplicas()) {
                List groups = (List)result.get(replica);
                if (groups == null) {
                    groups = Lists.newLinkedList();
                    result.put(replica, groups);
                }
                groups.add(clusterPartitionGroup.getGroup());
            }
        }
        return result;
    }

    public static TopicConfig cloneTopicConfig(TopicConfig topicConfig) {
        TopicConfig result = TopicConfig.toTopicConfig((Topic)topicConfig);
        HashMap partitionGroups = Maps.newHashMap();
        for (Map.Entry entry : topicConfig.getPartitionGroups().entrySet()) {
            partitionGroups.put(entry.getKey(), new ClusterPartitionGroup(((PartitionGroup)entry.getValue()).clone()));
        }
        result.setPartitionGroups((Map)partitionGroups);
        return result;
    }

    public static SplittedCluster split(TopicConfig topicConfig, ClusterNodeManager clusterNodeManager) {
        boolean isLocal = true;
        Map splittedByGroup = null;
        HashMap splittedByLeader = null;
        for (Map.Entry entry : topicConfig.getPartitionGroups().entrySet()) {
            PartitionGroup partitionGroup = (PartitionGroup)entry.getValue();
            ClusterNode groupNode = clusterNodeManager.getTopicGroupNode(topicConfig.getName().getFullName(), (Integer)entry.getKey());
            if (groupNode != null) {
                partitionGroup.setLeader(Integer.valueOf(groupNode.getLeader()));
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)partitionGroup.getReplicas())) {
                partitionGroup.setLeader(Integer.valueOf(-1));
                continue;
            }
            if (partitionGroup.getReplicas().size() == 1) {
                partitionGroup.setLeader((Integer)partitionGroup.getReplicas().iterator().next());
                continue;
            }
            isLocal = false;
            if (splittedByGroup == null) {
                splittedByGroup = Maps.newHashMap();
            }
            for (Integer replica : partitionGroup.getReplicas()) {
                List partitionGroups = (List)splittedByGroup.get(replica);
                if (partitionGroups == null) {
                    partitionGroups = Lists.newLinkedList();
                    splittedByGroup.put(replica, partitionGroups);
                }
                partitionGroups.add(partitionGroup.getGroup());
            }
        }
        if (splittedByGroup != null) {
            splittedByLeader = Maps.newHashMap();
            for (Map.Entry entry : topicConfig.getPartitionGroups().entrySet()) {
                Integer leader = ((PartitionGroup)entry.getValue()).getLeader();
                if (leader == null || leader.equals(-1)) continue;
                splittedByLeader.put(leader, splittedByGroup.get(leader));
            }
        }
        return new SplittedCluster(isLocal, (Map)ObjectUtils.defaultIfNull(splittedByGroup, Collections.emptyMap()), (Map)ObjectUtils.defaultIfNull((Object)splittedByLeader, Collections.emptyMap()));
    }
}

