/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.config;

import java.io.File;
import org.joyqueue.broker.config.Configuration;
import org.joyqueue.config.BrokerConfigKey;
import org.joyqueue.domain.Broker;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.network.transport.config.TransportConfigSupport;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.io.Files;
import org.joyqueue.toolkit.network.IpUtil;

public class BrokerConfig
implements PropertySupplierAware {
    public static final String BROKER_FRONTEND_SERVER_CONFIG_PREFIX = "broker.frontend-server.";
    public static final String BROKER_BACKEND_SERVER_CONFIG_PREFIX = "broker.backend-server.";
    public static final String BROKER_ID_FILE_NAME = "broker.id";
    public static final String ADMIN_USER = "broker.joyqueue.admin";
    public static final String DEFAULT_DATA_DIR = ".joyqueue";
    public static final int INVALID_BROKER_ID = -1;
    private String dataPath;
    private Broker broker;
    private String localIp;
    private String adminUser;
    private ServerConfig frontendConfig;
    private ServerConfig backendConfig;
    private Configuration propertySupplier;

    public BrokerConfig(PropertySupplier propertySupplier) {
        this.setSupplier(propertySupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAndCreateDataPath() {
        if (this.dataPath != null) {
            return this.dataPath;
        }
        BrokerConfig brokerConfig = this;
        synchronized (brokerConfig) {
            if (this.dataPath == null) {
                Property property = this.propertySupplier == null ? null : this.propertySupplier.getProperty("application.data.path");
                String path = property == null ? null : property.getString();
                File dataFile = path == null ? new File(new File(System.getProperty("user.home")), DEFAULT_DATA_DIR) : new File(path);
                Files.createDirectory((File)dataFile);
                this.dataPath = dataFile.getPath();
                this.propertySupplier.addProperty("application.data.path", this.dataPath);
            }
        }
        return this.dataPath;
    }

    public String getBrokerIdFilePath() {
        return this.getAndCreateDataPath() + File.separator + BROKER_ID_FILE_NAME;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
        this.frontendConfig.setPort(broker.getPort());
        this.backendConfig.setPort(broker.getBackEndPort());
    }

    public Integer getBrokerId() {
        return this.broker == null ? -1 : this.broker.getId();
    }

    @Deprecated
    public String getBrokerIp() {
        if (this.localIp == null) {
            this.localIp = IpUtil.getLocalIp();
        }
        return this.localIp;
    }

    public void setSupplier(PropertySupplier propertySupplier) {
        this.propertySupplier = (Configuration)propertySupplier;
        this.frontendConfig = TransportConfigSupport.buildServerConfig((PropertySupplier)propertySupplier, (String)BROKER_FRONTEND_SERVER_CONFIG_PREFIX);
        this.backendConfig = TransportConfigSupport.buildServerConfig((PropertySupplier)propertySupplier, (String)BROKER_BACKEND_SERVER_CONFIG_PREFIX);
        Property adminUser = propertySupplier.getProperty(ADMIN_USER);
        if (null != adminUser) {
            this.adminUser = adminUser.getString();
        }
    }

    public boolean getServerShardedThreads() {
        return (Boolean)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_SHARDED_THREADS);
    }

    public int getServerCommonThreads() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_COMMON_THREADS);
    }

    public int getServerCommonThreadKeepalive() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_COMMON_THREAD_KEEPALIVE);
    }

    public int getServerCommonThreadQueueSize() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_COMMON_THREAD_QUEUE_SIZE);
    }

    public int getServerFetchThreads() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_FETCH_THREADS);
    }

    public int getServerFetchThreadKeepalive() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_FETCH_THREAD_KEEPALIVE);
    }

    public int getServerFetchThreadQueueSize() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_FETCH_THREAD_QUEUE_SIZE);
    }

    public int getServerProduceThreads() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_PRODUCE_THREADS);
    }

    public int getServerProduceThreadKeepalive() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_PRODUCE_THREAD_KEEPALIVE);
    }

    public int getServerProduceThreadQueueSize() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_PRODUCE_THREAD_QUEUE_SIZE);
    }

    public boolean getLogDetail(String app) {
        return (Boolean)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.LOG_DETAIL) != false || (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (String)(BrokerConfigKey.LOG_DETAIL_PREFIX.getName() + app), (PropertyDef.Type)BrokerConfigKey.LOG_DETAIL_PREFIX.getType(), (Object)BrokerConfigKey.LOG_DETAIL_PREFIX.getValue()) != false;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public ServerConfig getFrontendConfig() {
        return this.frontendConfig;
    }

    public void setFrontendConfig(ServerConfig frontendConfig) {
        this.frontendConfig = frontendConfig;
    }

    public ServerConfig getBackendConfig() {
        return this.backendConfig;
    }

    public void setBackendConfig(ServerConfig backendConfig) {
        this.backendConfig = backendConfig;
    }
}

