/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.config;

import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;

public class BrokerStoreConfig {
    public static final String DEFAULT_CLEAN_STRATEGY_CLASS = "GlobalStorageLimitCleaningStrategy";
    public static final long DEFAULT_MAX_STORE_SIZE = 0x280000000L;
    public static final long DEFAULT_MAX_STORE_TIME = 604800000L;
    public static final long DEFAULT_STORE_CLEAN_SCHEDULE_BEGIN = 300000L;
    public static final long DEFAULT_STORE_CLEAN_SCHEDULE_END = 600000L;
    public static final boolean DEFAULT_KEEP_UNCONSUMED = true;
    public static final int DEFAULT_STORE_DISK_USAGE_MAX = 80;
    public static final int DEFAULT_STORE_DISK_USAGE_SAFE = 75;
    private PropertySupplier propertySupplier;

    public BrokerStoreConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
    }

    public String getCleanStrategyClass() {
        return (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerStoreConfigKey.CLEAN_STRATEGY_CLASS, (Object)DEFAULT_CLEAN_STRATEGY_CLASS);
    }

    public long getMaxStoreSize() {
        return (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerStoreConfigKey.MAX_STORE_SIZE, (Object)0x280000000L);
    }

    public long getMaxStoreTime() {
        return (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerStoreConfigKey.MAX_STORE_TIME, (Object)604800000L);
    }

    public long getMaxStoreTime(String topic) {
        long storeTime = (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (String)(BrokerStoreConfigKey.MAX_STORE_TIME_TOPIC_PREFIX.getName() + topic), (PropertyDef.Type)BrokerStoreConfigKey.MAX_STORE_TIME_TOPIC_PREFIX.getType(), (Object)BrokerStoreConfigKey.MAX_STORE_TIME_TOPIC_PREFIX.getValue());
        return storeTime < 0L ? this.getMaxStoreTime() : storeTime;
    }

    public boolean keepUnconsumed(String topic) {
        String keepUnconsumed = (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (String)(BrokerStoreConfigKey.KEEP_UNCONSUMED_TOPIC_PREFIX.getName() + topic), (PropertyDef.Type)BrokerStoreConfigKey.KEEP_UNCONSUMED_TOPIC_PREFIX.getType(), (Object)BrokerStoreConfigKey.KEEP_UNCONSUMED_TOPIC_PREFIX.getValue());
        return keepUnconsumed == null ? this.keepUnconsumed() : Boolean.valueOf(keepUnconsumed).booleanValue();
    }

    public boolean keepUnconsumed() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerStoreConfigKey.KEEP_UNCONSUMED, (Object)true);
    }

    public long getStoreCleanScheduleBegin() {
        return (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerStoreConfigKey.CLEAN_SCHEDULE_BEGIN, (Object)300000L);
    }

    public long getStoreCleanScheduleEnd() {
        return (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerStoreConfigKey.CLEAN_SCHEDULE_END, (Object)600000L);
    }

    public boolean getForceRestore() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerStoreConfigKey.FORCE_RESTORE);
    }

    public int getStoreDiskUsageMax() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerStoreConfigKey.STORE_DISK_USAGE_MAX);
    }

    public int getStoreDiskUsageSafe() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerStoreConfigKey.STORE_DISK_USAGE_SAFE);
    }

    public String getApplicationDataPath() {
        return this.propertySupplier.getOrCreateProperty("application.data.path").getString();
    }

    public static enum BrokerStoreConfigKey implements PropertyDef
    {
        CLEAN_STRATEGY_CLASS("store.clean.strategy.class", "GlobalStorageLimitCleaningStrategy", PropertyDef.Type.STRING),
        MAX_STORE_SIZE("store.max.store.size", 0x280000000L, PropertyDef.Type.LONG),
        MAX_STORE_TIME("store.max.store.time", 604800000L, PropertyDef.Type.LONG),
        MAX_STORE_TIME_TOPIC_PREFIX("store.max.store.time.", -1, PropertyDef.Type.LONG),
        KEEP_UNCONSUMED("store.clean.keep.unconsumed", true, PropertyDef.Type.BOOLEAN),
        KEEP_UNCONSUMED_TOPIC_PREFIX("store.clean.keep.unconsumed.", null, PropertyDef.Type.STRING),
        CLEAN_SCHEDULE_BEGIN("store.clean.schedule.begin", 300000L, PropertyDef.Type.LONG),
        CLEAN_SCHEDULE_END("store.clean.schedule.end", 600000L, PropertyDef.Type.LONG),
        FORCE_RESTORE("store.force.restore", true, PropertyDef.Type.BOOLEAN),
        STORE_DISK_USAGE_MAX("store.disk.usage.max", 80, PropertyDef.Type.INT),
        STORE_DISK_USAGE_SAFE("store.disk.usage.safe", 75, PropertyDef.Type.INT);

        private String name;
        private Object value;
        private PropertyDef.Type type;

        private BrokerStoreConfigKey(String name, Object value, PropertyDef.Type type) {
            this.name = name;
            this.value = value;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public PropertyDef.Type getType() {
            return this.type;
        }
    }
}

