/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements PropertySupplier {
    protected static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    protected static final int DEFAULT_CONFIGURATION_PRIORITY = 1;
    protected static final long DEFAULT_CONFIGURATION_VERSION = 1L;
    protected static final String DEFAULT_CONFIGURATION_NAME = "_BROKER_CONFIG_";
    protected String name = "_BROKER_CONFIG_";
    protected long version = 1L;
    protected int priority = 1;
    protected Map<String, Property> properties = new HashMap<String, Property>();

    public Configuration() {
    }

    public Configuration(String name, Collection<Property> properties, long version, int priority) {
        this.name = name;
        this.version = version;
        this.priority = priority;
        this.addProperties(properties);
    }

    public Configuration(String name, Map<?, ?> properties, long version, int priority) {
        this.name = name;
        this.version = version;
        this.priority = priority;
        if (properties != null) {
            ArrayList<Property> items = new ArrayList<Property>(properties.size());
            for (Map.Entry<?, ?> entry : properties.entrySet()) {
                items.add(new Property(name, entry.getKey().toString(), (Object)entry.getValue().toString(), version, priority));
            }
            this.addProperties(items);
        }
    }

    public Configuration(String name, long version, int priority) {
        this.name = name;
        this.version = version;
        this.priority = priority;
    }

    public Configuration(String name, List<Configuration> configurations, long version) {
        this.name = name;
        this.version = version;
        LinkedList<Property> items = new LinkedList<Property>();
        if (configurations != null) {
            for (Configuration configuration : configurations) {
                if (configuration == null || configuration.size() <= 0) continue;
                for (Property property : configuration.properties.values()) {
                    items.add(property);
                }
                if (this.priority >= configuration.priority) continue;
                this.priority = configuration.priority;
            }
        }
        this.addProperties(items);
    }

    protected void addProperties(Collection<Property> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (Property item : collection) {
            if (item.getKey() == null || item.getValue() == null) {
                return;
            }
            this.properties.put(item.getKey(), item);
            Configuration.process(item.getKey(), 0, item.getValue(), context);
        }
        if (!context.isEmpty()) {
            Configuration.processArray(context, false);
            for (Map.Entry entry : context.entrySet()) {
                if (this.properties.containsKey(entry.getKey())) continue;
                Property property = new Property(this.name, (String)entry.getKey(), entry.getValue(), this.version, this.priority);
                this.properties.put((String)entry.getKey(), property);
            }
        }
    }

    public Property addProperty(String key, String value, String group) {
        Property property = new Property(this.name, key, (Object)value, group, 0L, this.priority);
        this.properties.put(key, property);
        return property;
    }

    public Property addProperty(String key, String value) {
        return this.addProperty(key, value, null);
    }

    protected static void process(String source, int start, Object value, Map<String, Object> context) {
        int right;
        int left;
        int from = start;
        while ((left = source.indexOf(91, from)) > 0 && (right = source.indexOf(93, left + 1)) > 0) {
            String key = source.substring(start, left);
            String index = source.substring(left + 1, right);
            if (index != null && !index.isEmpty() && (right == source.length() - 1 || source.charAt(right + 1) == '.' && right < source.length() - 2)) {
                HashMap v = context.get(key);
                if (v == null || !(v instanceof Map)) {
                    v = new HashMap();
                    context.put(key, v);
                }
                if (right == source.length() - 1) {
                    ((Map)v).put(index, value);
                } else {
                    Object child = ((Map)v).get(index);
                    if (child == null || !(child instanceof Map)) {
                        child = new HashMap();
                        ((Map)v).put(index, child);
                    }
                    Configuration.process(source, right + 2, value, (Map)child);
                }
                return;
            }
            from = right + 1;
        }
        if (start > 0 && start < source.length()) {
            context.put(source.substring(start), value);
        }
    }

    protected static Object[] processArray(Map<String, Object> context, boolean flag) {
        if (context.isEmpty()) {
            return null;
        }
        int max = 0;
        boolean isArray = true;
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            Object[] array;
            if (flag && isArray) {
                try {
                    int v = Integer.parseInt(entry.getKey());
                    if (v >= 0) {
                        if (max < v) {
                            max = v;
                        }
                    } else {
                        isArray = false;
                    }
                }
                catch (NumberFormatException e) {
                    isArray = false;
                }
            }
            if (!(entry.getValue() instanceof Map) || (array = Configuration.processArray((Map)entry.getValue(), true)) == null) continue;
            entry.setValue(array);
        }
        if (flag && isArray) {
            Object[] result = new Object[max + 1];
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                result[Integer.parseInt((String)entry.getKey())] = entry.getValue();
            }
            return result;
        }
        return null;
    }

    public Property getProperty(String key) {
        return this.properties.get(key);
    }

    public Property getOrCreateProperty(String key) {
        Property property = this.getProperty(key);
        if (property == null) {
            return new Property(this.name, key, null, 0L, 0);
        }
        return property;
    }

    @Deprecated
    public Collection<Property> get() {
        return this.getProperties();
    }

    public List<Property> getProperties() {
        return this.properties == null ? new ArrayList<Property>(0) : new ArrayList<Property>(this.properties.values());
    }

    public List<Property> getPrefix(String prefix) {
        ArrayList<Property> result = new ArrayList<Property>();
        if (prefix == null || prefix.isEmpty() || this.properties == null) {
            return result;
        }
        for (Map.Entry<String, Property> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    public String getName() {
        return this.name;
    }

    public long getVersion() {
        return this.version;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public int size() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Configuration{properties=" + this.properties + ", name='" + this.name + '\'' + ", version=" + this.version + '}';
    }
}

