/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.config;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.config.Configuration;
import org.joyqueue.broker.config.SystemConfigLoader;
import org.joyqueue.domain.Config;
import org.joyqueue.event.EventType;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.nsr.event.AddConfigEvent;
import org.joyqueue.nsr.event.RemoveConfigEvent;
import org.joyqueue.nsr.event.UpdateConfigEvent;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager
extends Service
implements EventListener<NameServerEvent> {
    private static final String DEFAULT_CONFIGURATION_NAME = "_BROKER_CONFIG_";
    private static final String CONFIGURATION_VERSION = "_CONFIGURATION_VERSION_";
    private static final String DEFAULT_CONFIG_PATH = "joyqueue.properties";
    private static final String GROUP_SPLITTER = ",";
    private static final String ALL_GROUP = "all";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    private ConfigProvider configProvider;
    private Configuration configuration;
    private String configPath = "joyqueue.properties";

    public ConfigurationManager(String[] args) {
    }

    private void parseParams(Configuration configuration, String[] args) {
    }

    public ConfigurationManager(String configPath) {
        if (configPath != null && !configPath.isEmpty()) {
            this.configPath = configPath;
        }
    }

    public Configuration getConfiguration() {
        Preconditions.checkState((boolean)this.isStarted(), (Object)"config manager not not started yet.");
        return this.configuration;
    }

    protected void validate() throws Exception {
        super.validate();
        SystemConfigLoader.load();
        if (this.configuration == null) {
            this.configuration = this.buildConfiguration();
        }
    }

    private Configuration buildConfiguration() throws Exception {
        Configuration configuration = new Configuration();
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.configPath);
        if (null != url) {
            logger.info("Found conf file: {}.", (Object)url);
            InputStream in = url.openStream();
            Properties properties = new Properties();
            properties.load(in);
            String text = (String)properties.remove(CONFIGURATION_VERSION);
            long dataVersion = 1L;
            if (text != null && !text.isEmpty()) {
                try {
                    dataVersion = Long.parseLong(text);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ArrayList<Property> propertyList = new ArrayList<Property>(properties.size());
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                propertyList.add(new Property(DEFAULT_CONFIGURATION_NAME, key, (Object)value, dataVersion, 1));
            }
            configuration.addProperties(propertyList);
        } else {
            logger.info("No {} in classpath, using default.", (Object)this.configPath);
        }
        return configuration;
    }

    public void setConfigProvider(ConfigProvider configProvider) {
        this.configProvider = configProvider;
        if (this.isStarted()) {
            this.doUpdateConfig();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.doUpdateConfig();
        logger.info("context manager is started");
    }

    protected void doStop() {
        super.doStop();
        logger.info("configuration manager is stopped");
    }

    private void doUpdateConfig() {
        if (this.configProvider != null) {
            List<Config> configs = this.configProvider.getConfigs();
            if (null != configs) {
                this.doUpdateProperty(EventType.ADD_CONFIG, configs.toArray(new Config[configs.size()]));
            } else {
                logger.warn("no dynamic config found.");
            }
        } else {
            logger.warn("config provider not int yet.");
        }
    }

    private void doUpdateProperty(EventType type, Config ... configs) {
        if (ArrayUtils.isEmpty((Object[])configs)) {
            return;
        }
        for (Config config : configs) {
            logger.info("received config [{}], corresponding property is [{}]", (Object)config, this.configuration.getProperty(config.getKey()) != null ? this.configuration.getProperty(config.getKey()) : "null");
            if (StringUtils.isBlank((CharSequence)config.getGroup()) || ALL_GROUP.equals(config.getGroup()) || ArrayUtils.contains((Object[])config.getGroup().split(GROUP_SPLITTER), (Object)IpUtil.getLocalIp())) {
                if (type.equals((Object)EventType.REMOVE_CONFIG)) {
                    logger.info("delete config {}", (Object)config.getKey());
                    this.configuration.addProperty(config.getKey(), null, config.getGroup());
                    continue;
                }
                logger.info("add config {}, value is {}", (Object)config.getKey(), (Object)config.getValue());
                this.configuration.addProperty(config.getKey(), config.getValue(), config.getGroup());
                continue;
            }
            logger.info("config {} group not match, value is {}, group is {}, ", new Object[]{config.getKey(), config.getValue(), config.getGroup()});
        }
    }

    public void onEvent(NameServerEvent event) {
        switch (event.getEventType()) {
            case ADD_CONFIG: {
                AddConfigEvent addConfigEvent = (AddConfigEvent)event.getMetaEvent();
                Config config = addConfigEvent.getConfig();
                this.doUpdateProperty(addConfigEvent.getEventType(), new Config(config.getGroup(), config.getKey(), config.getValue()));
                break;
            }
            case UPDATE_CONFIG: {
                UpdateConfigEvent updateConfigEvent = (UpdateConfigEvent)event.getMetaEvent();
                Config config = updateConfigEvent.getNewConfig();
                this.doUpdateProperty(updateConfigEvent.getEventType(), new Config(config.getGroup(), config.getKey(), config.getValue()));
                break;
            }
            case REMOVE_CONFIG: {
                RemoveConfigEvent removeConfigEvent = (RemoveConfigEvent)event.getMetaEvent();
                Config config = removeConfigEvent.getConfig();
                this.doUpdateProperty(removeConfigEvent.getEventType(), new Config(config.getGroup(), config.getKey(), config.getValue()));
                break;
            }
        }
    }

    public static interface ConfigProvider {
        public List<Config> getConfigs();

        public String getConfig(String var1, String var2);
    }
}

