/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.config;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfigLoader {
    protected static final Logger logger = LoggerFactory.getLogger(SystemConfigLoader.class);
    protected static final Properties DEFAULT_PROPERTIES = new Properties();
    protected static final String SYSTEM_EVN_FILE = "system.properties";

    public static void load() {
        Properties sysEvn = new Properties();
        try {
            URL sysEnvFileUrl = SystemConfigLoader.class.getClassLoader().getResource(SYSTEM_EVN_FILE);
            if (null != sysEnvFileUrl) {
                logger.info("Found system properties file: {}.", (Object)sysEnvFileUrl);
                sysEvn.load(sysEnvFileUrl.openStream());
            } else {
                logger.info("No system properties file in classpath, using default properties.");
                sysEvn = DEFAULT_PROPERTIES;
            }
        }
        catch (IOException e) {
            logger.warn("load system config exception, using default.", (Throwable)e);
            sysEvn = DEFAULT_PROPERTIES;
        }
        sysEvn.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            logger.info("Set system property: {} -> {}.", k, v);
            System.setProperty(k.toString(), v.toString());
        }));
    }

    static {
        DEFAULT_PROPERTIES.setProperty("IGNITE_QUIET", "true");
        DEFAULT_PROPERTIES.setProperty("IGNITE_DUMP_THREADS_ON_FAILURE", "false");
        DEFAULT_PROPERTIES.setProperty("IGNITE_NO_ASCII", "true");
        DEFAULT_PROPERTIES.setProperty("IGNITE_UPDATE_NOTIFIER", "false");
    }
}

