/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.config.scan;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joyqueue.broker.config.scan.Scanner;
import org.joyqueue.toolkit.config.PropertyDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileScanner
implements Scanner {
    private static final Logger logger = LoggerFactory.getLogger(FileScanner.class);
    private String defaultClassPath = FileScanner.class.getResource("/").getPath();

    public String getDefaultClassPath() {
        return this.defaultClassPath;
    }

    public void setDefaultClassPath(String defaultClassPath) {
        this.defaultClassPath = defaultClassPath;
    }

    public FileScanner() {
    }

    public FileScanner(String defaultClassPath) {
        this.defaultClassPath = defaultClassPath;
    }

    @Override
    public Set<Class<?>> search(String pkgName) throws ClassNotFoundException, IOException {
        String classPath = this.defaultClassPath;
        String searchPath = classPath + pkgName;
        return new ClassSearcher().doPath(new File(searchPath), pkgName, true);
    }

    private static class ClassSearcher {
        private Set<Class<?>> classPaths = new HashSet(0);

        private ClassSearcher() {
        }

        private Set<Class<?>> doPath(File file, String pkgName, boolean flag) throws ClassNotFoundException, IOException {
            block7: {
                block6: {
                    if (!file.isDirectory()) break block6;
                    File[] files = file.listFiles();
                    if (!flag) {
                        pkgName = pkgName + "." + file.getName();
                    }
                    if (files == null) break block7;
                    for (File f : files) {
                        this.doPath(f, pkgName, false);
                    }
                    break block7;
                }
                if (file.isAbsolute() && file.getName().equals(PropertyDef.class.getName()) && file.exists()) {
                    List<String> classNames = Files.readAllLines(file.toPath());
                    for (String className : classNames) {
                        try {
                            this.classPaths.add(Class.forName(className));
                        }
                        catch (ClassNotFoundException e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
            }
            return this.classPaths;
        }
    }
}

