/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.config.scan;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.joyqueue.broker.config.scan.FileScanner;
import org.joyqueue.broker.config.scan.Scanner;
import org.joyqueue.toolkit.config.PropertyDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarScanner
implements Scanner {
    private static final Logger logger = LoggerFactory.getLogger(JarScanner.class);

    @Override
    public Set<Class<?>> search(String pkgName) {
        HashSet clazzSet = new HashSet(0);
        try {
            Enumeration<URL> urlEnumeration = Thread.currentThread().getContextClassLoader().getResources(pkgName);
            while (urlEnumeration.hasMoreElements()) {
                URL url = urlEnumeration.nextElement();
                String protocol = url.getProtocol();
                if ("jar".equalsIgnoreCase(protocol)) {
                    JarFile jarFile;
                    JarURLConnection connection = (JarURLConnection)url.openConnection();
                    if (connection == null || (jarFile = connection.getJarFile()) == null) continue;
                    Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
                    while (jarEntryEnumeration.hasMoreElements()) {
                        JarEntry entry = jarEntryEnumeration.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.contains(PropertyDef.class.getName())) continue;
                        Properties properties = new Properties();
                        properties.load(jarFile.getInputStream(entry));
                        Enumeration<?> enumeration = properties.propertyNames();
                        while (enumeration.hasMoreElements()) {
                            String key = (String)enumeration.nextElement();
                            try {
                                clazzSet.add(Class.forName(key));
                            }
                            catch (ClassNotFoundException e) {
                                logger.error(e.getMessage());
                            }
                        }
                    }
                    continue;
                }
                if (!"file".equalsIgnoreCase(protocol)) continue;
                FileScanner fileScanner = new FileScanner();
                fileScanner.setDefaultClassPath(url.getPath().replace(pkgName, ""));
                clazzSet.addAll(fileScanner.search(pkgName));
            }
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error(e.getMessage());
        }
        return clazzSet;
    }
}

