/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.PartitionManager;
import org.joyqueue.broker.consumer.model.ConsumePartition;
import org.joyqueue.broker.consumer.model.OwnerShip;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.retry.RetryProbability;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.toolkit.concurrent.CasLock;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasPartitionManager
implements PartitionManager {
    private static final Logger logger = LoggerFactory.getLogger(CasPartitionManager.class);
    private static final long CLEAN_INTERVAL_MS = 1800000L;
    private ClusterManager clusterManager;
    private ConcurrentMap<ConsumePartition, PartitionLock> ownerShipCache = new ConcurrentHashMap<ConsumePartition, PartitionLock>();
    private final Random random = new Random();
    private RetryProbability retryProbability = new RetryProbability();
    private CounterService counterService = new CounterService();
    private ScheduledExecutorService cleanUpExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("CasPartitionManagerCleanUpExecutor", true));

    public CasPartitionManager(ClusterManager clusterManager, SessionManager sessionManager) {
        this.clusterManager = clusterManager;
        sessionManager.addListener(new RemoveOccupyListener());
        this.cleanUpExecutor.scheduleAtFixedRate(this::cleanup, 1800000L, 1800000L, TimeUnit.MILLISECONDS);
    }

    private void cleanup() {
        this.ownerShipCache.entrySet().removeIf(entry -> {
            PartitionLock partitionLock = (PartitionLock)entry.getValue();
            if (partitionLock != null) {
                return partitionLock.canBeDeleted(1800000L);
            }
            return true;
        });
    }

    @Override
    public boolean tryOccupyPartition(Consumer consumer, short partition, long occupyTimeout) {
        PartitionLock newPartitionLock;
        ConsumePartition consumePartition = new ConsumePartition(consumer.getTopic(), consumer.getApp(), partition);
        consumePartition.setConnectionId(consumer.getConnectionId());
        String clientId = consumer.getId();
        if (null == clientId) {
            logger.warn("tryOccupyPartition failed, cause: clientId can not be null! consumer: {}, partition: {}", (Object)consumer, (Object)partition);
            return false;
        }
        if (this.counterService.lockMorePartition(consumer)) {
            logger.info("Lock more partitions, consumer:{}", (Object)consumer);
            return false;
        }
        PartitionLock partitionLock = (PartitionLock)this.ownerShipCache.get(consumePartition);
        if (partitionLock == null && (newPartitionLock = this.ownerShipCache.putIfAbsent(consumePartition, partitionLock = new PartitionLock(this.counterService))) != null) {
            partitionLock = newPartitionLock;
        }
        return partitionLock.tryLock(clientId, occupyTimeout);
    }

    private boolean releaseOccupy(ConsumePartition consumePartition) {
        PartitionLock partitionLock = (PartitionLock)this.ownerShipCache.get(consumePartition);
        if (partitionLock != null) {
            partitionLock.release();
        }
        return true;
    }

    @Override
    public boolean releasePartition(Consumer consumer, short partition) {
        ConsumePartition consumePartition = new ConsumePartition(consumer.getTopic(), consumer.getApp(), partition);
        return this.releasePartition(consumePartition);
    }

    @Override
    public boolean releasePartition(ConsumePartition consumePartition) {
        return this.releaseOccupy(consumePartition);
    }

    @Override
    public boolean needPause(Consumer consumer) throws JoyQueueException {
        Consumer.ConsumerPolicy consumerPolicy = this.clusterManager.getConsumerPolicy(TopicName.parse((String)consumer.getTopic()), consumer.getApp());
        Boolean isNeedPause = consumerPolicy.getPaused();
        return isNeedPause == null ? false : isNeedPause;
    }

    @Override
    public void increaseSerialErr(OwnerShip ownerShip) {
        this.counterService.increaseErrTimes(ownerShip.getOwner());
    }

    @Override
    public void clearSerialErr(Consumer consumer) {
        this.counterService.clearErrTimes(consumer);
    }

    @Override
    public int selectPartitionIndex(int partitionSize, int partitionIndex, long accessTimes) {
        int index = partitionIndex < 0 ? (int)(accessTimes % (long)partitionSize) : partitionIndex % partitionSize;
        return index;
    }

    @Override
    public boolean isRetry(Consumer consumer) throws JoyQueueException {
        int randomBound = this.clusterManager.getRetryRandomBound(consumer.getTopic(), consumer.getApp());
        if (randomBound <= 0) {
            return false;
        }
        Boolean retry = this.clusterManager.getConsumerPolicy(TopicName.parse((String)consumer.getTopic()), consumer.getApp()).getRetry();
        List<Short> masterPartitionList = this.clusterManager.getLocalPartitions(TopicName.parse((String)consumer.getTopic()));
        if (!retry.booleanValue() || !masterPartitionList.contains((short)0)) {
            logger.debug("retry enable is false.");
            return false;
        }
        int val = this.random.nextInt(randomBound);
        int rate = this.retryProbability.getProbability(consumer.getJoint());
        return rate >= val;
    }

    @Override
    public void resetRetryProbability(Integer maxProbability) {
        this.retryProbability.resetMaxProbability(maxProbability);
    }

    @Override
    public void increaseRetryProbability(Consumer consumer) {
        this.retryProbability.increase(consumer.getJoint());
    }

    @Override
    public void decreaseRetryProbability(Consumer consumer) {
        this.retryProbability.decrease(consumer.getJoint());
    }

    @Override
    public List<Short> getPriorityPartition(TopicName topic) {
        List<Short> priorityPartitionList = this.clusterManager.getPriorityPartitionList(topic);
        if (CollectionUtils.isEmpty(priorityPartitionList)) {
            priorityPartitionList = new ArrayList<Short>(0);
        }
        return priorityPartitionList;
    }

    @Override
    public int getGroupByPartition(TopicName topic, short partition) {
        Integer partitionGroupId = this.clusterManager.getPartitionGroupId(topic, partition);
        if (partitionGroupId != null) {
            return partitionGroupId;
        }
        throw new IllegalArgumentException("Cannot find partitionGroup by topic:[" + topic + "],partition:[" + partition + "]");
    }

    @Override
    public boolean hasFreePartition(Consumer consumer) {
        boolean isFree = false;
        String clientId = consumer.getId();
        int occupyNum = this.counterService.getOccupyTimes(clientId);
        List<Short> masterPartitionList = this.clusterManager.getLocalPartitions(TopicName.parse((String)consumer.getTopic()));
        int partitionNum = masterPartitionList.size();
        if (partitionNum > occupyNum) {
            isFree = true;
        }
        return isFree;
    }

    @Override
    public void close() {
        this.cleanUpExecutor.shutdown();
    }

    class RemoveOccupyListener
    implements EventListener<SessionManager.SessionEvent> {
        RemoveOccupyListener() {
        }

        public void onEvent(SessionManager.SessionEvent event) {
            if (event.getType() == SessionManager.SessionEventType.RemoveConsumer) {
                logger.info("Listen SessionManager.SessionEventType.RemoveConsumer, Event:[{}]", (Object)event);
                Consumer consumer = event.getConsumer();
                this.removeOccupyByConsumer(consumer);
            }
        }

        private void removeOccupyByConsumer(Consumer consumer) {
            List<Short> masterPartitionList = CasPartitionManager.this.clusterManager.getLocalPartitions(TopicName.parse((String)consumer.getTopic()));
            String clientId = consumer.getId();
            masterPartitionList.forEach(partition -> {
                ConsumePartition consumePartition = new ConsumePartition(consumer.getTopic(), consumer.getApp(), (short)partition);
                PartitionLock ownerShip = (PartitionLock)CasPartitionManager.this.ownerShipCache.get(consumePartition);
                if (ownerShip != null) {
                    ownerShip.tryRelease(clientId);
                }
            });
            CasPartitionManager.this.counterService.clearOccupyTimes(clientId);
            CasPartitionManager.this.counterService.clearErrTimes(consumer);
        }
    }

    static class PartitionLock {
        private final AtomicBoolean locked = new AtomicBoolean(false);
        private final CasLock casLock = new CasLock();
        private final AtomicLong timestamp = new AtomicLong(SystemClock.now());
        private String lockedBy = null;
        private final CounterService counterService;
        private long lastTimeoutMs = 0L;

        PartitionLock(CounterService counterService) {
            this.counterService = counterService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean tryLock(String consumer, long timeoutMs) {
            if (this.casLock.tryLock()) {
                try {
                    this.maybeReleaseTimeout(timeoutMs);
                    if (this.locked.compareAndSet(false, true)) {
                        this.counterService.increaseOccupyTimes(consumer);
                        this.lockedBy = consumer;
                        this.timestamp.set(SystemClock.now());
                        this.lastTimeoutMs = timeoutMs;
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.casLock.unlock();
                }
            }
            return false;
        }

        void tryRelease(String consumer) {
            if (null != consumer && this.locked.get() && consumer.equals(this.lockedBy)) {
                this.casLock.waitAndLock();
                try {
                    if (consumer.equals(this.lockedBy) && this.locked.compareAndSet(true, false)) {
                        this.timestamp.set(SystemClock.now());
                        this.lockedBy = null;
                        this.counterService.decreaseOccupyTimes(consumer);
                    }
                }
                finally {
                    this.casLock.unlock();
                }
            }
        }

        void release() {
            if (this.locked.get()) {
                this.casLock.waitAndLock();
                try {
                    if (this.locked.compareAndSet(true, false)) {
                        this.timestamp.set(SystemClock.now());
                        String consumer = this.lockedBy;
                        this.lockedBy = null;
                        this.counterService.decreaseOccupyTimes(consumer);
                    }
                }
                finally {
                    this.casLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeReleaseTimeout(long timeoutMs) {
            long finalTimestamp = this.timestamp.get();
            long now = SystemClock.now();
            if (this.locked.get() && finalTimestamp + timeoutMs < now && this.casLock.tryLock()) {
                try {
                    if (finalTimestamp == this.timestamp.get() && this.locked.compareAndSet(true, false)) {
                        String consumer = this.lockedBy;
                        this.timestamp.set(now);
                        this.lockedBy = null;
                        this.counterService.increaseErrTimes(consumer);
                        this.counterService.decreaseOccupyTimes(consumer);
                    }
                }
                finally {
                    this.casLock.unlock();
                }
            }
        }

        boolean isLocked() {
            this.maybeReleaseTimeout(this.lastTimeoutMs);
            return this.locked.get();
        }

        boolean canBeDeleted(long deleteTimeout) {
            long finalTimestamp = this.timestamp.get();
            return !this.isLocked() && finalTimestamp == this.timestamp.get() && finalTimestamp + deleteTimeout < SystemClock.now();
        }
    }

    private class CounterService {
        private ConcurrentMap<String, Counter> occupyCounter = new ConcurrentHashMap<String, Counter>();
        private ConcurrentMap<String, Counter> errCounter = new ConcurrentHashMap<String, Counter>();

        private CounterService() {
        }

        private void increaseOccupyTimes(String clientId) {
            Counter counter = (Counter)this.occupyCounter.get(clientId);
            if (counter == null) {
                counter = new Counter();
                this.occupyCounter.put(clientId, counter);
            }
            counter.increase();
        }

        private void decreaseOccupyTimes(String clientId) {
            Counter counter = (Counter)this.occupyCounter.get(clientId);
            if (counter == null) {
                return;
            }
            counter.decrease();
        }

        private void clearOccupyTimes(String clientId) {
            Counter counter = (Counter)this.occupyCounter.get(clientId);
            if (counter == null) {
                return;
            }
            this.occupyCounter.remove(clientId);
        }

        private int getOccupyTimes(String clientId) {
            Counter counter = (Counter)this.occupyCounter.get(clientId);
            if (counter == null) {
                return 0;
            }
            if (counter.isExpire()) {
                counter.clearTimes();
                return 0;
            }
            return counter.getTimes();
        }

        private boolean lockMorePartition(Consumer consumer) {
            String topic = consumer.getTopic();
            String app = consumer.getApp();
            int maxPartitionNum = 0;
            try {
                Consumer.ConsumerPolicy consumerPolicy = CasPartitionManager.this.clusterManager.getConsumerPolicy(TopicName.parse((String)topic), app);
                maxPartitionNum = consumerPolicy.getMaxPartitionNum();
            }
            catch (JoyQueueException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            String clientId = consumer.getId();
            return this.getOccupyTimes(clientId) > maxPartitionNum;
        }

        private int getErrTimes(Consumer consumer) {
            String clientId = consumer.getId();
            Counter counterObj = (Counter)this.errCounter.get(clientId);
            if (counterObj == null) {
                return 0;
            }
            if (counterObj.isExpire()) {
                counterObj.clearTimes();
                return 0;
            }
            return counterObj.getTimes();
        }

        private void increaseErrTimes(String clientId) {
            Counter counterObj = (Counter)this.errCounter.get(clientId);
            if (counterObj == null) {
                counterObj = new Counter();
                this.errCounter.put(clientId, counterObj);
            }
            counterObj.increase();
        }

        private void clearErrTimes(Consumer consumer) {
            String clientId = consumer.getId();
            this.errCounter.remove(clientId);
        }

        private class Counter {
            AtomicInteger times = new AtomicInteger(0);
            final long createTime = SystemClock.now();
            volatile long updateTime = SystemClock.now();

            private Counter() {
            }

            void increase() {
                this.times.incrementAndGet();
                this.updateTime = SystemClock.now();
            }

            int decrease() {
                this.updateTime = SystemClock.now();
                return this.times.decrementAndGet();
            }

            boolean isExpire() {
                return SystemClock.now() - this.updateTime > 60000L;
            }

            void clearTimes() {
                this.times.set(0);
            }

            int getTimes() {
                return this.times.get();
            }
        }
    }
}

