/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer;

import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.archive.ArchiveManager;
import org.joyqueue.broker.archive.ConsumeArchiveService;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.AcknowledgeSupport;
import org.joyqueue.broker.consumer.ConcurrentConsumer;
import org.joyqueue.broker.consumer.DelayHandler;
import org.joyqueue.broker.consumer.FilterMessageSupport;
import org.joyqueue.broker.consumer.PartitionLockInstance;
import org.joyqueue.broker.consumer.PartitionManager;
import org.joyqueue.broker.consumer.filter.FilterCallback;
import org.joyqueue.broker.consumer.model.ConsumePartition;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.broker.consumer.position.PositionManager;
import org.joyqueue.broker.consumer.position.model.Position;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.MessageLocation;
import org.joyqueue.network.session.Connection;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.PositionOverflowException;
import org.joyqueue.store.PositionUnderflowException;
import org.joyqueue.store.ReadResult;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.concurrent.LoopThread;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class ConcurrentConsumption
extends Service
implements ConcurrentConsumer {
    private final Logger logger = LoggerFactory.getLogger(ConcurrentConsumption.class);
    private PartitionManager partitionManager;
    private MessageRetry messageRetry;
    private PositionManager positionManager;
    private StoreService storeService;
    private ClusterManager clusterManager;
    private FilterMessageSupport filterMessageSupport;
    private ConcurrentMap<ConsumePartition, Boolean> resetPullPositionFlag = new ConcurrentHashMap<ConsumePartition, Boolean>();
    private ConcurrentMap<PartitionSegment, Long> segmentConsumeMap = new ConcurrentHashMap<PartitionSegment, Long>();
    private ConcurrentMap<ConsumePartition, ConcurrentLinkedQueue<PartitionSegment>> expireQueueMap = new ConcurrentHashMap<ConsumePartition, ConcurrentLinkedQueue<PartitionSegment>>(1000);
    private ConcurrentMap<ConsumePartition, AtomicInteger> consumerSegmentNumMap = new ConcurrentHashMap<ConsumePartition, AtomicInteger>();
    private LoopThread moveExpireThread;
    private LoopThread cleanExpireThread;
    private ConcurrentMap<ConsumePartition, List<Position>> concurrentConsumeCache = new ConcurrentHashMap<ConsumePartition, List<Position>>();
    private PartitionLockInstance lockInstance = new PartitionLockInstance();
    private DelayHandler delayHandler = new DelayHandler();
    private ArchiveManager archiveManager;
    private SessionManager sessionManager;
    private final String innerAppPrefix = "innerFilter@";

    ConcurrentConsumption(ClusterManager clusterManager, StoreService storeService, PartitionManager partitionManager, MessageRetry messageRetry, PositionManager positionManager, FilterMessageSupport filterMessageSupport, ArchiveManager archiveManager, SessionManager sessionManager) {
        this.clusterManager = clusterManager;
        this.storeService = storeService;
        this.partitionManager = partitionManager;
        this.messageRetry = messageRetry;
        this.positionManager = positionManager;
        this.filterMessageSupport = filterMessageSupport;
        this.archiveManager = archiveManager;
        this.sessionManager = sessionManager;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.moveExpireThread = LoopThread.builder().sleepTime(5000L, 5000L).name("JournalQ-concurrent-consumption-move-expire-Thread").onException(e -> this.logger.warn("Exception:", e)).doWork(() -> this.moveSegment2ExpireQueue()).build();
        this.moveExpireThread.start();
        this.cleanExpireThread = LoopThread.builder().sleepTime(5000L, 5000L).name("JournalQ-concurrent-consumption-clean-expire-Thread").onException(e -> this.logger.warn("Exception:", e)).doWork(() -> this.cleanExpireQueue()).build();
        this.cleanExpireThread.start();
        this.logger.info("ConcurrentConsumer is started.");
        this.sessionManager.addListener(new MovePartitionSegmentListener());
    }

    protected void doStop() {
        super.doStop();
        Close.close((LifeCycle)this.moveExpireThread);
        Close.close((LifeCycle)this.cleanExpireThread);
        this.logger.info("ConcurrentConsumer is stopped.");
    }

    @Override
    public PullResult getMessage(org.joyqueue.network.session.Consumer consumer, int count, long ackTimeout, long accessTimes, int concurrent) throws JoyQueueException {
        List<Short> partitionList = this.clusterManager.getLocalPartitions(TopicName.parse((String)consumer.getTopic()));
        PartitionSegment partitionSegment = this.pollPartitionSegment(consumer, partitionList);
        PullResult pullResult = new PullResult(consumer, -1, new ArrayList<ByteBuffer>(0));
        if (partitionSegment != null) {
            pullResult = this.getFromExpireAckQueue(consumer, partitionSegment, accessTimes);
        } else if (this.partitionManager.isRetry(consumer)) {
            List retryMessage = this.messageRetry.getRetry(consumer.getTopic(), consumer.getApp(), (short)count, 0L);
            List<ByteBuffer> messages = this.convert(retryMessage);
            pullResult.setBuffers(messages);
            if (messages.size() > 0) {
                this.partitionManager.increaseRetryProbability(consumer);
            } else {
                this.partitionManager.decreaseRetryProbability(consumer);
            }
        } else {
            List<Short> priorityPartitionList = this.partitionManager.getPriorityPartition(TopicName.parse((String)consumer.getTopic()));
            pullResult = priorityPartitionList.size() > 0 ? this.getFromPartition(consumer, priorityPartitionList, count, ackTimeout, accessTimes, concurrent) : this.getFromPartition(consumer, partitionList, count, ackTimeout, accessTimes, concurrent);
        }
        return pullResult;
    }

    private void innerAcknowledge(org.joyqueue.network.session.Consumer consumer, List<ByteBuffer> inValidList) throws JoyQueueException {
        if (inValidList == null) {
            return;
        }
        MessageLocation[] messageLocations = this.convertMessageLocation(consumer.getTopic(), inValidList);
        this.acknowledge(messageLocations, consumer, true);
        this.archiveIfnecessary(messageLocations);
    }

    private void archiveIfnecessary(MessageLocation[] messageLocations) throws JoyQueueException {
        ConsumeArchiveService archiveService;
        if (this.archiveManager == null || (archiveService = this.archiveManager.getConsumeArchiveService()) == null) {
            return;
        }
        Connection connection = new Connection();
        try {
            connection.setAddress(IpUtil.toByte((InetSocketAddress)new InetSocketAddress(IpUtil.getLocalIp(), 50088)));
        }
        catch (Exception ex) {
            connection.setAddress(new byte[0]);
        }
        connection.setApp("innerFilter@" + connection.getApp());
        archiveService.appendConsumeLog(connection, messageLocations);
    }

    private MessageLocation[] convertMessageLocation(String topic, List<ByteBuffer> inValidList) {
        MessageLocation[] locations = new MessageLocation[inValidList.size()];
        for (int i = 0; i < inValidList.size(); ++i) {
            ByteBuffer buffer = inValidList.get(i);
            short partition = Serializer.readPartition(buffer);
            long index = Serializer.readIndex(buffer);
            locations[i] = new MessageLocation(topic, partition, index);
        }
        return locations;
    }

    private List<ByteBuffer> convert(List<RetryMessageModel> retryMessage) throws JoyQueueException {
        if (CollectionUtils.isEmpty(retryMessage)) {
            return new ArrayList<ByteBuffer>(0);
        }
        ArrayList<ByteBuffer> rst = new ArrayList<ByteBuffer>(retryMessage.size());
        for (RetryMessageModel message : retryMessage) {
            try {
                ByteBuffer wrap = ByteBuffer.wrap(message.getBrokerMessage());
                Serializer.setPartition(wrap, (short)Short.MAX_VALUE);
                Serializer.setIndex(wrap, message.getIndex());
                rst.add(wrap);
            }
            catch (Exception e) {
                throw new JoyQueueException(JoyQueueCode.SE_IO_ERROR, (Throwable)e, new Object[0]);
            }
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PullResult getFromExpireAckQueue(org.joyqueue.network.session.Consumer consumer, PartitionSegment partitionSegment, long ackTimeout) throws JoyQueueException {
        short partition = partitionSegment.getPartition();
        ConsumePartition consumePartition = this.lockInstance.getLockInstance(consumer.getTopic(), consumer.getApp(), partition);
        synchronized (consumePartition) {
            int segmentCount = (int)(partitionSegment.getEndIndex() - partitionSegment.getStartIndex()) + 1;
            long index = partitionSegment.getStartIndex();
            PullResult pullResult = this.readMessages(consumer, partition, index, segmentCount);
            int msgCount = pullResult.getBuffers().size();
            ArrayList<Long> indexList = new ArrayList<Long>();
            for (int j = 0; j < msgCount; ++j) {
                indexList.add(index + (long)j);
            }
            this.logger.info("readExpireMessages, partition: {}, index: {}, size: {}", new Object[]{partition, indexList, ((ConcurrentLinkedQueue)this.expireQueueMap.get(new ConsumePartition(partitionSegment.getTopic(), partitionSegment.getApp(), partitionSegment.getPartition()))).size()});
            if (msgCount > 0) {
                this.trackConsumeDetail(consumer, partition, partitionSegment.getStartIndex(), partitionSegment.getEndIndex(), ackTimeout, false);
            }
            return pullResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PullResult getFromPartition(org.joyqueue.network.session.Consumer consumer, List<Short> partitionList, int count, long ackTimeout, long accessTimes, int concurrent) throws JoyQueueException {
        int partitionSize = partitionList.size();
        int listIndex = -1;
        PullResult pullResult = new PullResult(consumer, -1, new ArrayList<ByteBuffer>(0));
        for (int i = 0; i < partitionSize; ++i) {
            listIndex = this.partitionManager.selectPartitionIndex(partitionSize, listIndex + i, accessTimes);
            short partition = partitionList.get(listIndex);
            ConsumePartition consumePartition = this.lockInstance.getLockInstance(consumer.getTopic(), consumer.getApp(), partition);
            synchronized (consumePartition) {
                if (this.isExceedConcurrent(consumer, partition, concurrent)) {
                    continue;
                }
                long pullIndex = this.getPullIndex(consumer, partition);
                this.logger.debug("get pull index:{}, topic:{}, app:{}, partition:{}", new Object[]{pullIndex, consumer.getTopic(), consumer.getApp(), partition});
                pullResult = this.readMessages(consumer, partition, pullIndex, count);
                int msgCount = this.count(pullResult);
                if (msgCount > 0) {
                    ArrayList<Long> indexList = new ArrayList<Long>();
                    for (int j = 0; j < msgCount; ++j) {
                        indexList.add(pullIndex + (long)j);
                    }
                    long newPullIndex = pullIndex + (long)msgCount;
                    this.logger.debug("set new pull index:{}, topic:{}, app:{}, partition:{}", new Object[]{newPullIndex, consumer.getTopic(), consumer.getApp(), partition});
                    this.positionManager.updateLastMsgPullIndex(TopicName.parse((String)consumer.getTopic()), consumer.getApp(), partition, newPullIndex);
                    long endIndex = newPullIndex - 1L;
                    this.trackConsumeDetail(consumer, partition, pullIndex, endIndex, ackTimeout, true);
                    break;
                }
                continue;
            }
        }
        return pullResult;
    }

    private int count(PullResult pullResult) {
        int count = 0;
        List<ByteBuffer> buffers = pullResult.getBuffers();
        for (ByteBuffer buffer : buffers) {
            BrokerMessage header = Serializer.readBrokerMessageHeader(buffer);
            if (header.isBatch()) {
                count += header.getFlag();
                continue;
            }
            ++count;
        }
        return count;
    }

    private boolean isExceedConcurrent(org.joyqueue.network.session.Consumer consumer, short partition, int concurrent) {
        AtomicInteger counter = (AtomicInteger)this.consumerSegmentNumMap.get(new ConsumePartition(consumer.getTopic(), consumer.getApp(), partition));
        return counter != null && counter.get() >= concurrent;
    }

    private void releaseConcurrentCounter(ConsumePartition consumePartition) {
        AtomicInteger counter = (AtomicInteger)this.consumerSegmentNumMap.get(consumePartition);
        if (counter != null) {
            counter.decrementAndGet();
        }
    }

    private int increaseConcurrentCounter(ConsumePartition consumePartition) {
        AtomicInteger previous;
        AtomicInteger occupyCounter = (AtomicInteger)this.consumerSegmentNumMap.get(consumePartition);
        if (occupyCounter == null && (previous = this.consumerSegmentNumMap.putIfAbsent(consumePartition, occupyCounter = new AtomicInteger(0))) != null) {
            occupyCounter = previous;
        }
        return occupyCounter.incrementAndGet();
    }

    private PartitionSegment pollPartitionSegment(org.joyqueue.network.session.Consumer consumer, List<Short> partitionList) {
        for (Short partition : partitionList) {
            ConsumePartition consumePartition = new ConsumePartition(consumer.getTopic(), consumer.getApp(), partition);
            ConcurrentLinkedQueue partitionSegmentQueue = (ConcurrentLinkedQueue)this.expireQueueMap.get(consumePartition);
            if (partitionSegmentQueue == null || partitionSegmentQueue.isEmpty()) continue;
            return (PartitionSegment)partitionSegmentQueue.poll();
        }
        return null;
    }

    private long getPullIndex(org.joyqueue.network.session.Consumer consumer, short partition) throws JoyQueueException {
        long pullIndex = 0L;
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        ConsumePartition consumePartition = new ConsumePartition(topic, app, partition);
        TopicName topicName = TopicName.parse((String)topic);
        Boolean isReset = (Boolean)this.resetPullPositionFlag.get(consumePartition);
        if (isReset != null && isReset.booleanValue()) {
            pullIndex = this.positionManager.getLastMsgPullIndex(topicName, app, partition);
            if (pullIndex == -1L) {
                this.concurrentConsumeCache.remove(consumePartition);
                this.positionManager.updateLastMsgPullIndex(topicName, app, partition, this.positionManager.getLastMsgAckIndex(topicName, app, partition));
            }
        } else {
            long lastAckIndex = this.positionManager.getLastMsgAckIndex(topicName, app, partition);
            boolean isSuccess = this.positionManager.updateLastMsgPullIndex(topicName, app, partition, lastAckIndex);
            if (isSuccess) {
                this.resetPullPositionFlag.put(consumePartition, Boolean.TRUE);
                pullIndex = lastAckIndex;
            }
            this.logger.info("init concurrent pull index [{}]", (Object)pullIndex);
        }
        return pullIndex;
    }

    private PullResult readMessages(org.joyqueue.network.session.Consumer consumer, short partition, long index, int count) throws JoyQueueException {
        PullResult pullResult = new PullResult(consumer, -1, new ArrayList<ByteBuffer>(0));
        try {
            int partitionGroup = this.clusterManager.getPartitionGroupId(TopicName.parse((String)consumer.getTopic()), partition);
            PartitionGroupStore store = this.storeService.getStore(consumer.getTopic(), partitionGroup);
            ReadResult readRst = store.read(partition, index, count, Long.MAX_VALUE);
            if (readRst.getCode() == JoyQueueCode.SUCCESS) {
                ArrayList byteBufferList = Lists.newArrayList((Object[])readRst.getMessages());
                Consumer consumerConfig = this.clusterManager.getConsumer(TopicName.parse((String)consumer.getTopic()), consumer.getApp());
                if (consumerConfig != null) {
                    List<ByteBuffer> byteBuffers = this.filterMessageSupport.filter(consumerConfig, byteBufferList, new FilterCallbackImpl(consumer));
                    byteBuffers = this.delayHandler.handle(consumerConfig.getConsumerPolicy(), byteBuffers);
                    pullResult = new PullResult(consumer, partition, byteBuffers);
                }
            } else {
                this.logger.error("read message error, error code[{}]", (Object)readRst.getCode());
            }
        }
        catch (PositionOverflowException e) {
            if (e.getRight() < index) {
                pullResult.setCode(JoyQueueCode.SE_INDEX_OVERFLOW);
            }
        }
        catch (PositionUnderflowException e) {
            pullResult.setCode(JoyQueueCode.SE_INDEX_UNDERFLOW);
        }
        catch (Exception ex) {
            this.logger.error("get message error, consumer: {}, partition: {}", new Object[]{consumer, partition, ex});
        }
        return pullResult;
    }

    private void trackConsumeDetail(org.joyqueue.network.session.Consumer consumer, short partition, long startIndex, long endIndex, long ackTimeOut, boolean increaseCounter) {
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        PartitionSegment partitionSegment = new PartitionSegment(topic, app, partition, startIndex, endIndex);
        long expire = ackTimeOut + SystemClock.now();
        this.segmentConsumeMap.put(partitionSegment, expire);
        if (increaseCounter) {
            List oldPositions;
            this.increaseConcurrentCounter(new ConsumePartition(topic, app, partition));
            List<Position> positions = (ArrayList<Position>)this.concurrentConsumeCache.get(new ConsumePartition(topic, app, partition));
            if (positions == null && (oldPositions = (List)this.concurrentConsumeCache.putIfAbsent(new ConsumePartition(topic, app, partition), positions = new ArrayList<Position>())) != null) {
                positions = oldPositions;
            }
            positions.add(new Position(startIndex, endIndex, -1L, -1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acknowledge(MessageLocation[] locations, org.joyqueue.network.session.Consumer consumer, boolean isSuccessAck) throws JoyQueueException {
        boolean isSuccess = false;
        if (locations.length < 1) {
            return false;
        }
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        short partition = locations[0].getPartition();
        if (partition == Short.MAX_VALUE) {
            return this.retryAck(topic, app, locations, isSuccessAck);
        }
        long[] locationArray = new long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            locationArray[i] = locations[i].getIndex();
        }
        this.logger.debug("pre ack, partition: {}, index: {}", (Object)partition, (Object)locationArray);
        long[] indexArr = AcknowledgeSupport.sortMsgLocation(locations);
        if (indexArr != null) {
            PartitionSegment partitionSegment = new PartitionSegment(topic, app, partition, indexArr[0], indexArr[1]);
            ConsumePartition consumePartition = new ConsumePartition(topic, app, partition);
            ConsumePartition consumePartition2 = this.lockInstance.getLockInstance(consumePartition);
            synchronized (consumePartition2) {
                this.tryUpdateAckPosition(consumePartition, indexArr);
                this.segmentConsumeMap.remove(partitionSegment);
                this.removeFromExpireQueue(consumePartition, partitionSegment);
                isSuccess = true;
                this.releaseConcurrentCounter(consumePartition);
            }
        }
        return isSuccess;
    }

    private boolean retryAck(String topic, String app, MessageLocation[] locations, boolean isSuccess) {
        Object[] indexArr = new Long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            indexArr[i] = locations[i].getIndex();
        }
        try {
            if (isSuccess) {
                this.messageRetry.retrySuccess(topic, app, indexArr);
            } else {
                this.messageRetry.retryError(topic, app, indexArr);
            }
        }
        catch (JoyQueueException e) {
            this.logger.error("RetryAck error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean isExpireQueueContains(ConsumePartition consumePartition, PartitionSegment partitionSegment) {
        boolean isContains = false;
        ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)this.expireQueueMap.get(consumePartition);
        if (queue != null && partitionSegment != null) {
            isContains = queue.contains(partitionSegment);
        }
        return isContains;
    }

    private void removeFromExpireQueue(ConsumePartition consumePartition, PartitionSegment partitionSegment) {
        ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)this.expireQueueMap.get(consumePartition);
        if (queue != null && partitionSegment != null) {
            queue.remove(partitionSegment);
        }
    }

    private void addToExpireQueue(ConsumePartition consumePartition, PartitionSegment partitionSegment) {
        ConcurrentLinkedQueue pre;
        ConcurrentLinkedQueue<PartitionSegment> queue = (ConcurrentLinkedQueue<PartitionSegment>)this.expireQueueMap.get(consumePartition);
        if (queue == null && (pre = this.expireQueueMap.putIfAbsent(consumePartition, queue = new ConcurrentLinkedQueue<PartitionSegment>())) != null) {
            queue = pre;
        }
        if (queue.contains(partitionSegment)) {
            return;
        }
        queue.offer(partitionSegment);
        long size = queue.size();
        this.logger.debug("add expire queue, partition: {}, size: {}, start: {}, end: {}", new Object[]{partitionSegment.getPartition(), size, partitionSegment.getStartIndex(), partitionSegment.getEndIndex()});
        this.logger.debug("expire queue size is:[{}], partitionInfo:[{}], ", (Object)size, (Object)consumePartition);
        if (queue.size() > 10000) {
            this.logger.info("expire queue size is:[{}], partitionInfo:[{}], ", (Object)size, (Object)consumePartition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSegment2ExpireQueue() {
        Iterator iterator = this.segmentConsumeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            PartitionSegment next = (PartitionSegment)entry.getKey();
            ConsumePartition consumePartition = new ConsumePartition(next.getTopic(), next.getApp(), next.getPartition());
            ConsumePartition consumePartition2 = this.lockInstance.getLockInstance(consumePartition);
            synchronized (consumePartition2) {
                long now;
                if (!this.segmentConsumeMap.containsKey(next)) {
                    continue;
                }
                long expireTime = (Long)entry.getValue();
                if (expireTime >= (now = SystemClock.now())) {
                    this.addToExpireQueue(consumePartition, next);
                    iterator.remove();
                }
            }
        }
    }

    private void cleanExpireQueue() {
        ConcurrentMap<ConsumePartition, ConcurrentLinkedQueue<PartitionSegment>> expired = this.expireQueueMap;
        ArrayList<ConsumePartition> removed = new ArrayList<ConsumePartition>();
        for (Map.Entry entry : expired.entrySet()) {
            ConsumePartition consumePartition = (ConsumePartition)entry.getKey();
            try {
                Consumer.ConsumerPolicy policy = this.clusterManager.getConsumerPolicy(TopicName.parse((String)consumePartition.getTopic()), consumePartition.getApp());
                if (policy.isConcurrent().booleanValue()) continue;
                removed.add(consumePartition);
            }
            catch (Exception e) {
                this.logger.warn("clean expire error", (Object)e.getMessage());
            }
        }
        ConcurrentMap<ConsumePartition, AtomicInteger> consumerCounter = this.consumerSegmentNumMap;
        ConcurrentMap<ConsumePartition, List<Position>> concurrentConsumeCacheMap = this.concurrentConsumeCache;
        removed.forEach(ele -> {
            expired.remove(ele);
            consumerCounter.remove(ele);
            concurrentConsumeCacheMap.remove(ele);
        });
    }

    private void tryUpdateAckPosition(ConsumePartition consumePartition, long[] indexArr) throws JoyQueueException {
        String topic = consumePartition.getTopic();
        String app = consumePartition.getApp();
        short partition = consumePartition.getPartition();
        long lastMsgAckIndex = this.positionManager.getLastMsgAckIndex(TopicName.parse((String)topic), app, partition);
        List<Position> positions = this.sortPositions(consumePartition);
        Position currentPosition = null;
        if (CollectionUtils.isEmpty(positions)) {
            this.logger.warn("current position is null, positions is empty, partition: {}, startIndex: {}, endIndex: {}", new Object[]{partition, indexArr[0], indexArr[1]});
            return;
        }
        for (Position position : positions) {
            if (position.getAckStartIndex() != indexArr[0] || position.getAckCurIndex() != indexArr[1]) continue;
            currentPosition = position;
            break;
        }
        if (currentPosition == null) {
            this.logger.warn("current position is null, partition: {}, startIndex: {}, endIndex: {}", new Object[]{partition, indexArr[0], indexArr[1]});
            return;
        }
        if (currentPosition.isAck()) {
            return;
        }
        Position headPosition = positions.get(0);
        currentPosition.setAck(true);
        if (headPosition.isAck() && headPosition.getAckStartIndex() == lastMsgAckIndex) {
            Position position;
            LinkedList committedPositions = Lists.newLinkedList();
            for (int i = 0; i < positions.size() && (position = positions.get(i)).isAck() && position.getAckStartIndex() == lastMsgAckIndex; ++i) {
                lastMsgAckIndex = position.getAckCurIndex() + 1L;
                committedPositions.add(position);
            }
            if (committedPositions.isEmpty()) {
                this.logger.info("commit index failed, partition: {}, head: {}, index: {}", new Object[]{partition, headPosition.getAckStartIndex(), lastMsgAckIndex});
            } else {
                positions.removeAll(committedPositions);
                this.concurrentConsumeCache.put(consumePartition, positions);
                this.positionManager.updateLastMsgAckIndex(TopicName.parse((String)topic), app, partition, lastMsgAckIndex, false);
                this.logger.debug("commit index, partition: {}, index: {}", (Object)partition, (Object)lastMsgAckIndex);
            }
        } else {
            this.logger.debug("commit index failed, partition: {}, head: {}, index: {}, ack: {}", new Object[]{partition, headPosition.getAckStartIndex(), lastMsgAckIndex, headPosition.isAck()});
        }
    }

    private void addAckSegment(ConsumePartition consumePartition, long ackStartIndex, long ackCurIndex) {
        Position position;
        ArrayList<Position> positionList = (ArrayList<Position>)this.concurrentConsumeCache.get(consumePartition);
        if (positionList == null) {
            positionList = new ArrayList<Position>();
            this.concurrentConsumeCache.put(consumePartition, positionList);
        }
        if (positionList.contains(position = new Position(ackStartIndex, ackCurIndex, -1L, -1L))) {
            return;
        }
        positionList.add(position);
    }

    private List<Position> sortPositions(ConsumePartition consumePartition) {
        List positionList = (List)this.concurrentConsumeCache.get(consumePartition);
        if (CollectionUtils.isEmpty((Collection)positionList)) {
            return null;
        }
        List<Position> sortPositionList = this.sortByAckStartIndex(positionList);
        this.concurrentConsumeCache.put(consumePartition, sortPositionList);
        return sortPositionList;
    }

    private List<Position> sortByAckStartIndex(List<Position> list) {
        return Lists.newArrayList(list).stream().sorted((thisPosition, thatPosition) -> Long.compare(thisPosition.getAckStartIndex(), thatPosition.getAckStartIndex())).collect(Collectors.toList());
    }

    private List<Position> mergeSequenceSegment(List<Position> sortPositionList) {
        if (sortPositionList.size() <= 1) {
            return sortPositionList;
        }
        ArrayList<Position> mergeList = new ArrayList<Position>();
        for (int i = 0; i < sortPositionList.size(); ++i) {
            Position next;
            Position mergedPosition;
            Position current;
            Position last = current = sortPositionList.get(i);
            int skipIndex = 0;
            for (int j = i + 1; j < sortPositionList.size() && (mergedPosition = this.tryMergeTwoSegment(last, next = sortPositionList.get(j))) != null; ++j) {
                last = mergedPosition;
                ++skipIndex;
            }
            mergeList.add(last);
            i += skipIndex;
        }
        return mergeList;
    }

    private Position tryMergeTwoSegment(Position last, Position next) {
        if (last.getAckCurIndex() >= next.getAckCurIndex()) {
            return last;
        }
        if (last.getAckCurIndex() + 1L == next.getAckStartIndex()) {
            return new Position(last.getAckStartIndex(), next.getAckCurIndex(), -1L, -1L);
        }
        return null;
    }

    class MovePartitionSegmentListener
    implements EventListener<SessionManager.SessionEvent> {
        MovePartitionSegmentListener() {
        }

        public void onEvent(SessionManager.SessionEvent event) {
        }

        private void movePartitionSegmentToExpire(org.joyqueue.network.session.Consumer consumer) {
            Iterator iterator = ConcurrentConsumption.this.segmentConsumeMap.keySet().iterator();
            while (iterator.hasNext()) {
                PartitionSegment next = (PartitionSegment)iterator.next();
                if (next == null || !StringUtils.equals((CharSequence)next.getTopic(), (CharSequence)consumer.getTopic()) || !StringUtils.equals((CharSequence)next.getApp(), (CharSequence)consumer.getApp())) continue;
                ConsumePartition consumePartition = new ConsumePartition(next.getTopic(), next.getApp(), next.getPartition());
                ConcurrentConsumption.this.addToExpireQueue(consumePartition, next);
                iterator.remove();
            }
        }
    }

    private class PartitionSegment {
        private String topic;
        private String app;
        private short partition;
        private long startIndex;
        private long endIndex;

        PartitionSegment(String topic, String app, short partition, long startIndex, long endIndex) {
            this.topic = topic;
            this.app = app;
            this.partition = partition;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public String getApp() {
            return this.app;
        }

        public void setApp(String app) {
            this.app = app;
        }

        public short getPartition() {
            return this.partition;
        }

        public void setPartition(short partition) {
            this.partition = partition;
        }

        public long getStartIndex() {
            return this.startIndex;
        }

        public void setStartIndex(long startIndex) {
            this.startIndex = startIndex;
        }

        public long getEndIndex() {
            return this.endIndex;
        }

        public void setEndIndex(long endIndex) {
            this.endIndex = endIndex;
        }

        public int hashCode() {
            int result = this.topic.hashCode();
            result = 31 * result + this.app.hashCode();
            result = 31 * result + Short.hashCode(this.partition);
            result = 31 * result + Long.hashCode(this.startIndex);
            result = 31 * result + Long.hashCode(this.endIndex);
            return result;
        }

        public boolean equals(Object obj) {
            PartitionSegment that = (PartitionSegment)obj;
            if (!StringUtils.equals((CharSequence)this.topic, (CharSequence)that.topic)) {
                return false;
            }
            if (!StringUtils.equals((CharSequence)this.app, (CharSequence)that.app)) {
                return false;
            }
            if (this.partition != that.partition) {
                return false;
            }
            if (this.startIndex != that.startIndex) {
                return false;
            }
            return this.endIndex == that.endIndex;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PartitionSegment{");
            sb.append("topic='").append(this.topic).append('\'');
            sb.append(", app=").append(this.app);
            sb.append(", partition=").append(this.partition);
            sb.append(", startIndex=").append(this.startIndex);
            sb.append(", endIndex=").append(this.endIndex);
            sb.append('}');
            return sb.toString();
        }
    }

    class FilterCallbackImpl
    implements FilterCallback {
        private org.joyqueue.network.session.Consumer consumer;

        FilterCallbackImpl(org.joyqueue.network.session.Consumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void callback(List<ByteBuffer> byteBuffers) throws JoyQueueException {
            ConcurrentConsumption.this.innerAcknowledge(this.consumer, byteBuffers);
        }
    }
}

