/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer;

import org.joyqueue.broker.config.BrokerConfig;
import org.joyqueue.broker.consumer.ConsumeConfigKey;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;

public class ConsumeConfig {
    private static final String CONSUME_POSITION_PATH = "/position";
    private PropertySupplier propertySupplier;
    private String consumePositionPath;
    private BrokerConfig brokerConfig;

    public ConsumeConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
        this.brokerConfig = new BrokerConfig(propertySupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConsumePositionPath() {
        if (this.consumePositionPath == null || this.consumePositionPath.isEmpty()) {
            ConsumeConfig consumeConfig = this;
            synchronized (consumeConfig) {
                if (this.consumePositionPath == null) {
                    String prefix = "";
                    if (this.propertySupplier != null) {
                        Property property = this.propertySupplier.getProperty("application.data.path");
                        prefix = property == null ? prefix : property.getString();
                    }
                    this.consumePositionPath = prefix + CONSUME_POSITION_PATH;
                }
            }
        }
        return this.consumePositionPath;
    }

    public boolean getBroadcastIndexResetEnable() {
        return (Boolean)this.propertySupplier.getValue((PropertyDef)ConsumeConfigKey.BROADCAST_INDEX_RESET_ENABLE);
    }

    public int getBroadcastIndexResetInterval() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)ConsumeConfigKey.BROADCAST_INDEX_RESET_INTERVAL);
    }

    public int getBroadcastIndexResetTime() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)ConsumeConfigKey.BROADCAST_INDEX_RESET_TIME);
    }

    public int getRetryRate() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)ConsumeConfigKey.RETRY_RATE);
    }

    public int getIndexFlushInterval() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)ConsumeConfigKey.INDEX_FLUSH_INTERVAL);
    }

    public int getRetryRate(String topic, String app) {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (String)(ConsumeConfigKey.RETRY_RATE_PREFIX.getName() + String.format("%s.%s", topic, app)), (PropertyDef.Type)ConsumeConfigKey.RETRY_RATE_PREFIX.getType(), (Object)ConsumeConfigKey.RETRY_RATE_PREFIX.getValue());
    }

    public void setConsumePositionPath(String consumePositionPath) {
        this.consumePositionPath = consumePositionPath;
    }

    public boolean getLogDetail(String app) {
        return this.brokerConfig.getLogDetail(app);
    }

    public boolean useLegacyPartitionManager() {
        return (Boolean)this.propertySupplier.getValue((PropertyDef)ConsumeConfigKey.USE_LEGACY_PARTITION_MANAGER);
    }

    public boolean useLegacyConcurrentConsumer() {
        return (Boolean)this.propertySupplier.getValue((PropertyDef)ConsumeConfigKey.USE_LEGACY_CONCURRENT_CONSUMER);
    }

    public int getPartitionSelectRetryMax() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)ConsumeConfigKey.PARTITION_SELECT_RETRY_MAX);
    }
}

