/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.archive.ArchiveManager;
import org.joyqueue.broker.archive.ConsumeArchiveService;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.CasPartitionManager;
import org.joyqueue.broker.consumer.ConcurrentConsumer;
import org.joyqueue.broker.consumer.ConcurrentConsumption;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.ConsumeConfig;
import org.joyqueue.broker.consumer.FilterMessageSupport;
import org.joyqueue.broker.consumer.LegacyPartitionManager;
import org.joyqueue.broker.consumer.PartitionConsumption;
import org.joyqueue.broker.consumer.PartitionLockInstance;
import org.joyqueue.broker.consumer.PartitionManager;
import org.joyqueue.broker.consumer.SlideWindowConcurrentConsumer;
import org.joyqueue.broker.consumer.model.ConsumePartition;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.broker.consumer.position.PositionManager;
import org.joyqueue.broker.consumer.position.model.Position;
import org.joyqueue.broker.monitor.BrokerMonitor;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.domain.TopicType;
import org.joyqueue.event.EventType;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.MessageLocation;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Joint;
import org.joyqueue.nsr.event.RemoveConsumerEvent;
import org.joyqueue.nsr.event.UpdateConsumerEvent;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeManager
extends Service
implements Consume,
BrokerContextAware {
    private final Logger logger = LoggerFactory.getLogger(ConsumeManager.class);
    private ConcurrentConsumer concurrentConsumption;
    private PartitionConsumption partitionConsumption;
    private MessageRetry messageRetry;
    private PartitionManager partitionManager;
    private ClusterManager clusterManager;
    private StoreService storeService;
    private PositionManager positionManager;
    private FilterMessageSupport filterMessageSupport;
    private ConcurrentMap<Joint, AtomicLong> consumeCounter = new ConcurrentHashMap<Joint, AtomicLong>();
    private PartitionLockInstance lockInstance = new PartitionLockInstance();
    private BrokerMonitor brokerMonitor;
    private ArchiveManager archiveManager;
    private BrokerContext brokerContext;
    private ConsumeConfig consumeConfig;
    private SessionManager sessionManager;
    private Timer resetBroadcastIndexTimer;

    public ConsumeManager() {
    }

    public ConsumeManager(ClusterManager clusterManager, StoreService storeService, MessageRetry messageRetry, BrokerMonitor brokerMonitor, ArchiveManager archiveManager, PositionManager positionManager) {
        this.clusterManager = clusterManager;
        this.storeService = storeService;
        this.messageRetry = messageRetry;
        this.brokerMonitor = brokerMonitor;
        this.positionManager = positionManager;
        this.archiveManager = archiveManager;
    }

    protected void validate() throws Exception {
        super.validate();
        if (this.consumeConfig == null) {
            this.consumeConfig = new ConsumeConfig(this.brokerContext != null ? this.brokerContext.getPropertySupplier() : null);
        }
        if (this.clusterManager == null && this.brokerContext != null) {
            this.clusterManager = this.brokerContext.getClusterManager();
        }
        if (this.brokerMonitor == null && this.brokerContext != null) {
            this.brokerMonitor = this.brokerContext.getBrokerMonitor();
        }
        if (this.messageRetry == null && this.brokerContext != null) {
            this.messageRetry = this.brokerContext.getRetryManager();
        }
        if (this.archiveManager == null && this.brokerContext != null) {
            this.archiveManager = this.brokerContext.getArchiveManager();
        }
        if (this.storeService == null && this.brokerContext != null) {
            this.storeService = this.brokerContext.getStoreService();
        }
        if (this.sessionManager == null && this.brokerContext != null) {
            this.sessionManager = this.brokerContext.getSessionManager();
        }
        Preconditions.checkArgument((this.clusterManager != null ? 1 : 0) != 0, (Object)"cluster manager can not be null.");
        Preconditions.checkArgument((this.storeService != null ? 1 : 0) != 0, (Object)"cluster manager can not be null.");
        if (this.brokerMonitor == null) {
            this.logger.warn("broker monitor is null.");
        }
        if (this.messageRetry == null) {
            this.logger.warn("message retry is null.");
        }
        if (this.archiveManager == null) {
            this.logger.warn("archive manager is null.");
        }
        this.filterMessageSupport = new FilterMessageSupport(this.clusterManager);
        this.partitionManager = this.consumeConfig.useLegacyPartitionManager() ? new LegacyPartitionManager(this.clusterManager, this.sessionManager) : new CasPartitionManager(this.clusterManager, this.sessionManager);
        this.positionManager = new PositionManager(this.clusterManager, this.storeService, this.consumeConfig);
        this.brokerContext.positionManager(this.positionManager);
        this.partitionConsumption = new PartitionConsumption(this.clusterManager, this.storeService, this.partitionManager, this.positionManager, this.messageRetry, this.filterMessageSupport, this.archiveManager, this.consumeConfig);
        this.concurrentConsumption = this.consumeConfig.useLegacyConcurrentConsumer() ? new ConcurrentConsumption(this.clusterManager, this.storeService, this.partitionManager, this.messageRetry, this.positionManager, this.filterMessageSupport, this.archiveManager, this.sessionManager) : new SlideWindowConcurrentConsumer(this.clusterManager, this.storeService, this.partitionManager, this.messageRetry, this.positionManager, this.filterMessageSupport, this.archiveManager, this.consumeConfig);
        this.resetBroadcastIndexTimer = new Timer("joyqueuue-consume-reset-broadcast-index-timer");
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.partitionConsumption.start();
        this.concurrentConsumption.start();
        this.positionManager.start();
        this.clusterManager.addListener(new SubscriptionListener());
        this.registerEventListener(this.clusterManager);
        this.resetBroadcastIndexTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ConsumeManager.this.doResetBroadcastIndex();
            }
        }, this.consumeConfig.getBroadcastIndexResetInterval(), (long)this.consumeConfig.getBroadcastIndexResetInterval());
        this.logger.info("ConsumeManager is started.");
    }

    protected void doStop() {
        super.doStop();
        Close.close((LifeCycle)this.partitionConsumption);
        Close.close((LifeCycle)this.messageRetry);
        Close.close((LifeCycle)this.partitionConsumption);
        Close.close((LifeCycle)this.concurrentConsumption);
        this.resetBroadcastIndexTimer.cancel();
        this.partitionManager.close();
        this.logger.info("ConsumeManager is stopped.");
    }

    private void registerEventListener(ClusterManager clusterManager) {
        clusterManager.addListener(new UpdateConsumeListener());
    }

    @Override
    public PullResult getMessage(org.joyqueue.network.session.Consumer consumer, int count, int ackTimeout) throws JoyQueueException {
        PullResult pullResult;
        Preconditions.checkArgument((consumer != null ? 1 : 0) != 0, (Object)"\u6d88\u8d39\u8005\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        long startTime = SystemClock.now();
        Consumer.ConsumerPolicy consumerPolicy = this.clusterManager.getConsumerPolicy(TopicName.parse((String)consumer.getTopic()), consumer.getApp());
        if (count <= 0) {
            Short batchSize = consumerPolicy.getBatchSize();
            count = batchSize.shortValue();
        }
        if (ackTimeout <= 0) {
            ackTimeout = consumerPolicy.getAckTimeout();
        }
        if (this.partitionManager.needPause(consumer)) {
            pullResult = new PullResult(consumer, -1, Collections.emptyList());
            pullResult.setCode(JoyQueueCode.FW_FETCH_TOPIC_MESSAGE_PAUSED);
            return pullResult;
        }
        pullResult = null;
        long accessTimes = this.getAndIncrement(consumer);
        switch (this.choiceConsumeStrategy(consumerPolicy)) {
            case DEFAULT: {
                pullResult = this.partitionConsumption.getMessage(consumer, count, ackTimeout, accessTimes);
                break;
            }
            case SEQUENCE: {
                short sequencePartition = this.getSequencePartition(consumer);
                pullResult = this.partitionConsumption.getMessage4Sequence(consumer, sequencePartition, count, ackTimeout);
                break;
            }
            case CONCURRENT: {
                pullResult = this.concurrentConsumption.getMessage(consumer, count, ackTimeout, accessTimes, consumerPolicy.getConcurrent());
                break;
            }
            default: {
                throw new JoyQueueException(JoyQueueCode.CN_PARAM_ERROR, new Object[]{"invalid consume strategy"});
            }
        }
        if (pullResult.getBuffers().size() > 0) {
            short partition = pullResult.getPartition();
            PartitionGroup partitionGroup = this.clusterManager.getPartitionGroup(TopicName.parse((String)consumer.getTopic()), partition);
            int group = partitionGroup == null ? -1 : partitionGroup.getGroup();
            this.monitor(pullResult, startTime, consumer, group);
        }
        return pullResult;
    }

    private ConsumeStrategy choiceConsumeStrategy(Consumer.ConsumerPolicy consumerPolicy) {
        if (consumerPolicy.getSeq().booleanValue()) {
            return ConsumeStrategy.SEQUENCE;
        }
        if (consumerPolicy.isConcurrent().booleanValue()) {
            return ConsumeStrategy.CONCURRENT;
        }
        return ConsumeStrategy.DEFAULT;
    }

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
    }

    private short getSequencePartition(org.joyqueue.network.session.Consumer consumer) {
        short sequencePartition = 0;
        return sequencePartition;
    }

    private long getAndIncrement(org.joyqueue.network.session.Consumer consumer) {
        Joint joint = new Joint(consumer.getTopic(), consumer.getApp());
        AtomicLong atomicLong = (AtomicLong)this.consumeCounter.get(joint);
        if (atomicLong == null) {
            atomicLong = new AtomicLong(0L);
            this.consumeCounter.put(joint, atomicLong);
        }
        return atomicLong.getAndIncrement();
    }

    @Override
    public PullResult getMessage(org.joyqueue.network.session.Consumer consumer, short partition, long index, int count) throws JoyQueueException {
        Preconditions.checkArgument((consumer != null ? 1 : 0) != 0, (Object)"\u6d88\u8d39\u8005\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((partition >= 0 ? 1 : 0) != 0, (Object)"\u5206\u533a\u4e0d\u80fd\u5c0f\u4e8e0");
        Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"\u6d88\u8d39\u5e8f\u53f7\u4e0d\u80fd\u5c0f\u4e8e0");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"\u6d88\u8d39\u6761\u6570\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
        Integer group = this.partitionManager.getGroupByPartition(TopicName.parse((String)consumer.getTopic()), partition);
        Preconditions.checkArgument((group != null && group >= 0 ? 1 : 0) != 0, (Object)("\u627e\u4e0d\u5230\u4e3b\u9898[" + consumer.getTopic() + "],\u5206\u533a[" + partition + "]\u7684\u5206\u533a\u7ec4"));
        try {
            long startTime = SystemClock.now();
            PullResult pullResult = this.partitionConsumption.getMsgByPartitionAndIndex(consumer, (int)group, partition, index, count);
            this.monitor(pullResult, startTime, consumer, group);
            return pullResult;
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new JoyQueueException(JoyQueueCode.SE_IO_ERROR, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public PullResult getMessage(String topic, short partition, long index, int count) throws JoyQueueException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((partition >= 0 ? 1 : 0) != 0, (Object)"\u5206\u533a\u4e0d\u80fd\u5c0f\u4e8e0");
        Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"\u6d88\u8d39\u5e8f\u53f7\u4e0d\u80fd\u5c0f\u4e8e0");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"\u6d88\u8d39\u6761\u6570\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
        Integer group = this.partitionManager.getGroupByPartition(TopicName.parse((String)topic), partition);
        Preconditions.checkArgument((group != null && group >= 0 ? 1 : 0) != 0, (Object)("\u627e\u4e0d\u5230\u4e3b\u9898[" + topic + "],\u5206\u533a[" + partition + "]\u7684\u5206\u533a\u7ec4"));
        try {
            return this.partitionConsumption.getMsgByPartitionAndIndex(topic, (int)group, partition, index, count);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            throw new JoyQueueException(JoyQueueCode.SE_IO_ERROR, (Throwable)e, new Object[0]);
        }
    }

    private void monitor(PullResult pullResult, long startTime, org.joyqueue.network.session.Consumer consumer, int partitionGroup) {
        if (pullResult != null && CollectionUtils.isNotEmpty(pullResult.getBuffers())) {
            long now = SystemClock.now();
            int messageCount = 0;
            int messageSize = 0;
            for (ByteBuffer buffer : pullResult.getBuffers()) {
                messageSize += buffer.limit();
                BrokerMessage brokerMessage = Serializer.readBrokerMessageHeader(buffer);
                if (brokerMessage.isBatch()) {
                    messageCount += brokerMessage.getFlag();
                    continue;
                }
                ++messageCount;
            }
            this.brokerMonitor.onGetMessage(consumer.getTopic(), consumer.getApp(), partitionGroup, pullResult.getPartition(), messageCount, messageSize, now - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acknowledge(MessageLocation[] locations, org.joyqueue.network.session.Consumer consumer, Connection connection, boolean isSuccessAck) throws JoyQueueException {
        boolean isSuccess = false;
        if (locations.length <= 0) {
            return isSuccess;
        }
        ConsumePartition consumePartition = new ConsumePartition(consumer.getTopic(), consumer.getApp(), locations[0].getPartition());
        ConsumePartition lock = this.lockInstance.getLockInstance(consumePartition);
        Consumer.ConsumerPolicy consumerPolicy = this.clusterManager.getConsumerPolicy(TopicName.parse((String)consumer.getTopic()), consumer.getApp());
        switch (this.choiceConsumeStrategy(consumerPolicy)) {
            case DEFAULT: 
            case SEQUENCE: {
                ConsumePartition consumePartition2 = lock;
                synchronized (consumePartition2) {
                    isSuccess = this.partitionConsumption.acknowledge(locations, consumer, isSuccessAck);
                    break;
                }
            }
            case CONCURRENT: {
                ConsumePartition consumePartition2 = lock;
                synchronized (consumePartition2) {
                    isSuccess = this.concurrentConsumption.acknowledge(locations, consumer, isSuccessAck);
                    break;
                }
            }
        }
        if (isSuccess) {
            this.partitionManager.releasePartition(consumePartition);
            if (consumePartition.getPartition() != Short.MAX_VALUE) {
                Integer partitionGroupId = this.clusterManager.getPartitionGroupId(TopicName.parse((String)consumer.getTopic()), consumePartition.getPartition());
                if (partitionGroupId == null) {
                    this.logger.error("onAckMessage error, partitionGroupId is null, topic: {}, app: {}, partition: {}", new Object[]{consumer.getTopic(), consumer.getApp(), consumePartition.getPartition()});
                } else {
                    this.brokerMonitor.onAckMessage(consumer.getTopic(), consumer.getApp(), partitionGroupId, consumePartition.getPartition());
                }
                this.archiveIfNecessary(consumerPolicy, connection, locations);
            }
        }
        return isSuccess;
    }

    public void archiveIfNecessary(Consumer.ConsumerPolicy policy, Connection connection, MessageLocation[] messageLocations) {
        try {
            ConsumeArchiveService archiveService;
            if (policy.getArchive() == null || !policy.getArchive().booleanValue() || this.archiveManager == null || (archiveService = this.archiveManager.getConsumeArchiveService()) == null) {
                return;
            }
            archiveService.appendConsumeLog(connection, messageLocations);
        }
        catch (Throwable th) {
            this.logger.warn(String.format("archive message consume error,locations: %s ", messageLocations), th);
        }
    }

    @Override
    public boolean hasFreePartition(org.joyqueue.network.session.Consumer consumer) {
        return this.partitionManager.hasFreePartition(consumer);
    }

    @Override
    public long getPullIndex(org.joyqueue.network.session.Consumer consumer, short partition) {
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        Preconditions.checkArgument((topic != null ? 1 : 0) != 0, (Object)"topic can not be null.");
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"app can not be null.");
        Position position = this.positionManager.getPosition(TopicName.parse((String)consumer.getTopic()), consumer.getApp(), partition);
        if (position == null) {
            return -1L;
        }
        return position.getPullCurIndex();
    }

    @Override
    public void setPullIndex(org.joyqueue.network.session.Consumer consumer, short partition, long index) throws JoyQueueException {
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        Preconditions.checkArgument((topic != null ? 1 : 0) != 0, (Object)"topic can not be null.");
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"app can not be null.");
        this.positionManager.updateLastMsgPullIndex(TopicName.parse((String)topic), app, partition, index);
    }

    @Override
    public long getAckIndex(org.joyqueue.network.session.Consumer consumer, short partition) {
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        Preconditions.checkArgument((topic != null ? 1 : 0) != 0, (Object)"topic can not be null.");
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"app can not be null.");
        Integer partitionGroupId = this.clusterManager.getPartitionGroupId(TopicName.parse((String)topic), partition);
        if (partitionGroupId == null) {
            return -1L;
        }
        Position position = this.positionManager.getPosition(TopicName.parse((String)topic), app, partition);
        if (position == null) {
            return -1L;
        }
        return position.getAckCurIndex();
    }

    @Override
    public long getStartIndex(org.joyqueue.network.session.Consumer consumer, short partition) {
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        Preconditions.checkArgument((topic != null ? 1 : 0) != 0, (Object)"topic can not be null.");
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"app can not be null.");
        Integer partitionGroupId = this.clusterManager.getPartitionGroupId(TopicName.parse((String)topic), partition);
        if (partitionGroupId == null) {
            return -1L;
        }
        Position position = this.positionManager.getPosition(TopicName.parse((String)topic), app, partition);
        if (position == null) {
            return -1L;
        }
        return position.getAckStartIndex();
    }

    @Override
    public void setAckIndex(org.joyqueue.network.session.Consumer consumer, short partition, long index) throws JoyQueueException {
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        Preconditions.checkArgument((topic != null ? 1 : 0) != 0, (Object)"topic can not be null.");
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"app can not be null.");
        Integer partitionGroupId = this.clusterManager.getPartitionGroupId(TopicName.parse((String)consumer.getTopic()), partition);
        Preconditions.checkArgument((partitionGroupId != null ? 1 : 0) != 0, (Object)"partitionGroupId can not be null.");
        this.positionManager.updateLastMsgAckIndex(TopicName.parse((String)topic), app, partition, index);
        this.brokerMonitor.onAckMessage(consumer.getTopic(), consumer.getApp(), partitionGroupId, partition);
    }

    @Override
    public void setStartAckIndex(org.joyqueue.network.session.Consumer consumer, short partition, long index) throws JoyQueueException {
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        Preconditions.checkArgument((topic != null ? 1 : 0) != 0, (Object)"topic can not be null.");
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"app can not be null.");
        this.positionManager.updateStartMsgAckIndex(TopicName.parse((String)topic), app, partition, index);
    }

    @Override
    public boolean resetPullIndex(String topic, String app) throws JoyQueueException {
        List<Short> masterPartitionList = this.clusterManager.getLocalPartitions(TopicName.parse((String)topic));
        int successCount = 0;
        for (short partition : masterPartitionList) {
            long lastMsgPullIndex = this.positionManager.getLastMsgPullIndex(TopicName.parse((String)topic), app, partition);
            boolean isSuccess = this.positionManager.updateLastMsgPullIndex(TopicName.parse((String)topic), app, partition, lastMsgPullIndex);
            if (!isSuccess) continue;
            ++successCount;
        }
        return masterPartitionList.size() == successCount;
    }

    @Override
    public boolean setConsumePosition(Map<ConsumePartition, Position> consumePositions) {
        if (consumePositions == null || consumePositions.isEmpty()) {
            return false;
        }
        return this.positionManager.setConsumePosition(consumePositions);
    }

    @Override
    public Map<ConsumePartition, Position> getConsumePositionByGroup(TopicName topic, String app, int partitionGroup) {
        List<PartitionGroup> partitionGroupList = this.clusterManager.getLocalPartitionGroups(topic);
        if (CollectionUtils.isEmpty(partitionGroupList)) {
            return null;
        }
        return this.positionManager.getConsumePosition(topic, app, partitionGroup);
    }

    @Override
    public Map<ConsumePartition, Position> getConsumePositionByGroup(TopicName topic, int partitionGroup) {
        List<PartitionGroup> partitionGroupList = this.clusterManager.getLocalPartitionGroups(topic);
        if (CollectionUtils.isEmpty(partitionGroupList)) {
            return null;
        }
        return this.positionManager.getConsumePosition(topic, partitionGroup);
    }

    @Override
    public long getMinIndex(org.joyqueue.network.session.Consumer consumer, short partition) {
        String topic = consumer.getTopic();
        Integer partitionGroupId = this.clusterManager.getPartitionGroupId(TopicName.parse((String)topic), partition);
        PartitionGroupStore store = this.storeService.getStore(topic, partitionGroupId.intValue());
        return store.getLeftIndex(partition);
    }

    @Override
    public long getMaxIndex(org.joyqueue.network.session.Consumer consumer, short partition) {
        String topic = consumer.getTopic();
        Integer partitionGroupId = this.clusterManager.getPartitionGroupId(TopicName.parse((String)topic), partition);
        PartitionGroupStore store = this.storeService.getStore(topic, partitionGroupId.intValue());
        return store.getRightIndex(partition);
    }

    @Override
    public void releasePartition(String topic, String app, short partition) {
        this.partitionManager.releasePartition(new ConsumePartition(topic, app, partition));
    }

    protected void doResetBroadcastIndex() {
        if (!this.consumeConfig.getBroadcastIndexResetEnable()) {
            return;
        }
        List<TopicConfig> localTopics = this.clusterManager.getTopics();
        if (CollectionUtils.isEmpty(localTopics)) {
            return;
        }
        for (TopicConfig topicConfig : localTopics) {
            ArrayList broadcastConsumers = Lists.newArrayList((Iterable)this.clusterManager.getNameService().getConsumerByTopic(topicConfig.getName()));
            Iterator iterator = broadcastConsumers.iterator();
            while (iterator.hasNext()) {
                Consumer consumer = (Consumer)iterator.next();
                if (consumer.getTopicType().equals((Object)TopicType.BROADCAST)) continue;
                iterator.remove();
            }
            if (CollectionUtils.isEmpty((Collection)broadcastConsumers)) continue;
            for (PartitionGroup partitionGroup : this.clusterManager.getLocalPartitionGroups(topicConfig)) {
                this.doResetBroadcastIndex(topicConfig, partitionGroup, broadcastConsumers);
            }
        }
    }

    protected void doResetBroadcastIndex(TopicConfig topic, PartitionGroup partitionGroup, List<Consumer> consumers) {
        PartitionGroupStore store = this.storeService.getStore(topic.getName().getFullName(), partitionGroup.getGroup());
        if (store == null) {
            this.logger.warn("reset broadcast index failed, store not exist, topic: {}, group: {}", (Object)topic.getName(), (Object)partitionGroup.getGroup());
            return;
        }
        long timestamp = SystemClock.now() - (long)this.consumeConfig.getBroadcastIndexResetTime();
        for (Short partition : partitionGroup.getPartitions()) {
            long index = store.getIndex(partition.shortValue(), timestamp);
            if (index < 0L) continue;
            for (Consumer consumer : consumers) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("reset broadcast index, topic: {}, group: {}, partition: {}, index: {}, app: {}", new Object[]{topic.getName(), partitionGroup.getGroup(), partition, index, consumer.getApp()});
                }
                try {
                    this.setAckIndex(new org.joyqueue.network.session.Consumer(consumer.getTopic().getFullName(), consumer.getApp()), partition, index);
                }
                catch (JoyQueueException e) {
                    this.logger.debug("reset broadcast index exception, topic: {}, group: {}, partition: {}, index: {}, app: {}", new Object[]{topic.getName(), partitionGroup.getGroup(), partition, index, consumer.getApp(), e});
                }
            }
        }
    }

    class SubscriptionListener
    implements EventListener<MetaEvent> {
        SubscriptionListener() {
        }

        public void onEvent(MetaEvent event) {
            if (event.getEventType() == EventType.REMOVE_CONSUMER) {
                RemoveConsumerEvent removeConsumerEvent = (RemoveConsumerEvent)event;
                ConsumeManager.this.logger.info("Listen clusterManger. RemoveConsumer, Event:[{}]", (Object)removeConsumerEvent);
                ConsumeManager.this.consumeCounter.remove(new Joint(removeConsumerEvent.getTopic().getCode(), removeConsumerEvent.getConsumer().getApp()));
            }
        }
    }

    class UpdateConsumeListener
    implements EventListener<MetaEvent> {
        UpdateConsumeListener() {
        }

        public void onEvent(MetaEvent event) {
            if (event.getEventType() == EventType.UPDATE_CONSUMER) {
                UpdateConsumerEvent updateConsumerEvent = (UpdateConsumerEvent)event;
                ConsumeManager.this.logger.info("listen update consume event.");
                try {
                    Consumer.ConsumerPolicy consumerPolicy = ConsumeManager.this.clusterManager.getConsumerPolicy(updateConsumerEvent.getTopic(), updateConsumerEvent.getNewConsumer().getApp());
                    Integer readRetryProbability = consumerPolicy.getReadRetryProbability();
                    ConsumeManager.this.partitionManager.resetRetryProbability(readRetryProbability);
                }
                catch (JoyQueueException e) {
                    ConsumeManager.this.logger.error("listen update consume event error.", (Throwable)e);
                }
            }
        }
    }

    private static enum ConsumeStrategy {
        SEQUENCE,
        CONCURRENT,
        DEFAULT;

    }
}

