/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.domain.Consumer;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayHandler {
    private final Logger logger = LoggerFactory.getLogger(DelayHandler.class);

    public List<ByteBuffer> handle(Consumer.ConsumerPolicy consumerPolicy, List<ByteBuffer> byteBufferList) {
        if (this.needDelay(consumerPolicy)) {
            return this.filterLayerMsg(consumerPolicy, byteBufferList);
        }
        return byteBufferList;
    }

    public boolean needDelay(Consumer.ConsumerPolicy consumerPolicy) {
        return consumerPolicy == null ? false : consumerPolicy.getDelay() > 0;
    }

    private List<ByteBuffer> filterLayerMsg(Consumer.ConsumerPolicy consumerPolicy, List<ByteBuffer> msgs) {
        int delayTime = consumerPolicy.getDelay();
        LinkedList<ByteBuffer> collect = new LinkedList<ByteBuffer>();
        for (ByteBuffer msg : msgs) {
            if (!this.isExpire(msg, delayTime)) break;
            collect.add(msg);
        }
        return collect;
    }

    private boolean isExpire(ByteBuffer msg, int delayTime) {
        boolean rst = false;
        try {
            long sendTime = Serializer.readSendTime(msg);
            long expire = sendTime + (long)delayTime;
            rst = expire <= SystemClock.now();
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
        return rst;
    }
}

