/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer;

import com.alibaba.fastjson.JSON;
import com.jd.laf.extension.ExtensionManager;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.filter.FilterCallback;
import org.joyqueue.broker.consumer.filter.FilterPipeline;
import org.joyqueue.broker.consumer.filter.MessageFilter;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.EventType;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.nsr.event.UpdateConsumerEvent;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.security.Hex;
import org.joyqueue.toolkit.security.Md5;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilterMessageSupport {
    private final Logger logger = LoggerFactory.getLogger(FilterMessageSupport.class);
    private ClusterManager clusterManager;
    private ConcurrentMap<String, FilterPipeline<MessageFilter>> filterRuleCache = new ConcurrentHashMap<String, FilterPipeline<MessageFilter>>();

    FilterMessageSupport(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
        clusterManager.addListener(new updateConsumeListener());
    }

    public List<ByteBuffer> filter(Consumer consumer, List<ByteBuffer> byteBuffers, FilterCallback filterCallback) throws JoyQueueException {
        FilterPipeline<MessageFilter> filterPipeline = (FilterPipeline<MessageFilter>)this.filterRuleCache.get(consumer.getId());
        if (filterPipeline == null) {
            filterPipeline = this.createFilterPipeline(consumer.getConsumerPolicy());
            this.filterRuleCache.putIfAbsent(consumer.getId(), filterPipeline);
        }
        List<ByteBuffer> result = filterPipeline.execute(byteBuffers, filterCallback);
        return result;
    }

    private FilterPipeline<MessageFilter> createFilterPipeline(Consumer.ConsumerPolicy consumerPolicy) throws JoyQueueException {
        Map filterRule = null;
        if (consumerPolicy != null) {
            filterRule = consumerPolicy.getFilters();
        }
        String pipelineId = this.generatePipelineId(filterRule);
        FilterPipeline<MessageFilter> filterPipeline = new FilterPipeline<MessageFilter>(pipelineId);
        if (MapUtils.isNotEmpty((Map)filterRule)) {
            Set entries = filterRule.entrySet();
            for (Map.Entry entry : entries) {
                String type = (String)entry.getKey();
                String content = (String)entry.getValue();
                MessageFilter newMessageFilter = (MessageFilter)ExtensionManager.getOrLoadExtension(MessageFilter.class, (Object)type);
                newMessageFilter.setRule(content);
                filterPipeline.register(newMessageFilter);
            }
        }
        return filterPipeline;
    }

    private String generatePipelineId(Map<String, String> filterRule) throws JoyQueueException {
        if (MapUtils.isEmpty(filterRule)) {
            return null;
        }
        String jsonString = JSON.toJSONString(filterRule);
        try {
            byte[] encrypt = Md5.INSTANCE.encrypt(jsonString.getBytes("utf-8"), null);
            return Hex.encode((byte[])encrypt);
        }
        catch (Exception e) {
            this.logger.error("generate filter pipeline error.", (Throwable)e);
            throw new JoyQueueException((Throwable)e, JoyQueueCode.CN_UNKNOWN_ERROR.getCode());
        }
    }

    private void updateFilterRuleCache(TopicName topic, String app) {
        try {
            Consumer.ConsumerPolicy consumerPolicy = this.clusterManager.getConsumerPolicy(topic, app);
            Map filters = consumerPolicy.getFilters();
            String pipelineId = this.generatePipelineId(filters);
            FilterPipeline pipeline = (FilterPipeline)this.filterRuleCache.get(this.getConsumeId(topic, app));
            if (pipeline != null && StringUtils.equals((CharSequence)pipelineId, (CharSequence)pipeline.getId())) {
                this.logger.info("FilterPipeline is already exist, topic:[{}], app:[{}], filers:[{}]", new Object[]{topic, app, JSON.toJSON((Object)filters)});
                return;
            }
            FilterPipeline<MessageFilter> filterPipeline = this.createFilterPipeline(consumerPolicy);
            this.filterRuleCache.put(this.getConsumeId(topic, app), filterPipeline);
        }
        catch (Exception ex) {
            this.logger.error("Update Message filter cache error.", (Throwable)ex);
        }
    }

    private String getConsumeId(TopicName topic, String app) {
        return new StringBuilder(30).append(topic.getFullName()).append(".").append(app).toString();
    }

    class updateConsumeListener
    implements EventListener<MetaEvent> {
        updateConsumeListener() {
        }

        public void onEvent(MetaEvent event) {
            if (event.getEventType() == EventType.UPDATE_CONSUMER) {
                UpdateConsumerEvent updateConsumerEvent = (UpdateConsumerEvent)event;
                FilterMessageSupport.this.logger.info("listen update consume event to update filter pipeline.");
                FilterMessageSupport.this.updateFilterRuleCache(updateConsumerEvent.getTopic(), updateConsumerEvent.getNewConsumer().getApp());
            }
        }
    }
}

