/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.PartitionLockInstance;
import org.joyqueue.broker.consumer.PartitionManager;
import org.joyqueue.broker.consumer.model.ConsumePartition;
import org.joyqueue.broker.consumer.model.OwnerShip;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.retry.RetryProbability;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LegacyPartitionManager
implements PartitionManager {
    private final Logger logger = LoggerFactory.getLogger(LegacyPartitionManager.class);
    private ClusterManager clusterManager;
    private SessionManager sessionManager;
    private ConcurrentMap<ConsumePartition, OwnerShip> ownerShipCache = new ConcurrentHashMap<ConsumePartition, OwnerShip>();
    private final Random random = new Random();
    private RetryProbability retryProbability = new RetryProbability();
    private PartitionLockInstance partitionLockInstance = new PartitionLockInstance();
    private CounterService counterService = new CounterService();

    public LegacyPartitionManager(ClusterManager clusterManager, SessionManager sessionManager) {
        this.clusterManager = clusterManager;
        this.sessionManager = sessionManager;
        sessionManager.addListener(new RemoveOccupyListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryOccupyPartition(Consumer consumer, short partition, long occupyTimeout) {
        ConsumePartition lockInstance;
        ConsumePartition consumePartition = new ConsumePartition(consumer.getTopic(), consumer.getApp(), partition);
        consumePartition.setConnectionId(consumer.getConnectionId());
        String clientId = consumer.getId();
        long expire = occupyTimeout + SystemClock.now();
        OwnerShip ownerShip = new OwnerShip(clientId, expire);
        boolean isSuccess = false;
        if (this.counterService.lockMorePartition(consumer)) {
            this.logger.info("Lock more partitions, consumer:{}", (Object)consumer);
            return false;
        }
        ConsumePartition consumePartition2 = lockInstance = this.partitionLockInstance.getLockInstance(consumePartition);
        synchronized (consumePartition2) {
            OwnerShip previous = (OwnerShip)this.ownerShipCache.get(consumePartition);
            if (previous != null) {
                if (previous.isExpire(SystemClock.now())) {
                    isSuccess = this.coverOccupy(consumePartition, previous, ownerShip);
                    this.increaseSerialErr(previous);
                    this.logger.warn("expire occupy partition:[{}], connectionId:[{}]", (Object)consumePartition, (Object)consumer.getConnectionId());
                }
            } else {
                isSuccess = this.doOccupy(consumePartition, ownerShip);
            }
        }
        return isSuccess;
    }

    private boolean doOccupy(ConsumePartition consumePartition, OwnerShip ownerShip) {
        this.ownerShipCache.put(consumePartition, ownerShip);
        this.counterService.increaseOccupyTimes(ownerShip.getOwner());
        return true;
    }

    private boolean coverOccupy(ConsumePartition consumePartition, OwnerShip previous, OwnerShip ownerShip) {
        this.ownerShipCache.put(consumePartition, ownerShip);
        this.counterService.decreaseOccupyTimes(previous.getOwner());
        this.counterService.increaseOccupyTimes(ownerShip.getOwner());
        return true;
    }

    private boolean releaseOccupy(ConsumePartition consumePartition) {
        OwnerShip remove = (OwnerShip)this.ownerShipCache.remove(consumePartition);
        if (remove != null) {
            this.counterService.decreaseOccupyTimes(remove.getOwner());
        }
        return true;
    }

    @Override
    public boolean releasePartition(Consumer consumer, short partition) {
        ConsumePartition consumePartition = new ConsumePartition(consumer.getTopic(), consumer.getApp(), partition);
        return this.releasePartition(consumePartition);
    }

    @Override
    public boolean releasePartition(ConsumePartition consumePartition) {
        return this.releaseOccupy(consumePartition);
    }

    @Override
    public boolean needPause(Consumer consumer) throws JoyQueueException {
        Consumer.ConsumerPolicy consumerPolicy = this.clusterManager.getConsumerPolicy(TopicName.parse((String)consumer.getTopic()), consumer.getApp());
        Boolean isNeedPause = consumerPolicy.getPaused();
        return isNeedPause == null ? false : isNeedPause;
    }

    @Override
    public void increaseSerialErr(OwnerShip ownerShip) {
        this.counterService.increaseErrTimes(ownerShip.getOwner());
    }

    @Override
    public void clearSerialErr(Consumer consumer) {
        this.counterService.clearErrTimes(consumer);
    }

    @Override
    public int selectPartitionIndex(int partitionSize, int partitionIndex, long accessTimes) {
        int index = partitionIndex < 0 ? (int)(accessTimes % (long)partitionSize) : partitionIndex % partitionSize;
        return index;
    }

    @Override
    public boolean isRetry(Consumer consumer) throws JoyQueueException {
        int randomBound = this.clusterManager.getRetryRandomBound(consumer.getTopic(), consumer.getApp());
        if (randomBound <= 0) {
            return false;
        }
        Boolean retry = this.clusterManager.getConsumerPolicy(TopicName.parse((String)consumer.getTopic()), consumer.getApp()).getRetry();
        List<Short> masterPartitionList = this.clusterManager.getLocalPartitions(TopicName.parse((String)consumer.getTopic()));
        if (!retry.booleanValue() || !masterPartitionList.contains((short)0)) {
            this.logger.debug("retry enable is false.");
            return false;
        }
        int val = this.random.nextInt(randomBound);
        int rate = this.retryProbability.getProbability(consumer.getJoint());
        return rate >= val;
    }

    @Override
    public void resetRetryProbability(Integer maxProbability) {
        this.retryProbability.resetMaxProbability(maxProbability);
    }

    @Override
    public void increaseRetryProbability(Consumer consumer) {
        this.retryProbability.increase(consumer.getJoint());
    }

    @Override
    public void decreaseRetryProbability(Consumer consumer) {
        this.retryProbability.decrease(consumer.getJoint());
    }

    @Override
    public List<Short> getPriorityPartition(TopicName topic) {
        List<Short> priorityPartitionList = this.clusterManager.getPriorityPartitionList(topic);
        if (CollectionUtils.isEmpty(priorityPartitionList)) {
            priorityPartitionList = new ArrayList<Short>(0);
        }
        return priorityPartitionList;
    }

    @Override
    public int getGroupByPartition(TopicName topic, short partition) {
        Integer partitionGroupId = this.clusterManager.getPartitionGroupId(topic, partition);
        if (partitionGroupId != null) {
            return partitionGroupId;
        }
        throw new IllegalArgumentException("Cannot find partitionGroup by topic:[" + topic + "],partition:[" + partition + "]");
    }

    @Override
    public boolean hasFreePartition(Consumer consumer) {
        boolean isFree = false;
        String clientId = consumer.getId();
        int occupyNum = this.counterService.getOccupyTimes(clientId);
        List<Short> masterPartitionList = this.clusterManager.getLocalPartitions(TopicName.parse((String)consumer.getTopic()));
        int partitionNum = masterPartitionList.size();
        if (partitionNum > occupyNum) {
            isFree = true;
        }
        return isFree;
    }

    class RemoveOccupyListener
    implements EventListener<SessionManager.SessionEvent> {
        RemoveOccupyListener() {
        }

        public void onEvent(SessionManager.SessionEvent event) {
            if (event.getType() == SessionManager.SessionEventType.RemoveConsumer) {
                LegacyPartitionManager.this.logger.info("Listen SessionManager.SessionEventType.RemoveConsumer, Event:[{}]", (Object)event);
                Consumer consumer = event.getConsumer();
                this.removeOccupyByConsumer(consumer);
            }
        }

        private void removeOccupyByConsumer(Consumer consumer) {
            List<Short> masterPartitionList = LegacyPartitionManager.this.clusterManager.getLocalPartitions(TopicName.parse((String)consumer.getTopic()));
            String clientId = consumer.getId();
            masterPartitionList.stream().forEach(partition -> {
                ConsumePartition consumePartition = new ConsumePartition(consumer.getTopic(), consumer.getApp(), (short)partition);
                OwnerShip ownerShip = (OwnerShip)LegacyPartitionManager.this.ownerShipCache.get(consumePartition);
                if (ownerShip != null && StringUtils.equals((CharSequence)ownerShip.getOwner(), (CharSequence)clientId)) {
                    LegacyPartitionManager.this.logger.info("remove occupy by topic:[{}], app:[{}], partition:[{}]", new Object[]{consumer.getTopic(), consumer.getApp(), partition});
                    LegacyPartitionManager.this.ownerShipCache.remove(consumePartition);
                    LegacyPartitionManager.this.counterService.clearOccupyTimes(clientId);
                    LegacyPartitionManager.this.counterService.clearErrTimes(consumer);
                }
            });
        }
    }

    private class CounterService {
        private ConcurrentMap<String, Counter> occupyCounter = new ConcurrentHashMap<String, Counter>();
        private ConcurrentMap<String, Counter> errCounter = new ConcurrentHashMap<String, Counter>();

        private CounterService() {
        }

        private void increaseOccupyTimes(String clientId) {
            Counter counter = (Counter)this.occupyCounter.get(clientId);
            if (counter == null) {
                counter = new Counter();
                this.occupyCounter.put(clientId, counter);
            }
            counter.increase();
        }

        private void decreaseOccupyTimes(String clientId) {
            Counter counter = (Counter)this.occupyCounter.get(clientId);
            if (counter == null) {
                return;
            }
            counter.decrease();
        }

        private void clearOccupyTimes(String clientId) {
            Counter counter = (Counter)this.occupyCounter.get(clientId);
            if (counter == null) {
                return;
            }
            this.occupyCounter.remove(clientId);
        }

        private int getOccupyTimes(String clientId) {
            Counter counter = (Counter)this.occupyCounter.get(clientId);
            if (counter == null) {
                return 0;
            }
            if (counter.isExpire()) {
                counter.clearTimes();
                return 0;
            }
            return counter.getTimes();
        }

        private boolean lockMorePartition(Consumer consumer) {
            String topic = consumer.getTopic();
            String app = consumer.getApp();
            int maxPartitionNum = 0;
            try {
                Consumer.ConsumerPolicy consumerPolicy = LegacyPartitionManager.this.clusterManager.getConsumerPolicy(TopicName.parse((String)topic), app);
                maxPartitionNum = consumerPolicy.getMaxPartitionNum();
            }
            catch (JoyQueueException e) {
                LegacyPartitionManager.this.logger.error(e.getMessage(), (Throwable)e);
            }
            String clientId = consumer.getId();
            return this.getOccupyTimes(clientId) > maxPartitionNum;
        }

        private int getErrTimes(Consumer consumer) {
            String clientId = consumer.getId();
            Counter counterObj = (Counter)this.errCounter.get(clientId);
            if (counterObj == null) {
                return 0;
            }
            if (counterObj.isExpire()) {
                counterObj.clearTimes();
                return 0;
            }
            return counterObj.getTimes();
        }

        private void increaseErrTimes(String clientId) {
            Counter counterObj = (Counter)this.errCounter.get(clientId);
            if (counterObj == null) {
                counterObj = new Counter();
                this.errCounter.put(clientId, counterObj);
            }
            counterObj.increase();
        }

        private void clearErrTimes(Consumer consumer) {
            String clientId = consumer.getId();
            this.errCounter.remove(clientId);
        }

        private class Counter {
            AtomicInteger times = new AtomicInteger(0);
            final long createTime = SystemClock.now();
            volatile long updateTime = SystemClock.now();

            private Counter() {
            }

            void increase() {
                this.times.incrementAndGet();
                this.updateTime = SystemClock.now();
            }

            int decrease() {
                this.updateTime = SystemClock.now();
                return this.times.decrementAndGet();
            }

            boolean isExpire() {
                return SystemClock.now() - this.updateTime > 60000L;
            }

            void clearTimes() {
                this.times.set(0);
            }

            int getTimes() {
                return this.times.get();
            }
        }
    }
}

