/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.broker.Plugins;
import org.joyqueue.broker.consumer.MessageConverter;
import org.joyqueue.message.BrokerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConvertSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Table<Byte, Byte, MessageConverter> converterTable = this.loadConverters();

    protected Table<Byte, Byte, MessageConverter> loadConverters() {
        HashBasedTable result = HashBasedTable.create();
        Iterable iterable = Plugins.MESSAGE_CONVERTER.extensions();
        for (MessageConverter messageConverter : iterable) {
            result.put(messageConverter.type(), (Object)messageConverter.target(), (Object)messageConverter);
        }
        return result;
    }

    public List<BrokerMessage> convert(BrokerMessage message, byte target) {
        LinkedList result = Lists.newLinkedList();
        if (message.isBatch()) {
            List<BrokerMessage> convertedMessages = this.doConvertBatch(message, target);
            if (convertedMessages != null) {
                result.addAll(convertedMessages);
            } else {
                result.add(message);
            }
        } else {
            BrokerMessage convertedMessage = this.doConvert(message, target);
            if (convertedMessage != null) {
                result.add(convertedMessage);
            } else {
                result.add(message);
            }
        }
        return result;
    }

    public List<BrokerMessage> convert(List<BrokerMessage> messages, byte target) {
        LinkedList result = Lists.newLinkedList();
        for (BrokerMessage message : messages) {
            if (message.isBatch()) {
                List<BrokerMessage> convertedMessages = this.doConvertBatch(message, target);
                if (convertedMessages != null) {
                    result.addAll(convertedMessages);
                    continue;
                }
                result.add(message);
                continue;
            }
            BrokerMessage convertedMessage = this.doConvert(message, target);
            if (convertedMessage != null) {
                result.add(convertedMessage);
                continue;
            }
            result.add(message);
        }
        return result;
    }

    protected BrokerMessage doConvert(BrokerMessage message, byte target) {
        MessageConverter messageConverter = (MessageConverter)this.converterTable.get((Object)message.getSource(), (Object)target);
        if (messageConverter == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("convert message {} to {}, converter: {}", new Object[]{message.getSource(), target, messageConverter});
        }
        return messageConverter.convert(message);
    }

    protected List<BrokerMessage> doConvertBatch(BrokerMessage message, byte target) {
        MessageConverter messageConverter = (MessageConverter)this.converterTable.get((Object)message.getSource(), (Object)target);
        if (messageConverter == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("convert message {} to {}, converter: {}", new Object[]{message.getSource(), target, messageConverter});
        }
        return messageConverter.convertBatch(message);
    }
}

