/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.archive.ArchiveManager;
import org.joyqueue.broker.archive.ConsumeArchiveService;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.AcknowledgeSupport;
import org.joyqueue.broker.consumer.ConsumeConfig;
import org.joyqueue.broker.consumer.DelayHandler;
import org.joyqueue.broker.consumer.FilterMessageSupport;
import org.joyqueue.broker.consumer.PartitionManager;
import org.joyqueue.broker.consumer.filter.FilterCallback;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.broker.consumer.position.PositionManager;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.MessageLocation;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.PositionOverflowException;
import org.joyqueue.store.PositionUnderflowException;
import org.joyqueue.store.ReadResult;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionConsumption
extends Service {
    private final Logger logger = LoggerFactory.getLogger(PartitionConsumption.class);
    private PartitionManager partitionManager;
    private StoreService storeService;
    private ClusterManager clusterManager;
    private PositionManager positionManager;
    private DelayHandler delayHandler = new DelayHandler();
    private FilterMessageSupport filterMessageSupport;
    private MessageRetry messageRetry;
    private ArchiveManager archiveManager;
    private ConsumeConfig config;
    private String monitorKey = "Read-Message";
    private final String innerAppPrefix = "innerFilter@";

    PartitionConsumption(ClusterManager clusterManager, StoreService storeService, PartitionManager partitionManager, PositionManager positionManager, MessageRetry messageRetry, FilterMessageSupport filterMessageSupport, ArchiveManager archiveManager, ConsumeConfig config) {
        this.clusterManager = clusterManager;
        this.storeService = storeService;
        this.partitionManager = partitionManager;
        this.positionManager = positionManager;
        this.messageRetry = messageRetry;
        this.filterMessageSupport = filterMessageSupport;
        this.archiveManager = archiveManager;
        this.config = config;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.logger.info("PartitionConsumption is started.");
    }

    protected void doStop() {
        super.doStop();
        this.logger.info("PartitionConsumption is stopped.");
    }

    protected PullResult getMessage(org.joyqueue.network.session.Consumer consumer, int count, long ackTimeout, long accessTimes) throws JoyQueueException {
        this.logger.debug("getMessage by topic:[{}], app:[{}], count:[{}], ackTimeout:[{}]", new Object[]{consumer.getTopic(), consumer.getApp(), count, ackTimeout});
        PullResult pullResult = new PullResult(consumer, -1, new ArrayList<ByteBuffer>(0));
        List<Short> priorityPartitionList = this.partitionManager.getPriorityPartition(TopicName.parse((String)consumer.getTopic()));
        if (priorityPartitionList.size() > 0) {
            pullResult = this.getFromPartition(consumer, priorityPartitionList, count, ackTimeout, accessTimes);
        }
        if (pullResult.count() < 1) {
            List<Short> partitionList = this.clusterManager.getLocalPartitions(TopicName.parse((String)consumer.getTopic()));
            if (this.partitionManager.isRetry(consumer)) {
                partitionList = new ArrayList<Short>(partitionList);
                partitionList.add((short)Short.MAX_VALUE);
            }
            pullResult = this.getFromPartition(consumer, partitionList, count, ackTimeout, accessTimes);
        }
        return pullResult;
    }

    private PullResult brokerMessage2PullResult(org.joyqueue.network.session.Consumer consumer, List<RetryMessageModel> msgList) throws JoyQueueException {
        ArrayList<ByteBuffer> resultList = new ArrayList<ByteBuffer>(msgList.size());
        for (RetryMessageModel message : msgList) {
            ByteBuffer wrap = ByteBuffer.wrap(message.getBrokerMessage());
            Serializer.setPartition(wrap, (short)Short.MAX_VALUE);
            Serializer.setIndex(wrap, message.getIndex());
            resultList.add(wrap);
        }
        PullResult pullResult = new PullResult(consumer, Short.MAX_VALUE, resultList);
        return pullResult;
    }

    private PullResult getFromPartition(org.joyqueue.network.session.Consumer consumer, List<Short> partitionList, int count, long ackTimeout, long accessTimes) throws JoyQueueException {
        int partitionSize = partitionList.size();
        int listIndex = -1;
        int retryMax = this.config.getPartitionSelectRetryMax();
        for (int i = 0; i < partitionSize; ++i) {
            short partition = partitionList.get(listIndex = this.partitionManager.selectPartitionIndex(partitionSize, listIndex, accessTimes));
            PullResult pullResult = this.getMessage4Sequence(consumer, partition, count, ackTimeout);
            int pullMsgCount = pullResult.getBuffers().size();
            if (pullMsgCount > 0) {
                if (this.config.getLogDetail(consumer.getApp())) {
                    this.logger.info("getFromPartition, topic: {}, app: {}, count: {}, partition: {}, partitions: {}, result: {}", new Object[]{consumer.getTopic(), consumer.getApp(), count, partition, partitionList, pullMsgCount});
                }
                return pullResult;
            }
            if (i == retryMax) break;
            ++listIndex;
        }
        return new PullResult(consumer, -1, new ArrayList<ByteBuffer>(0));
    }

    protected PullResult getMsgByPartitionAndIndex(org.joyqueue.network.session.Consumer consumer, int group, short partition, long index, int count) throws JoyQueueException, IOException {
        PullResult pullResult = new PullResult(consumer, -1, new ArrayList<ByteBuffer>(0));
        try {
            Consumer consumerConfig;
            PullResult readResult = this.getMsgByPartitionAndIndex(consumer.getTopic(), group, partition, index, count);
            if (readResult.getBuffers() == null) {
                return pullResult;
            }
            List<ByteBuffer> byteBuffers = readResult.getBuffers();
            if (StringUtils.isNotEmpty((CharSequence)consumer.getApp()) && !Consumer.ConsumeType.INTERNAL.equals((Object)consumer.getType()) && !Consumer.ConsumeType.KAFKA.equals((Object)consumer.getType()) && (consumerConfig = this.clusterManager.tryGetConsumer(TopicName.parse((String)consumer.getTopic()), consumer.getApp())) != null) {
                byteBuffers = this.filterMessageSupport.filter(consumerConfig, byteBuffers, new FilterCallbackImpl(consumer));
                byteBuffers = this.delayHandler.handle(consumerConfig.getConsumerPolicy(), byteBuffers);
            }
            pullResult = new PullResult(consumer, partition, byteBuffers);
        }
        catch (PositionOverflowException overflow) {
            this.logger.debug("PositionOverflow,topic:{},partition:{},index:{}", new Object[]{consumer.getTopic(), partition, index});
            if (overflow.getPosition() != overflow.getRight()) {
                pullResult.setCode(JoyQueueCode.SE_INDEX_OVERFLOW);
            }
        }
        catch (PositionUnderflowException underflow) {
            this.logger.debug("PositionUnderflow,topic:{},partition:{},index:{}", new Object[]{consumer.getTopic(), partition, index});
            pullResult.setCode(JoyQueueCode.SE_INDEX_UNDERFLOW);
        }
        return pullResult;
    }

    protected PullResult getMsgByPartitionAndIndex(String topic, int group, short partition, long index, int count) throws JoyQueueException, IOException {
        long startTime = System.nanoTime();
        PullResult result = new PullResult(topic, null, partition, null);
        PartitionGroupStore store = this.storeService.getStore(topic, group);
        ReadResult readRst = store.read(partition, index, count, Long.MAX_VALUE);
        if (readRst.getCode() == JoyQueueCode.SUCCESS) {
            result.setBuffers(Lists.newArrayList((Object[])readRst.getMessages()));
            return result;
        }
        this.logger.error("read message error, error code[{}]", (Object)readRst.getCode());
        result.setCode(readRst.getCode());
        return result;
    }

    protected PullResult getMsgByPartitionAndIndex(org.joyqueue.network.session.Consumer consumer, short partition, long index, int count) throws IOException, JoyQueueException {
        Integer group = this.partitionManager.getGroupByPartition(TopicName.parse((String)consumer.getTopic()), partition);
        Preconditions.checkArgument((group != null && group >= 0 ? 1 : 0) != 0, (Object)("\u627e\u4e0d\u5230\u4e3b\u9898[" + consumer.getTopic() + "],\u5206\u533a[" + partition + "]\u7684\u5206\u533a\u7ec4"));
        return this.getMsgByPartitionAndIndex(consumer, (int)group, partition, index, count);
    }

    protected PullResult getMessage4Sequence(org.joyqueue.network.session.Consumer consumer, short partition, int count, long ackTimeout) throws JoyQueueException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("try getMessage4Sequence by topic:[{}], app:[{}], partition:[{}], count:[{}], ackTimeout:[{}]", new Object[]{consumer.getTopic(), consumer.getApp(), partition, count, ackTimeout});
        }
        PullResult pullResult = new PullResult(consumer, -1, new ArrayList<ByteBuffer>(0));
        if (this.partitionManager.tryOccupyPartition(consumer, partition, ackTimeout)) {
            if (partition == Short.MAX_VALUE) {
                if ((pullResult = this.getRetryMessage(consumer, pullResult)).count() < 1) {
                    this.partitionManager.releasePartition(consumer, partition);
                }
                return pullResult;
            }
            int partitionGroup = this.clusterManager.getPartitionGroupId(TopicName.parse((String)consumer.getTopic()), partition);
            long index = this.positionManager.getLastMsgAckIndex(TopicName.parse((String)consumer.getTopic()), consumer.getApp(), partition);
            try {
                Object[] byteBuffers = this.readMessages(consumer, partitionGroup, partition, index, count);
                if (byteBuffers == null) {
                    this.partitionManager.releasePartition(consumer, partition);
                    return pullResult;
                }
                List<Object> rByteBufferList = Lists.newArrayList((Object[])byteBuffers);
                Consumer consumerConfig = this.clusterManager.getConsumer(TopicName.parse((String)consumer.getTopic()), consumer.getApp());
                rByteBufferList = this.filterMessageSupport.filter(consumerConfig, (List<ByteBuffer>)rByteBufferList, new FilterCallbackImpl(consumer));
                rByteBufferList = this.delayHandler.handle(consumerConfig.getConsumerPolicy(), (List<ByteBuffer>)rByteBufferList);
                if (rByteBufferList != null && rByteBufferList.size() == 0) {
                    this.partitionManager.releasePartition(consumer, partition);
                }
                pullResult = new PullResult(consumer, partition, rByteBufferList);
                if (this.config.getLogDetail(consumer.getApp())) {
                    this.logger.info("getMessage4Sequence, topic: {}, app: {}, count: {}, partition: {}, index: {}, result: {}", new Object[]{consumer.getTopic(), consumer.getApp(), count, partition, index, pullResult.getBuffers().size()});
                }
            }
            catch (Exception ex) {
                this.partitionManager.releasePartition(consumer, partition);
                if (ex instanceof PositionOverflowException) {
                    long rightIndex = ((PositionOverflowException)((Object)ex)).getRight();
                    if (rightIndex < index) {
                        pullResult.setCode(JoyQueueCode.SE_INDEX_OVERFLOW);
                        this.logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                if (ex instanceof PositionUnderflowException) {
                    pullResult.setCode(JoyQueueCode.SE_INDEX_UNDERFLOW);
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
                this.logger.error("get message error, consumer: {}, partition: {}", new Object[]{consumer, partition, ex});
            }
        }
        return pullResult;
    }

    private PullResult getRetryMessage(org.joyqueue.network.session.Consumer consumer, PullResult pullResult) throws JoyQueueException {
        List retryMsgList = this.messageRetry.getRetry(consumer.getTopic(), consumer.getApp(), (short)1, 0L);
        if (CollectionUtils.isNotEmpty((Collection)retryMsgList) && retryMsgList.size() > 0) {
            pullResult = this.brokerMessage2PullResult(consumer, retryMsgList);
            this.partitionManager.increaseRetryProbability(consumer);
        } else {
            this.partitionManager.decreaseRetryProbability(consumer);
        }
        return pullResult;
    }

    private ByteBuffer[] readMessages(org.joyqueue.network.session.Consumer consumer, int partitionGroup, short partition, long index, int count) throws IOException {
        PartitionGroupStore store = this.storeService.getStore(consumer.getTopic(), partitionGroup);
        if (index < store.getLeftIndex(partition) || index >= store.getRightIndex(partition)) {
            return null;
        }
        try {
            ReadResult readRst = store.read(partition, index, count, Long.MAX_VALUE);
            if (readRst.getCode() == JoyQueueCode.SUCCESS) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("readMessage by topic:[{}], app:[{}], partition:[{}], consumer: [{}], count:[{}], result: {}", new Object[]{consumer.getTopic(), consumer.getApp(), partition, consumer, count, ArrayUtils.getLength((Object)readRst.getMessages())});
                }
                return readRst.getMessages();
            }
            this.logger.error("read message error, error code[{}]", (Object)readRst.getCode());
        }
        catch (PositionOverflowException overflow) {
            this.logger.debug("PositionOverflow,topic:{},app:{},partition:{},index:{}", new Object[]{consumer.getTopic(), consumer.getApp(), partition, index});
            throw overflow;
        }
        catch (PositionUnderflowException underflow) {
            this.logger.debug("PositionUnderflow,topic:{},app:{},partition:{},index:{}", new Object[]{consumer.getTopic(), consumer.getApp(), partition, index});
            throw underflow;
        }
        return null;
    }

    private void innerAcknowledge(org.joyqueue.network.session.Consumer consumer, List<ByteBuffer> inValidList) throws JoyQueueException {
        if (inValidList == null) {
            return;
        }
        MessageLocation[] messageLocations = this.convertMessageLocation(consumer.getTopic(), inValidList);
        this.acknowledge(messageLocations, consumer, true);
        this.archiveIfNecessary(messageLocations);
    }

    private void archiveIfNecessary(MessageLocation[] messageLocations) throws JoyQueueException {
        ConsumeArchiveService archiveService;
        if (this.archiveManager == null || (archiveService = this.archiveManager.getConsumeArchiveService()) == null) {
            return;
        }
        Connection connection = new Connection();
        try {
            connection.setAddress(IpUtil.toByte((InetSocketAddress)new InetSocketAddress(IpUtil.getLocalIp(), 50088)));
        }
        catch (Exception ex) {
            connection.setAddress(new byte[0]);
        }
        connection.setApp("innerFilter@" + connection.getApp());
        archiveService.appendConsumeLog(connection, messageLocations);
    }

    private MessageLocation[] convertMessageLocation(String topic, List<ByteBuffer> inValidList) {
        MessageLocation[] locations = new MessageLocation[inValidList.size()];
        for (int i = 0; i < inValidList.size(); ++i) {
            ByteBuffer buffer = inValidList.get(i);
            short partition = Serializer.readPartition(buffer);
            long index = Serializer.readIndex(buffer);
            locations[i] = new MessageLocation(topic, partition, index);
        }
        return locations;
    }

    public boolean acknowledge(MessageLocation[] locations, org.joyqueue.network.session.Consumer consumer, boolean isSuccessAck) throws JoyQueueException {
        boolean isSuccess = false;
        if (locations.length < 1) {
            return false;
        }
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        short partition = locations[0].getPartition();
        if (partition == Short.MAX_VALUE) {
            this.logger.debug("retry ack by topic:[{}], app:[{}], locations:[{}]", new Object[]{topic, app, Arrays.toString(locations)});
            return this.retryAck(topic, app, locations, isSuccessAck);
        }
        long[] indexArr = AcknowledgeSupport.sortMsgLocation(locations);
        if (indexArr != null) {
            long lastMsgAckIndex = this.positionManager.getLastMsgAckIndex(TopicName.parse((String)topic), app, partition);
            if (lastMsgAckIndex == indexArr[0]) {
                long curIndex = indexArr[1];
                long updateMsgAckIndex = curIndex + 1L;
                isSuccess = this.positionManager.updateLastMsgAckIndex(TopicName.parse((String)topic), app, partition, updateMsgAckIndex);
                this.positionManager.updateLastMsgPullIndex(TopicName.parse((String)consumer.getTopic()), consumer.getApp(), partition, updateMsgAckIndex);
            } else {
                this.logger.error("ack index : [{} - {}] is not continue, partition: {}, currentIndex is : [{}], consumer info is : {}", new Object[]{indexArr[0], indexArr[1], partition, lastMsgAckIndex, consumer});
            }
        } else {
            throw new JoyQueueException(JoyQueueCode.FW_CONSUMER_ACK_FAIL, new Object[]{"ack index is not continue or repeatable!"});
        }
        if (this.config.getLogDetail(consumer.getApp())) {
            this.logger.info("acknowledge, topic: {}, app: {}, partition: {}, startIndex: {}, endIndex: {}, isSuccess: {}", new Object[]{consumer.getTopic(), consumer.getApp(), partition, indexArr[0], indexArr[1], isSuccess});
        }
        return isSuccess;
    }

    private boolean retryAck(String topic, String app, MessageLocation[] locations, boolean isSuccess) {
        Object[] indexArr = new Long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            indexArr[i] = locations[i].getIndex();
        }
        try {
            if (isSuccess) {
                this.messageRetry.retrySuccess(topic, app, indexArr);
            } else {
                this.messageRetry.retryError(topic, app, indexArr);
            }
        }
        catch (JoyQueueException e) {
            this.logger.error("RetryAck error.", (Throwable)e);
            return false;
        }
        return true;
    }

    class FilterCallbackImpl
    implements FilterCallback {
        private org.joyqueue.network.session.Consumer consumer;

        FilterCallbackImpl(org.joyqueue.network.session.Consumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void callback(List<ByteBuffer> byteBuffers) throws JoyQueueException {
            PartitionConsumption.this.innerAcknowledge(this.consumer, byteBuffers);
        }
    }
}

