/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer;

import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.archive.ArchiveManager;
import org.joyqueue.broker.archive.ConsumeArchiveService;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.AcknowledgeSupport;
import org.joyqueue.broker.consumer.ConcurrentConsumer;
import org.joyqueue.broker.consumer.ConsumeConfig;
import org.joyqueue.broker.consumer.DelayHandler;
import org.joyqueue.broker.consumer.FilterMessageSupport;
import org.joyqueue.broker.consumer.PartitionManager;
import org.joyqueue.broker.consumer.model.ConsumePartition;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.broker.consumer.position.PositionManager;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.MessageLocation;
import org.joyqueue.network.session.Connection;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.PositionOverflowException;
import org.joyqueue.store.PositionUnderflowException;
import org.joyqueue.store.ReadResult;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.concurrent.CasLock;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.format.Format;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlideWindowConcurrentConsumer
extends Service
implements ConcurrentConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SlideWindowConcurrentConsumer.class);
    private PartitionManager partitionManager;
    private MessageRetry messageRetry;
    private PositionManager positionManager;
    private StoreService storeService;
    private ClusterManager clusterManager;
    private FilterMessageSupport filterMessageSupport;
    private ConcurrentMap<ConsumePartition, Boolean> resetPullPositionFlag = new ConcurrentHashMap<ConsumePartition, Boolean>();
    private DelayHandler delayHandler = new DelayHandler();
    private ArchiveManager archiveManager;
    private ConsumeConfig consumeConfig;
    private static final long CLEAN_INTERVAL_SEC = 600L;
    private final Map<ConsumePartition, SlideWindow> slideWindowMap = new ConcurrentHashMap<ConsumePartition, SlideWindow>();
    private final ScheduledExecutorService scheduledExecutorService;
    private static final String innerAppPrefix = "innerFilter@";

    SlideWindowConcurrentConsumer(ClusterManager clusterManager, StoreService storeService, PartitionManager partitionManager, MessageRetry messageRetry, PositionManager positionManager, FilterMessageSupport filterMessageSupport, ArchiveManager archiveManager, ConsumeConfig consumeConfig) {
        this.clusterManager = clusterManager;
        this.storeService = storeService;
        this.partitionManager = partitionManager;
        this.messageRetry = messageRetry;
        this.positionManager = positionManager;
        this.filterMessageSupport = filterMessageSupport;
        this.archiveManager = archiveManager;
        this.consumeConfig = consumeConfig;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("ConcurrentConsumerClearExecutor", true));
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.slideWindowMap.entrySet().removeIf(entry -> {
            ConsumePartition consumePartition = (ConsumePartition)entry.getKey();
            try {
                Consumer.ConsumerPolicy policy = this.clusterManager.getConsumerPolicy(TopicName.parse((String)consumePartition.getTopic()), consumePartition.getApp());
                return policy.isConcurrent() == false;
            }
            catch (Exception e) {
                logger.warn("Clean expire error: {}", (Object)e.getMessage());
                return false;
            }
        }), 632L, 600L, TimeUnit.SECONDS);
        logger.info("SlideWindowConcurrentConsumer is started.");
    }

    protected void doStop() {
        super.doStop();
        Close.close((ExecutorService)this.scheduledExecutorService);
        logger.info("SlideWindowConcurrentConsumer is stopped.");
    }

    @Override
    public PullResult getMessage(org.joyqueue.network.session.Consumer consumer, int count, long ackTimeout, long accessTimes, int concurrent) throws JoyQueueException {
        List<Short> priorityPartitionList;
        List<Short> partitionList = this.clusterManager.getLocalPartitions(TopicName.parse((String)consumer.getTopic()));
        PullResult pullResult = this.partitionManager.isRetry(consumer) ? this.getRetryMessages(consumer, (short)count) : ((priorityPartitionList = this.partitionManager.getPriorityPartition(TopicName.parse((String)consumer.getTopic()))).size() > 0 ? this.getFromPartition(consumer, priorityPartitionList, count, ackTimeout, accessTimes, concurrent) : this.getFromPartition(consumer, partitionList, count, ackTimeout, accessTimes, concurrent));
        return pullResult;
    }

    private PullResult getRetryMessages(org.joyqueue.network.session.Consumer consumer, short count) throws JoyQueueException {
        List retryMessage = this.messageRetry.getRetry(consumer.getTopic(), consumer.getApp(), count, 0L);
        List<ByteBuffer> messages = this.convert(retryMessage);
        PullResult pullResult = new PullResult(consumer, -1, new ArrayList<ByteBuffer>(messages.size()));
        pullResult.setBuffers(messages);
        if (messages.size() > 0) {
            this.partitionManager.increaseRetryProbability(consumer);
        } else {
            this.partitionManager.decreaseRetryProbability(consumer);
        }
        return pullResult;
    }

    private void archiveIfNecessary(MessageLocation[] messageLocations) throws JoyQueueException {
        ConsumeArchiveService archiveService;
        if (this.archiveManager == null || (archiveService = this.archiveManager.getConsumeArchiveService()) == null) {
            return;
        }
        Connection connection = new Connection();
        try {
            connection.setAddress(IpUtil.toByte((InetSocketAddress)new InetSocketAddress(IpUtil.getLocalIp(), 50088)));
        }
        catch (Exception ex) {
            connection.setAddress(new byte[0]);
        }
        connection.setApp(innerAppPrefix + connection.getApp());
        archiveService.appendConsumeLog(connection, messageLocations);
    }

    private MessageLocation[] convertMessageLocation(String topic, List<ByteBuffer> inValidList) {
        MessageLocation[] locations = new MessageLocation[inValidList.size()];
        for (int i = 0; i < inValidList.size(); ++i) {
            ByteBuffer buffer = inValidList.get(i);
            short partition = Serializer.readPartition(buffer);
            long index = Serializer.readIndex(buffer);
            locations[i] = new MessageLocation(topic, partition, index);
        }
        return locations;
    }

    private List<ByteBuffer> convert(List<RetryMessageModel> retryMessage) throws JoyQueueException {
        if (CollectionUtils.isEmpty(retryMessage)) {
            return new ArrayList<ByteBuffer>(0);
        }
        ArrayList<ByteBuffer> rst = new ArrayList<ByteBuffer>(retryMessage.size());
        for (RetryMessageModel message : retryMessage) {
            try {
                ByteBuffer wrap = ByteBuffer.wrap(message.getBrokerMessage());
                Serializer.setPartition(wrap, (short)Short.MAX_VALUE);
                Serializer.setIndex(wrap, message.getIndex());
                rst.add(wrap);
            }
            catch (Exception e) {
                throw new JoyQueueException(JoyQueueCode.SE_IO_ERROR, (Throwable)e, new Object[0]);
            }
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PullResult getFromPartition(org.joyqueue.network.session.Consumer consumer, List<Short> partitionList, int count, long ackTimeout, long accessTimes, int concurrent) throws JoyQueueException {
        int partitionSize = partitionList.size();
        int listIndex = -1;
        int retryMax = this.consumeConfig.getPartitionSelectRetryMax();
        PullResult pullResult = new PullResult(consumer, -1, new ArrayList<ByteBuffer>(0));
        for (int i = 0; i < partitionSize && i != retryMax; ++i) {
            listIndex = this.partitionManager.selectPartitionIndex(partitionSize, listIndex + i, accessTimes);
            short partition = partitionList.get(listIndex);
            ConsumePartition consumePartition = new ConsumePartition(consumer.getTopic(), consumer.getApp(), partition);
            SlideWindow slideWindow = this.slideWindowMap.computeIfAbsent(consumePartition, k -> {
                try {
                    return new SlideWindow(this.getPullIndex(consumer, k.getPartition()));
                }
                catch (JoyQueueException e) {
                    throw new RuntimeException(e);
                }
            });
            ConsumedMessages consumedMessages = slideWindow.tryGetAndLockExpired(ackTimeout);
            if (null != consumedMessages) {
                ReadMessagesResult readMessagesResult = this.readMessages(consumer, partition, consumedMessages.getStartIndex(), consumedMessages.getCount());
                pullResult = readMessagesResult.getPullResult();
                break;
            }
            if (slideWindow.concurrentCount() >= concurrent || !slideWindow.getAppendLock().tryLock()) continue;
            try {
                boolean extended;
                long filteredMessageStartIndex;
                long pullIndex = this.getPullIndex(consumer, partition);
                logger.debug("get pull index:{}, topic:{}, app:{}, partition:{}", new Object[]{pullIndex, consumer.getTopic(), consumer.getApp(), partition});
                ReadMessagesResult readMessagesResult = this.readMessages(consumer, partition, pullIndex, count);
                pullResult = readMessagesResult.getPullResult();
                List<ByteBuffer> pullMessages = pullResult.getBuffers();
                List<ByteBuffer> filteredMessages = readMessagesResult.getFilteredMessages();
                if (null == filteredMessages) {
                    filteredMessages = new ArrayList<ByteBuffer>(0);
                }
                if (pullMessages.size() + filteredMessages.size() == 0) continue;
                long pullMessageStartIndex = pullMessages.size() > 0 ? Serializer.readIndex(pullMessages.get(0)) : -1L;
                long l = filteredMessageStartIndex = filteredMessages.size() > 0 ? Serializer.readIndex(filteredMessages.get(0)) : -1L;
                if (pullIndex == pullMessageStartIndex) {
                    boolean extended2;
                    int filterMessageCount;
                    int msgCount = this.count(pullMessages);
                    if (filteredMessageStartIndex >= 0L && filteredMessageStartIndex != pullMessageStartIndex + (long)msgCount) {
                        throw new JoyQueueException(String.format("Index not match, pullIndex: %s, pullMessageStartIndex: %s, filteredMessageStartIndex: %s, topic: %s, partition: %d!", Format.formatWithComma((long)pullIndex), Format.formatWithComma((long)pullMessageStartIndex), Format.formatWithComma((long)filteredMessageStartIndex), consumer.getType(), partition), JoyQueueCode.CONSUME_POSITION_UPDATE_ERROR.getCode());
                    }
                    if (msgCount > 0 && !(extended = this.extendSlideWindowAndUpdatePullIndex(pullMessageStartIndex, msgCount, consumer, partition, ackTimeout, false, slideWindow))) continue;
                    if (filteredMessageStartIndex >= 0L && (filterMessageCount = this.count(filteredMessages)) > 0 && (extended2 = this.extendSlideWindowAndUpdatePullIndex(filteredMessageStartIndex, filterMessageCount, consumer, partition, ackTimeout, true, slideWindow))) {
                        MessageLocation[] messageLocations = this.convertMessageLocation(consumer.getTopic(), filteredMessages);
                        this.archiveIfNecessary(messageLocations);
                    }
                    if (msgCount > 0) break;
                    continue;
                }
                if (pullIndex == filteredMessageStartIndex) {
                    boolean extended3;
                    int msgCount;
                    int filterMessageCount = this.count(filteredMessages);
                    if (pullMessageStartIndex >= 0L && pullMessageStartIndex != filteredMessageStartIndex + (long)filterMessageCount) {
                        throw new JoyQueueException(String.format("Index not match, pullIndex: %s, pullMessageStartIndex: %s, filteredMessageStartIndex: %s, topic: %s, partition: %d!", Format.formatWithComma((long)pullIndex), Format.formatWithComma((long)pullMessageStartIndex), Format.formatWithComma((long)filteredMessageStartIndex), consumer.getType(), partition), JoyQueueCode.CONSUME_POSITION_UPDATE_ERROR.getCode());
                    }
                    if (filterMessageCount > 0) {
                        extended = this.extendSlideWindowAndUpdatePullIndex(filteredMessageStartIndex, filterMessageCount, consumer, partition, ackTimeout, true, slideWindow);
                        if (!extended) continue;
                        MessageLocation[] messageLocations = this.convertMessageLocation(consumer.getTopic(), filteredMessages);
                        this.archiveIfNecessary(messageLocations);
                    }
                    if ((msgCount = this.count(filteredMessages)) > 0 && !(extended3 = this.extendSlideWindowAndUpdatePullIndex(pullMessageStartIndex, msgCount, consumer, partition, ackTimeout, false, slideWindow))) continue;
                    if (msgCount > 0) break;
                    continue;
                }
                throw new JoyQueueException(String.format("Index not match, pullIndex: %s, pullMessageStartIndex: %s, filteredMessageStartIndex: %s, topic: %s, partition: %d!", Format.formatWithComma((long)pullIndex), Format.formatWithComma((long)pullMessageStartIndex), Format.formatWithComma((long)filteredMessageStartIndex), consumer.getType(), partition), JoyQueueCode.CONSUME_POSITION_UPDATE_ERROR.getCode());
            }
            finally {
                slideWindow.getAppendLock().unlock();
            }
        }
        return pullResult;
    }

    private boolean extendSlideWindowAndUpdatePullIndex(long pullIndex, int msgCount, org.joyqueue.network.session.Consumer consumer, short partition, long ackTimeout, boolean ack, SlideWindow slideWindow) throws JoyQueueException {
        ConsumedMessages consumedMessages = slideWindow.appendUnsafe(consumer.getTopic(), partition, pullIndex, msgCount, ackTimeout);
        if (null != consumedMessages) {
            if (ack) {
                consumedMessages.ack();
            }
            long newPullIndex = pullIndex + (long)msgCount;
            logger.debug("set new pull index:{}, topic:{}, app:{}, partition:{}", new Object[]{newPullIndex, consumer.getTopic(), consumer.getApp(), partition});
            this.positionManager.updateLastMsgPullIndex(TopicName.parse((String)consumer.getTopic()), consumer.getApp(), partition, newPullIndex);
            return true;
        }
        return false;
    }

    private int count(List<ByteBuffer> buffers) {
        int count = 0;
        for (ByteBuffer buffer : buffers) {
            BrokerMessage header = Serializer.readBrokerMessageHeader(buffer);
            if (header.isBatch()) {
                count += header.getFlag();
                continue;
            }
            ++count;
        }
        return count;
    }

    private long getPullIndex(org.joyqueue.network.session.Consumer consumer, short partition) throws JoyQueueException {
        long pullIndex = 0L;
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        ConsumePartition consumePartition = new ConsumePartition(topic, app, partition);
        TopicName topicName = TopicName.parse((String)topic);
        Boolean isReset = (Boolean)this.resetPullPositionFlag.get(consumePartition);
        if (isReset != null && isReset.booleanValue()) {
            pullIndex = this.positionManager.getLastMsgPullIndex(topicName, app, partition);
            if (pullIndex == -1L) {
                this.positionManager.updateLastMsgPullIndex(topicName, app, partition, this.positionManager.getLastMsgAckIndex(topicName, app, partition));
            }
        } else {
            long lastAckIndex = this.positionManager.getLastMsgAckIndex(topicName, app, partition);
            boolean isSuccess = this.positionManager.updateLastMsgPullIndex(topicName, app, partition, lastAckIndex);
            if (isSuccess) {
                this.resetPullPositionFlag.put(consumePartition, Boolean.TRUE);
                pullIndex = lastAckIndex;
            }
            logger.info("init concurrent pull index [{}]", (Object)pullIndex);
        }
        return pullIndex;
    }

    private ReadMessagesResult readMessages(org.joyqueue.network.session.Consumer consumer, short partition, long index, int count) {
        ReadMessagesResult readMessagesResult = new ReadMessagesResult();
        PullResult pullResult = new PullResult(consumer, -1, new ArrayList<ByteBuffer>(0));
        try {
            int partitionGroup = this.clusterManager.getPartitionGroupId(TopicName.parse((String)consumer.getTopic()), partition);
            PartitionGroupStore store = this.storeService.getStore(consumer.getTopic(), partitionGroup);
            ReadResult readRst = store.read(partition, index, count, Long.MAX_VALUE);
            if (readRst.getCode() == JoyQueueCode.SUCCESS) {
                ArrayList byteBufferList = Lists.newArrayList((Object[])readRst.getMessages());
                Consumer consumerConfig = this.clusterManager.getConsumer(TopicName.parse((String)consumer.getTopic()), consumer.getApp());
                if (consumerConfig != null) {
                    List<ByteBuffer> byteBuffers = this.filterMessageSupport.filter(consumerConfig, byteBufferList, readMessagesResult::setFilteredMessages);
                    byteBuffers = this.delayHandler.handle(consumerConfig.getConsumerPolicy(), byteBuffers);
                    pullResult = new PullResult(consumer, partition, byteBuffers);
                }
            } else {
                logger.error("read message error, error code[{}]", (Object)readRst.getCode());
            }
        }
        catch (PositionOverflowException e) {
            if (e.getRight() < index) {
                pullResult.setCode(JoyQueueCode.SE_INDEX_OVERFLOW);
            }
        }
        catch (PositionUnderflowException e) {
            pullResult.setCode(JoyQueueCode.SE_INDEX_UNDERFLOW);
        }
        catch (Exception ex) {
            logger.error("get message error, consumer: {}, partition: {}", new Object[]{consumer, partition, ex});
        }
        readMessagesResult.setPullResult(pullResult);
        return readMessagesResult;
    }

    @Override
    public boolean acknowledge(MessageLocation[] locations, org.joyqueue.network.session.Consumer consumer, boolean isSuccessAck) throws JoyQueueException {
        ConsumePartition consumePartition;
        SlideWindow slideWindow;
        boolean isSuccess = false;
        if (locations.length < 1) {
            return false;
        }
        String topic = consumer.getTopic();
        String app = consumer.getApp();
        short partition = locations[0].getPartition();
        if (partition == Short.MAX_VALUE) {
            return this.retryAck(topic, app, locations, isSuccessAck);
        }
        long[] locationArray = new long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            locationArray[i] = locations[i].getIndex();
        }
        logger.debug("pre ack, partition: {}, index: {}", (Object)partition, (Object)locationArray);
        long[] indexArr = AcknowledgeSupport.sortMsgLocation(locations);
        if (indexArr != null && null != (slideWindow = this.slideWindowMap.get(consumePartition = new ConsumePartition(topic, app, partition)))) {
            long startIndex = indexArr[0];
            int count = (int)(indexArr[1] - indexArr[0] + 1L);
            isSuccess = slideWindow.ack(TopicName.parse((String)topic), app, partition, startIndex, count, this.positionManager);
        }
        return isSuccess;
    }

    private boolean retryAck(String topic, String app, MessageLocation[] locations, boolean isSuccess) {
        Object[] indexArr = new Long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            indexArr[i] = locations[i].getIndex();
        }
        try {
            if (isSuccess) {
                this.messageRetry.retrySuccess(topic, app, indexArr);
            } else {
                this.messageRetry.retryError(topic, app, indexArr);
            }
        }
        catch (JoyQueueException e) {
            logger.error("RetryAck error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private static class ConsumedMessages {
        static final int LOCKED = 0;
        static final int ACKED = 1;
        static final int EXPIRED = -1;
        private final long startIndex;
        private final int count;
        private long expireTime;
        private AtomicInteger status = new AtomicInteger(0);

        ConsumedMessages(long startIndex, int count, long timeoutMs) {
            this.startIndex = startIndex;
            this.count = count;
            this.expireTime = SystemClock.now() + timeoutMs;
        }

        int getCount() {
            return this.count;
        }

        long getStartIndex() {
            return this.startIndex;
        }

        boolean tryLock(long timeoutMs) {
            this.maybeUnlockExpired();
            if (this.status.compareAndSet(-1, 0)) {
                this.expireTime = SystemClock.now() + timeoutMs;
                return true;
            }
            return false;
        }

        private void maybeUnlockExpired() {
            if (this.status.get() == 0 && SystemClock.now() > this.expireTime) {
                this.status.compareAndSet(0, -1);
            }
        }

        private void ack() {
            this.status.set(1);
        }

        boolean isExpired() {
            this.maybeUnlockExpired();
            return this.status.get() == -1;
        }

        boolean isAcked() {
            return this.status.get() == 1;
        }
    }

    private static class SlideWindow {
        private final NavigableMap<Long, ConsumedMessages> consumedMessagesMap = new ConcurrentSkipListMap<Long, ConsumedMessages>();
        private final AtomicLong lastCheckExpireTimestamp = new AtomicLong(0L);
        private static final long MIN_CHECK_EXPIRE_INTERVAL_MS = 1000L;
        private AtomicInteger expiredCount = new AtomicInteger(0);
        private final CasLock appendLock = new CasLock();
        private long nextPullIndex;

        SlideWindow(long nextPullIndex) {
            this.nextPullIndex = nextPullIndex;
        }

        int concurrentCount() {
            return this.consumedMessagesMap.size();
        }

        ConsumedMessages tryGetAndLockExpired(long ackTimeoutMs) {
            long timestamp;
            ConsumedMessages result = this.tryFindFirstExpired(ackTimeoutMs);
            if (this.lastCheckExpireTimestamp.get() + 1000L < SystemClock.now() && (timestamp = this.lastCheckExpireTimestamp.get()) + 1000L < SystemClock.now() && this.lastCheckExpireTimestamp.compareAndSet(timestamp, SystemClock.now())) {
                this.expiredCount.set(0);
                for (ConsumedMessages consumedMessages : this.consumedMessagesMap.values()) {
                    if (!consumedMessages.isExpired()) continue;
                    this.expiredCount.incrementAndGet();
                }
                result = this.tryFindFirstExpired(ackTimeoutMs);
            }
            return result;
        }

        private ConsumedMessages tryFindFirstExpired(long ackTimeoutMs) {
            ConsumedMessages result = null;
            if (this.expiredCount.get() > 0) {
                result = this.consumedMessagesMap.values().stream().filter(cm -> cm.tryLock(ackTimeoutMs)).findFirst().orElse(null);
                if (null != result) {
                    this.expiredCount.decrementAndGet();
                } else {
                    this.expiredCount.set(0);
                }
            }
            return result;
        }

        ConsumedMessages appendUnsafe(String topic, short partition, long nextPullIndex, int count, long timeoutMs) {
            if (this.nextPullIndex != nextPullIndex) {
                logger.warn("Reset concurrent consumer pull index from {} to {}, topic: {}, partition: {}.", new Object[]{this.nextPullIndex, nextPullIndex, topic, partition});
                this.consumedMessagesMap.clear();
                this.nextPullIndex = nextPullIndex;
            }
            ConsumedMessages consumedMessages = new ConsumedMessages(nextPullIndex, count, timeoutMs);
            this.nextPullIndex += (long)count;
            this.consumedMessagesMap.put(nextPullIndex, consumedMessages);
            return consumedMessages;
        }

        CasLock getAppendLock() {
            return this.appendLock;
        }

        boolean ack(TopicName topic, String app, short partition, long startIndex, int count, PositionManager positionManager) throws JoyQueueException {
            int remainingCount;
            ConsumedMessages consumedMessages;
            LinkedList<ConsumedMessages> toBeAcked = new LinkedList<ConsumedMessages>();
            boolean ret = false;
            long curIndex = startIndex;
            for (remainingCount = count; remainingCount > 0 && (consumedMessages = (ConsumedMessages)this.consumedMessagesMap.get(curIndex)) != null; remainingCount -= consumedMessages.count) {
                toBeAcked.add(consumedMessages);
                curIndex += (long)consumedMessages.count;
            }
            if (remainingCount == 0 && toBeAcked.size() > 0) {
                toBeAcked.forEach(rec$ -> ((ConsumedMessages)rec$).ack());
                while (!this.consumedMessagesMap.isEmpty() && (consumedMessages = this.consumedMessagesMap.firstEntry().getValue()).isAcked()) {
                    long lastMsgAckIndex = positionManager.getLastMsgAckIndex(topic, app, partition);
                    this.consumedMessagesMap.remove(consumedMessages.getStartIndex());
                    if (lastMsgAckIndex >= consumedMessages.getStartIndex() && lastMsgAckIndex < consumedMessages.getStartIndex() + (long)consumedMessages.getCount()) {
                        positionManager.updateLastMsgAckIndex(topic, app, partition, consumedMessages.getStartIndex() + (long)consumedMessages.getCount(), false);
                        continue;
                    }
                    logger.warn("Ack index not match, topic: {}, partition: {}, ack: [{} - {}), currentAckIndex: {}!", new Object[]{topic.getFullName(), partition, Format.formatWithComma((long)consumedMessages.getStartIndex()), Format.formatWithComma((long)(consumedMessages.getStartIndex() + (long)consumedMessages.getCount())), Format.formatWithComma((long)lastMsgAckIndex)});
                }
                ret = true;
            }
            if (!ret) {
                logger.warn("Concurrent cunsume ack failed, topic: {}, partition: {}, ack: [{} - {}), currentAckIndex: {}.", new Object[]{topic.getFullName(), partition, Format.formatWithComma((long)startIndex), Format.formatWithComma((long)(startIndex + (long)count)), Format.formatWithComma((long)positionManager.getLastMsgAckIndex(topic, app, partition))});
            }
            return ret;
        }
    }

    private static class ReadMessagesResult {
        private PullResult pullResult;
        private List<ByteBuffer> filteredMessages;

        private ReadMessagesResult() {
        }

        PullResult getPullResult() {
            return this.pullResult;
        }

        void setPullResult(PullResult pullResult) {
            this.pullResult = pullResult;
        }

        List<ByteBuffer> getFilteredMessages() {
            return this.filteredMessages;
        }

        void setFilteredMessages(List<ByteBuffer> filteredMessages) {
            this.filteredMessages = filteredMessages;
        }
    }
}

