/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer.converter;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.joyqueue.broker.consumer.converter.AbstractInternalMessageConverter;
import org.joyqueue.broker.consumer.converter.kafka.KafkaBufferUtils;
import org.joyqueue.broker.consumer.converter.kafka.KafkaCompressionCodec;
import org.joyqueue.broker.consumer.converter.kafka.KafkaCompressionCodecFactory;
import org.joyqueue.broker.consumer.converter.kafka.compressor.stream.ByteBufferInputStream;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaToInternalMessageConverter
extends AbstractInternalMessageConverter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final byte MESSAGE_MAGIC_V0 = 0;
    private static final byte MESSAGE_MAGIC_V1 = 1;
    private static final byte MESSAGE_MAGIC_V2 = 2;
    private static final byte MESSAGE_CURRENT_MAGIC = 2;
    private static final int EXTENSION_V0_LENGTH = 1;
    private static final int EXTENSION_V1_LENGTH = 17;
    private static final int EXTENSION_CURRENT_LENGTH = 17;
    private static final int EXTENSION_BATCH_V0_LENGTH = 1;
    private static final int EXTENSION_BATCH_V1_LENGTH = 17;
    private static final int EXTENSION_CURRENT_BATCH_LENGTH = 17;
    private static final int EXTENSION_MAGIC_OFFSET = 0;
    private static final int EXTENSION_TIMESTAMP_OFFSET = 1;
    private static final int EXTENSION_ATTRIBUTE_OFFSET = 9;
    private static final byte COMPRESSION_CODEC_MASK = 7;
    private static final int DECOMPRESS_BUFFER_SIZE = 1024;

    @Override
    public BrokerMessage convert(BrokerMessage message) {
        byte[] extension = message.getExtension();
        if (ArrayUtils.isEmpty((byte[])extension) || extension.length != 17) {
            return message;
        }
        byte messageMagic = extension[0];
        short attribute = (short)KafkaBufferUtils.readUnsignedLongLE(extension, 9);
        KafkaCompressionCodec compressionCodec = KafkaCompressionCodec.valueOf(attribute & 7);
        if (!compressionCodec.equals((Object)KafkaCompressionCodec.NoCompressionCodec)) {
            byte[] body = this.decompress(compressionCodec, message.getBody(), messageMagic);
            message = this.readDecompressedMessage(ByteBuffer.wrap(body), message, messageMagic);
        }
        return message;
    }

    protected BrokerMessage readDecompressedMessage(ByteBuffer buffer, BrokerMessage message, byte messageMagic) {
        buffer.getLong();
        buffer.getInt();
        buffer.getInt();
        buffer.get();
        buffer.get();
        if (messageMagic >= 1) {
            buffer.getLong();
        }
        byte[] key = KafkaBufferUtils.readBytes(buffer);
        byte[] value = KafkaBufferUtils.readBytes(buffer);
        message.setBusinessId(ArrayUtils.isNotEmpty((byte[])key) ? new String(key, Charsets.UTF_8) : null);
        message.setBody((byte[])(ArrayUtils.isNotEmpty((byte[])value) ? value : null));
        return message;
    }

    @Override
    public List<BrokerMessage> convertBatch(BrokerMessage message) {
        ArrayList result = Lists.newArrayListWithCapacity((int)message.getFlag());
        byte[] body = this.tryDecompress(message);
        ByteBuffer buffer = ByteBuffer.wrap(body);
        for (int i = 0; i < message.getFlag(); ++i) {
            result.add(this.doConvertBatch(message, buffer, i));
        }
        return result;
    }

    protected byte[] tryDecompress(BrokerMessage message) {
        byte[] extension = message.getExtension();
        if (ArrayUtils.isEmpty((byte[])extension) || extension.length != 17) {
            return message.getByteBody();
        }
        byte messageMagic = extension[0];
        short attribute = (short)KafkaBufferUtils.readUnsignedLongLE(extension, 9);
        int compressionType = attribute & 7;
        KafkaCompressionCodec kafkaCompressionCodec = KafkaCompressionCodec.valueOf(compressionType);
        if (kafkaCompressionCodec.equals((Object)KafkaCompressionCodec.NoCompressionCodec)) {
            return message.getByteBody();
        }
        return this.decompress(kafkaCompressionCodec, ByteBuffer.wrap(message.getByteBody()), messageMagic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] decompress(KafkaCompressionCodec kafkaCompressionCodec, ByteBuffer buffer, byte messageMagic) {
        try {
            byte[] intermediateBuffer = new byte[1024];
            ByteBufferInputStream sourceInputStream = new ByteBufferInputStream(buffer);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (InputStream inputStream = KafkaCompressionCodecFactory.apply(kafkaCompressionCodec, sourceInputStream, messageMagic);){
                int count;
                while ((count = inputStream.read(intermediateBuffer)) > 0) {
                    outputStream.write(intermediateBuffer, 0, count);
                }
            }
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            this.logger.error("decompress exception, kafkaCompressionCodec: {}, messageMagic: {}", new Object[]{kafkaCompressionCodec, messageMagic, e});
            throw new RuntimeException(e);
        }
    }

    protected BrokerMessage doConvertBatch(BrokerMessage message, ByteBuffer buffer, int index) {
        BrokerMessage result = new BrokerMessage();
        result.setSize(KafkaBufferUtils.readVarint(buffer));
        buffer.get();
        KafkaBufferUtils.readVarlong(buffer);
        KafkaBufferUtils.readVarint(buffer);
        result.setMsgIndexNo((long)index + message.getMsgIndexNo());
        byte[] businessId = KafkaBufferUtils.readVarBytes(buffer);
        result.setTopic(message.getTopic());
        result.setBusinessId(ArrayUtils.isEmpty((byte[])businessId) ? null : new String(businessId, Charsets.UTF_8));
        result.setBody(KafkaBufferUtils.readVarBytes(buffer));
        result.setApp(message.getApp());
        result.setPartition(message.getPartition());
        result.setAttributes(message.getAttributes());
        result.setStartTime(message.getStartTime());
        result.setFlag(message.getFlag());
        result.setSource(SourceType.KAFKA.getValue());
        result.setClientIp(message.getClientIp());
        result.setPriority(message.getPriority());
        result.setOrdered(message.isOrdered());
        result.setStartTime(message.getStartTime());
        result.setStoreTime(message.getStoreTime());
        result.setCompressed(false);
        result.setBatch(true);
        int headerCount = KafkaBufferUtils.readVarint(buffer);
        if (headerCount > 0) {
            HashMap headers = Maps.newHashMap();
            for (int i = 0; i < headerCount; ++i) {
                String key = new String(KafkaBufferUtils.readVarBytes(buffer), Charsets.UTF_8);
                String value = new String(KafkaBufferUtils.readVarBytes(buffer), Charsets.UTF_8);
                headers.put(key, value);
            }
            result.setAttributes((Map)headers);
        }
        return result;
    }

    public Byte type() {
        return SourceType.KAFKA.getValue();
    }
}

