/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer.converter.kafka;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ArrayUtils;
import org.joyqueue.toolkit.security.Crc32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBufferUtils {
    private static final Logger logger = LoggerFactory.getLogger(KafkaBufferUtils.class);

    public static void writeUnsignedInt(ByteBuffer buffer, int index, long value) {
        buffer.putInt(index, (int)(value & 0xFFFFFFFFL));
    }

    public static long readUnsignedInt(ByteBuffer buffer, int index) {
        return (long)buffer.getInt(index) & 0xFFFFFFFFL;
    }

    public static long crc32(byte[] bytes) {
        return KafkaBufferUtils.crc32(bytes, 0, bytes.length);
    }

    public static long crc32(byte[] bytes, int offset, int size) {
        Crc32 crc32 = new Crc32();
        crc32.update(bytes, offset, size);
        return crc32.getValue();
    }

    public static String readString(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, Charsets.UTF_8);
    }

    public static void writeUnsignedIntLE(byte[] buffer, int offset, int value) {
        buffer[offset++] = (byte)(value >>> 0);
        buffer[offset++] = (byte)(value >>> 8);
        buffer[offset++] = (byte)(value >>> 16);
        buffer[offset] = (byte)(value >>> 24);
    }

    public static void writeUnsignedIntLE(OutputStream out, int value) throws IOException {
        out.write(value >>> 0);
        out.write(value >>> 8);
        out.write(value >>> 16);
        out.write(value >>> 24);
    }

    public static int readUnsignedIntLE(InputStream in) throws IOException {
        return in.read() << 0 | in.read() << 8 | in.read() << 16 | in.read() << 24;
    }

    public static int readUnsignedIntLE(byte[] buffer, int offset) {
        return buffer[offset++] << 0 | buffer[offset++] << 8 | buffer[offset++] << 16 | buffer[offset] << 24;
    }

    public static void writeUnsignedLongLE(byte[] buffer, int offset, long value) {
        for (int i = 0; i < 8; ++i) {
            buffer[i + offset] = (byte)(value >>> 8 * i);
        }
    }

    public static long readUnsignedLongLE(byte[] buffer, int offset) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result |= ((long)buffer[i + offset] & 0xFFL) << 8 * i;
        }
        return result;
    }

    public static Thread newThread(String name, Runnable runnable, Boolean daemon) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error("Uncaught exception in thread '" + t.getName() + "':", e);
            }
        });
        return thread;
    }

    public static byte[] toArray(ByteBuffer buffer) {
        return KafkaBufferUtils.toArray(buffer, 0, buffer.limit());
    }

    public static byte[] toArray(ByteBuffer buffer, int offset, int size) {
        byte[] dest = new byte[size];
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.arrayOffset() + offset, dest, 0, size);
        } else {
            int pos = buffer.position();
            buffer.get(dest);
            buffer.position(pos);
        }
        return dest;
    }

    public static byte[] readBytes(ByteBuffer buffer) {
        int length = buffer.getInt();
        if (length <= 0) {
            return null;
        }
        byte[] result = new byte[length];
        buffer.get(result);
        return result;
    }

    public static byte[] readVarBytes(ByteBuffer buffer) {
        int length = KafkaBufferUtils.readVarint(buffer);
        if (length <= 0) {
            return null;
        }
        byte[] result = new byte[length];
        buffer.get(result);
        return result;
    }

    public static void writeVarlong(long value, ByteBuf buffer) {
        long v = value << 1 ^ value >> 63;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(v & 0x7FL | 0x80L);
            buffer.writeByte((int)b);
            v >>>= 7;
        }
        buffer.writeByte((int)((byte)v));
    }

    public static void writeVarlong(long value, ByteBuffer buffer) {
        long v = value << 1 ^ value >> 63;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(v & 0x7FL | 0x80L);
            buffer.put(b);
            v >>>= 7;
        }
        buffer.put((byte)v);
    }

    public static long readVarlong(ByteBuffer buffer) {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)buffer.get()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IllegalArgumentException();
        }
        return (value |= b << i) >>> 1 ^ -(value & 1L);
    }

    public static void writeVarint(int value, ByteBuf buffer) {
        int v = value << 1 ^ value >> 31;
        while ((long)(v & 0xFFFFFF80) != 0L) {
            byte b = (byte)(v & 0x7F | 0x80);
            buffer.writeByte((int)b);
            v >>>= 7;
        }
        buffer.writeByte((int)((byte)v));
    }

    public static void writeVarint(int value, ByteBuffer buffer) {
        int v = value << 1 ^ value >> 31;
        while ((long)(v & 0xFFFFFF80) != 0L) {
            byte b = (byte)(v & 0x7F | 0x80);
            buffer.put(b);
            v >>>= 7;
        }
        buffer.put((byte)v);
    }

    public static int readVarint(ByteBuffer buffer) {
        byte b;
        int value = 0;
        int i = 0;
        while (((b = buffer.get()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 28) continue;
            throw new IllegalArgumentException();
        }
        return (value |= b << i) >>> 1 ^ -(value & 1);
    }

    public static void writeBytes(byte[] value, ByteBuf buffer) {
        if (ArrayUtils.isEmpty((byte[])value)) {
            buffer.writeInt(-1);
        } else {
            buffer.writeInt(value.length);
            buffer.writeBytes(value);
        }
    }

    public static void writeVarBytes(byte[] value, ByteBuf buffer) {
        if (ArrayUtils.isEmpty((byte[])value)) {
            KafkaBufferUtils.writeVarint(-1, buffer);
        } else {
            KafkaBufferUtils.writeVarint(value.length, buffer);
            buffer.writeBytes(value);
        }
    }
}

