/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer.filter;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.broker.consumer.filter.FilterCallback;
import org.joyqueue.broker.consumer.filter.MessageFilter;
import org.joyqueue.exception.JoyQueueException;

public class FilterPipeline<T extends MessageFilter> {
    private final LinkedList<T> pipeline = new LinkedList();
    private volatile boolean hasFilter = false;
    private String id;

    public FilterPipeline(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void register(T t) {
        this.pipeline.addLast(t);
        this.hasFilter = true;
    }

    public List<ByteBuffer> execute(List<ByteBuffer> byteBuffers, FilterCallback filterCallback) throws JoyQueueException {
        if (this.hasFilter) {
            for (MessageFilter next : this.pipeline) {
                byteBuffers = next.filter(byteBuffers, filterCallback);
            }
        }
        return byteBuffers;
    }
}

