/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer.filter;

import com.jd.laf.extension.Extension;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.consumer.filter.FilterCallback;
import org.joyqueue.broker.consumer.filter.MessageFilter;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(value="flag", singleton=false)
public class FlagFilter
implements MessageFilter {
    private final Logger logger = LoggerFactory.getLogger(FlagFilter.class);
    private Pattern pattern;

    @Override
    public void setRule(String rule) {
        this.pattern = Pattern.compile(rule);
    }

    @Override
    public List<ByteBuffer> filter(List<ByteBuffer> byteBufferList, FilterCallback filterCallback) throws JoyQueueException {
        FilterResult filterResult = this.doFilter(byteBufferList, this.pattern);
        List<ByteBuffer> inValidList = filterResult.getInValidList();
        if (null != filterCallback) {
            filterCallback.callback(inValidList);
        }
        return filterResult.getValidList();
    }

    private FilterResult doFilter(List<ByteBuffer> messages, Pattern pattern) throws JoyQueueException {
        ArrayList<ByteBuffer> validList = new ArrayList<ByteBuffer>();
        ArrayList<ByteBuffer> inValidList = null;
        boolean valid2InvalidFlag = false;
        boolean invaild2ValidFlag = false;
        for (int i = 0; i < messages.size(); ++i) {
            short flag;
            ByteBuffer buffer = messages.get(i);
            Object message = null;
            try {
                flag = Serializer.readFlag(buffer);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new JoyQueueException(JoyQueueCode.SE_SERIALIZER_ERROR, (Throwable)e, new Object[0]);
            }
            boolean matcher = pattern.matcher("" + flag).matches();
            if (i == 0 && !matcher) {
                inValidList = new ArrayList<ByteBuffer>();
            }
            if (matcher && !valid2InvalidFlag) {
                validList.add(buffer);
                if (inValidList == null || inValidList.size() <= 0) continue;
                invaild2ValidFlag = true;
                continue;
            }
            if (inValidList == null || invaild2ValidFlag) continue;
            inValidList.add(buffer);
            if (validList.size() <= 0) continue;
            valid2InvalidFlag = true;
        }
        return new FilterResult(validList, inValidList);
    }

    static class FilterResult {
        List<ByteBuffer> validList;
        List<ByteBuffer> inValidList;

        FilterResult(List<ByteBuffer> validList, List<ByteBuffer> inValidList) {
            this.validList = validList;
            this.inValidList = inValidList;
        }

        public List<ByteBuffer> getValidList() {
            return this.validList;
        }

        public void setValidList(List<ByteBuffer> validList) {
            this.validList = validList;
        }

        public List<ByteBuffer> getInValidList() {
            return this.inValidList;
        }

        public void setInValidList(List<ByteBuffer> inValidList) {
            this.inValidList = inValidList;
        }
    }
}

