/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer.model;

import java.nio.ByteBuffer;
import java.util.List;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.session.Consumer;

public class PullResult {
    private String topic;
    private String app;
    private short partition;
    private List<ByteBuffer> buffers;
    private JoyQueueCode code = JoyQueueCode.SUCCESS;

    public PullResult(Consumer consumer, short partition, List<ByteBuffer> buffers) {
        this.topic = consumer.getTopic();
        this.app = consumer.getApp();
        this.partition = partition;
        this.buffers = buffers;
    }

    public PullResult(String topic, String app, short partition, List<ByteBuffer> buffers) {
        this.topic = topic;
        this.app = app;
        this.partition = partition;
        this.buffers = buffers;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getApp() {
        return this.app;
    }

    public short getPartition() {
        return this.partition;
    }

    public List<ByteBuffer> getBuffers() {
        return this.buffers;
    }

    public void setBuffers(List<ByteBuffer> buffers) {
        this.buffers = buffers;
    }

    public JoyQueueCode getCode() {
        return this.code;
    }

    public void setCode(JoyQueueCode joyQueueCode) {
        this.code = joyQueueCode;
    }

    public ByteBuffer[] toArrays() {
        if (this.buffers == null) {
            return null;
        }
        return this.buffers.toArray(new ByteBuffer[0]);
    }

    public int count() {
        if (this.buffers == null) {
            return 0;
        }
        return this.buffers.size();
    }

    public int size() {
        int len = 0;
        if (this.buffers != null) {
            for (ByteBuffer buffer : this.buffers) {
                len += buffer.remaining();
            }
        }
        return len;
    }

    public boolean isEmpty() {
        return this.buffers == null || this.buffers.isEmpty();
    }
}

