/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer.position;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.consumer.model.ConsumePartition;
import org.joyqueue.broker.consumer.position.PositionConfig;
import org.joyqueue.broker.consumer.position.PositionStore;
import org.joyqueue.broker.consumer.position.model.ConsumeBill;
import org.joyqueue.broker.consumer.position.model.Position;
import org.joyqueue.network.session.Joint;
import org.joyqueue.toolkit.concurrent.LoopThread;
import org.joyqueue.toolkit.io.Files;
import org.joyqueue.toolkit.lang.Close;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileStore
implements PositionStore<ConsumePartition, Position> {
    private Logger logger = LoggerFactory.getLogger(LocalFileStore.class);
    private final Object[] fileUpdateLock = new Object[0];
    PositionConfig config;
    private File indexFile;
    private File indexFileBack;
    private String basePath;
    private ConcurrentMap<ConsumePartition, Position> consumePositionCache = new ConcurrentHashMap<ConsumePartition, Position>();
    private LoopThread thread;
    private AtomicBoolean isStarted = new AtomicBoolean(false);

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void start() throws Exception {
        if (this.isStarted.get()) {
            this.logger.info("LocalFileStore is started, can not be restart.");
            return;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.basePath), (Object)"basePath can not be null!");
        this.config = new PositionConfig(this.basePath);
        this.indexFile = this.config.getPositionFile();
        this.indexFileBack = new File(this.indexFile.getParentFile(), this.indexFile.getName() + PositionConfig.BACK_SUFFIX);
        Files.createFile((File)this.indexFile);
        Files.createFile((File)this.indexFileBack);
        this.initConsumePositionCache();
        this.thread = LoopThread.builder().sleepTime(30000L, 30000L).name("Consume-Position-Store-Thread").onException(e -> this.logger.error(e.getMessage(), e)).doWork(this::doFlush).build();
        this.thread.start();
        this.isStarted.set(true);
        this.logger.info("LocalFileStore is started.");
    }

    private void initConsumePositionCache() throws Exception {
        ConcurrentMap<ConsumePartition, Position> recoverCache = this.recover();
        this.consumePositionCache = recoverCache;
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
        }
        this.isStarted.set(false);
        this.logger.info("LocalFileStore is stop.");
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    @Override
    public Position get(ConsumePartition key) {
        return (Position)this.consumePositionCache.get(key);
    }

    @Override
    public void put(ConsumePartition key, Position value) {
        this.consumePositionCache.put(key, value);
    }

    @Override
    public Position remove(ConsumePartition key) {
        return (Position)this.consumePositionCache.remove(key);
    }

    @Override
    public Position putIfAbsent(ConsumePartition key, Position value) {
        return this.consumePositionCache.putIfAbsent(key, value);
    }

    @Override
    public void forceFlush() {
        this.doFlush();
    }

    @Override
    public Iterator<ConsumePartition> iterator() {
        return this.consumePositionCache.keySet().iterator();
    }

    protected void doFlush() {
        Map<Joint, List<ConsumeBill>> jointListMap = this.cloneIndexCache(this.consumePositionCache);
        this.dump(jointListMap);
    }

    private Map<Joint, List<ConsumeBill>> cloneIndexCache(ConcurrentMap<ConsumePartition, Position> consumePositionCache) {
        HashMap<Joint, List<ConsumeBill>> copyOfConsumeBills = new HashMap<Joint, List<ConsumeBill>>(consumePositionCache.size());
        for (Map.Entry entry : consumePositionCache.entrySet()) {
            ConsumePartition consumePartition = (ConsumePartition)entry.getKey();
            String topic = consumePartition.getTopic();
            String app = consumePartition.getApp();
            short partition = consumePartition.getPartition();
            int partitionGroup = consumePartition.getPartitionGroup();
            Position position = (Position)entry.getValue();
            Joint joint = new Joint(topic, app);
            ArrayList<ConsumeBill> consumeBills = (ArrayList<ConsumeBill>)copyOfConsumeBills.get(joint);
            if (consumeBills == null) {
                consumeBills = new ArrayList<ConsumeBill>();
                copyOfConsumeBills.put(joint, consumeBills);
            }
            ConsumeBill consumeBill = new ConsumeBill(partitionGroup, partition, position);
            consumeBills.add(consumeBill);
        }
        return copyOfConsumeBills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(Map<Joint, List<ConsumeBill>> jointListMap) {
        try {
            String jsonStr = JSON.toJSONString(jointListMap);
            Object[] objectArray = this.fileUpdateLock;
            synchronized (this.fileUpdateLock) {
                this.writeFile(this.indexFile, jsonStr);
                this.writeFile(this.indexFileBack, jsonStr);
                // ** MonitorExit[var3_4] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            this.logger.error("flush index error.", (Throwable)e);
        }
        {
            return;
        }
    }

    public ConcurrentMap<ConsumePartition, Position> recover() throws IOException {
        Map<Joint, List<ConsumeBill>> consumeBills;
        ConcurrentHashMap<ConsumePartition, Position> consumePositionCache = new ConcurrentHashMap<ConsumePartition, Position>();
        try {
            consumeBills = this.loadFromFile(this.indexFile, new TypeReference<Map<Joint, List<ConsumeBill>>>(){});
        }
        catch (Exception e) {
            consumeBills = this.loadFromFile(this.indexFileBack, new TypeReference<Map<Joint, List<ConsumeBill>>>(){});
        }
        if (consumeBills != null) {
            consumeBills.entrySet().stream().forEach(entry -> {
                Joint key = (Joint)entry.getKey();
                ((List)entry.getValue()).stream().forEach(val -> consumePositionCache.putIfAbsent(new ConsumePartition(key.getTopic(), key.getApp(), val.getPartition()), new Position(val.getAckStartIndex(), val.getAckCurIndex(), val.getPullStartIndex(), val.getPullCurIndex())));
            });
        }
        return consumePositionCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, String content) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(content);
            writer.flush();
        }
        finally {
            Close.close((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T loadFromFile(File file, TypeReference<T> typeReference) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
        try {
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append('\n');
            }
            if (builder.length() > 0) {
                Object object = JSON.parseObject((String)builder.toString(), typeReference, (Feature[])new Feature[0]);
                return (T)object;
            }
            T t = null;
            return t;
        }
        finally {
            Close.close((Closeable)reader);
        }
    }
}

