/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer.position;

import java.io.File;

public class PositionConfig {
    public static String BACK_SUFFIX = ".1";
    private File positionFile;

    public PositionConfig(File dataDirectory) {
        if (dataDirectory == null) {
            throw new IllegalArgumentException("dataDirectory can not be null");
        }
        if (dataDirectory.exists()) {
            if (!dataDirectory.isDirectory()) {
                throw new IllegalArgumentException(String.format("%s is not a directory", dataDirectory.getPath()));
            }
        } else if (!dataDirectory.mkdirs() && !dataDirectory.exists()) {
            throw new IllegalArgumentException(String.format("create directory %s error.", dataDirectory.getPath()));
        }
        if (!dataDirectory.canWrite()) {
            throw new IllegalArgumentException(String.format("%s can not be written", dataDirectory.getPath()));
        }
        if (!dataDirectory.canRead()) {
            throw new IllegalArgumentException(String.format("%s can not be read", dataDirectory.getPath()));
        }
        this.positionFile = new File(dataDirectory, "index");
    }

    public PositionConfig(String file) {
        this(new File(file));
    }

    public File getPositionFile() {
        return this.positionFile;
    }
}

