/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.consumer.position;

import com.google.common.base.Preconditions;
import com.jd.laf.extension.ExtensionManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.ConsumeConfig;
import org.joyqueue.broker.consumer.model.ConsumePartition;
import org.joyqueue.broker.consumer.position.LocalFileStore;
import org.joyqueue.broker.consumer.position.PositionStore;
import org.joyqueue.broker.consumer.position.model.Position;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.EventType;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.nsr.event.AddConsumerEvent;
import org.joyqueue.nsr.event.AddPartitionGroupEvent;
import org.joyqueue.nsr.event.RemoveConsumerEvent;
import org.joyqueue.nsr.event.RemovePartitionGroupEvent;
import org.joyqueue.nsr.event.UpdatePartitionGroupEvent;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.concurrent.LoopThread;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionManager
extends Service {
    private static Logger logger = LoggerFactory.getLogger(PositionManager.class);
    private StoreService storeService;
    private ClusterManager clusterManager;
    private ConsumeConfig config;
    private PositionStore<ConsumePartition, Position> positionStore;
    private LoopThread thread;
    private Map<ConsumePartition, AtomicLong> lastAckTimeTrace = new ConcurrentHashMap<ConsumePartition, AtomicLong>();
    private ExecutorService flushIndexThread;
    private AtomicLong lastFlushIndexTimestamp = new AtomicLong();

    public PositionManager(ClusterManager clusterManager, StoreService storeService, ConsumeConfig consumeConfig) {
        this.clusterManager = clusterManager;
        this.storeService = storeService;
        this.config = consumeConfig;
        Preconditions.checkArgument((this.config != null ? 1 : 0) != 0, (Object)"config can not be null");
    }

    protected void validate() throws Exception {
        super.validate();
        Preconditions.checkArgument((this.clusterManager != null ? 1 : 0) != 0, (Object)"cluster manager can not be null");
        if (this.positionStore == null) {
            this.positionStore = (PositionStore)ExtensionManager.getOrLoadExtension(PositionStore.class);
            if (this.positionStore instanceof LocalFileStore) {
                ((LocalFileStore)this.positionStore).setBasePath(this.config.getConsumePositionPath());
            }
        }
        this.flushIndexThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10), (ThreadFactory)new NamedThreadFactory("joyqueue-consume-flush-index-threads", true));
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.positionStore.start();
        this.thread = LoopThread.builder().sleepTime(600000L, 600000L).name("Check-Subscribe-Thread").onException(e -> logger.error(e.getMessage(), e)).doWork(this::compensationPosition).build();
        this.thread.start();
        this.clusterManager.addListener(new AddConsumeListener());
        this.clusterManager.addListener(new RemoveConsumeListener());
        this.clusterManager.addListener(new AddPartitionGroupListener());
        this.clusterManager.addListener(new RemovePartitionGroupListener());
        this.clusterManager.addListener(new UpdatePartitionGroupListener());
        logger.info("PositionManager is started.");
    }

    private void compensationPosition() {
        Iterator<ConsumePartition> iterator = this.positionStore.iterator();
        while (iterator.hasNext()) {
            ConsumePartition next = iterator.next();
            Consumer.ConsumerPolicy consumerPolicy = this.clusterManager.tryGetConsumerPolicy(TopicName.parse((String)next.getTopic()), next.getApp());
            if (consumerPolicy != null) continue;
            iterator.remove();
            logger.info("Remove consume position by ConsumePosition:[{}]", (Object)next.toString());
        }
    }

    protected void doStop() {
        super.doStop();
        this.flushIndexThread.shutdownNow();
        this.positionStore.forceFlush();
        this.positionStore.stop();
        logger.info("PositionManager is stopped.");
    }

    public Map<ConsumePartition, AtomicLong> getLastAckTimeTrace() {
        return this.lastAckTimeTrace;
    }

    public Map<ConsumePartition, Position> getConsumePosition(TopicName topic, String app, int partitionGroup) {
        List<String> appList = app == null ? this.clusterManager.getLocalSubscribeAppByTopic(topic) : Arrays.asList(app);
        HashMap<ConsumePartition, Position> consumeInfo = new HashMap<ConsumePartition, Position>();
        if (appList != null && !appList.isEmpty()) {
            List<PartitionGroup> partitionGroupList = this.clusterManager.getLocalPartitionGroups(topic);
            for (PartitionGroup group : partitionGroupList) {
                if (group.getGroup() != partitionGroup) continue;
                Set partitions = group.getPartitions();
                partitions.stream().forEach(partition -> appList.stream().forEach(element -> {
                    ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), (String)element, (short)partition);
                    consumePartition.setPartitionGroup(partitionGroup);
                    Position position = this.positionStore.get(consumePartition);
                    consumeInfo.put(consumePartition, position);
                }));
                break;
            }
        }
        return consumeInfo;
    }

    public Map<ConsumePartition, Position> getConsumePosition(TopicName topic, int partitionGroup) {
        return this.getConsumePosition(topic, null, partitionGroup);
    }

    public boolean setConsumePosition(Map<ConsumePartition, Position> consumePositions) {
        try {
            if (consumePositions == null) {
                return false;
            }
            Set<Map.Entry<ConsumePartition, Position>> entries = consumePositions.entrySet();
            entries.stream().forEach(entry -> {
                ConsumePartition key = (ConsumePartition)entry.getKey();
                Position val = (Position)entry.getValue();
                this.positionStore.put(key, val);
            });
            this.tryForceFlush();
        }
        catch (Exception ex) {
            logger.error("set consume position error.", (Throwable)ex);
            return false;
        }
        return true;
    }

    public long getLastMsgAckIndex(TopicName topic, String app, short partition) throws JoyQueueException {
        ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), app, partition);
        Position position = this.positionStore.get(consumePartition);
        if (position == null) {
            throw new JoyQueueException(JoyQueueCode.CONSUME_POSITION_NULL, new Object[]{"topic=" + topic + ",app=" + app + ",partition=" + partition});
        }
        return position.getAckCurIndex();
    }

    public boolean updateLastMsgAckIndex(TopicName topic, String app, short partition, long index) throws JoyQueueException {
        return this.updateLastMsgAckIndex(topic, app, partition, index, true);
    }

    public boolean updateLastMsgAckIndex(TopicName topic, String app, short partition, long index, boolean isUpdatePullIndex) throws JoyQueueException {
        logger.debug("Update last ack index, topic:{}, app:{}, partition:{}, index:{}", new Object[]{topic, app, partition, index});
        this.checkIndex(topic, partition, index);
        this.markLastAckTime(topic, app, partition);
        ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), app, partition);
        Position position = this.positionStore.get(consumePartition);
        if (position != null) {
            position.setAckCurIndex(index);
            if (isUpdatePullIndex) {
                position.setPullCurIndex(-1L);
            }
        } else {
            logger.error("Position is null, topic:{}, app:{}, partition:{}, index:{}", new Object[]{topic, app, partition, index});
            this.addAndUpdatePosition(topic, app, partition, index);
        }
        return true;
    }

    private void checkIndex(TopicName topic, short partition, long index) throws JoyQueueException {
        Integer partitionGroupId = this.clusterManager.getPartitionGroupId(topic, partition);
        if (partitionGroupId == null) {
            throw new JoyQueueException(JoyQueueCode.CONSUME_POSITION_META_DATA_NULL, new Object[]{String.format("topic:[%s], partition:[%s], index:[%s]", topic, partition, index)});
        }
        PartitionGroupStore store = this.storeService.getStore(topic.getFullName(), partitionGroupId.intValue());
        long leftIndex = store.getLeftIndex(partition);
        if (index < leftIndex && index != -1L) {
            throw new JoyQueueException(JoyQueueCode.SE_INDEX_UNDERFLOW, new Object[]{"index less than leftIndex error."});
        }
        long rightIndex = store.getRightIndex(partition);
        if (index > rightIndex) {
            throw new JoyQueueException(JoyQueueCode.SE_INDEX_UNDERFLOW, new Object[]{"index more than rightIndex error."});
        }
    }

    private void markLastAckTime(TopicName topic, String app, short partition) {
        ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), app, partition);
        AtomicLong lastAckTime = this.lastAckTimeTrace.get(consumePartition);
        if (lastAckTime == null) {
            lastAckTime = new AtomicLong(SystemClock.now());
            this.lastAckTimeTrace.put(consumePartition, lastAckTime);
        } else {
            lastAckTime.set(SystemClock.now());
        }
    }

    private void addAndUpdatePosition(TopicName topic, String app, short partition, long index) throws JoyQueueException {
        logger.info("Try to init a position by topic:{}, app:{}, partition:{}, curIndex:{}", new Object[]{topic.getFullName(), app, partition, index});
        if (topic == null || app == null || app.isEmpty()) {
            return;
        }
        this.checkState();
        PartitionGroup partitionGroup = this.clusterManager.getPartitionGroup(topic, partition);
        if (partitionGroup == null) {
            logger.error("Fail to add and update partition consume position by topic:[{}], app:[{}], partition:[{}], index:[{}]", new Object[]{topic.getFullName(), app, partition, index});
            throw new JoyQueueException(JoyQueueCode.FW_PARTITION_BROKER_NOT_LEADER, new Object[]{""});
        }
        ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), app, partition);
        consumePartition.setPartitionGroup(partitionGroup.getGroup());
        long currentIndex = Math.max(index, 0L);
        Position position = new Position(currentIndex, currentIndex, currentIndex, currentIndex);
        this.positionStore.putIfAbsent(consumePartition, position);
        logger.info("Success to add and update partition consume position by topic:{}, app:{}, partition:{}, curIndex:{}", new Object[]{topic.getFullName(), app, partition, currentIndex});
        this.positionStore.forceFlush();
    }

    public boolean updateStartMsgAckIndex(TopicName topic, String app, short partition, long index) throws JoyQueueException {
        logger.debug("Update stater ack index, topic:{}, app:{}, partition:{}, index:{}", new Object[]{topic, app, partition, index});
        ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), app, partition);
        Position position = this.positionStore.get(consumePartition);
        if (position != null) {
            position.setAckStartIndex(index);
        } else {
            logger.error("Position is null, topic:{}, app:{}, partition:{}, index:{}", new Object[]{topic, app, partition, index});
            this.addAndUpdatePosition(topic, app, partition, index);
        }
        return true;
    }

    public long getLastMsgPullIndex(TopicName topic, String app, short partition) throws JoyQueueException {
        ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), app, partition);
        Position position = this.positionStore.get(consumePartition);
        if (position == null) {
            throw new JoyQueueException(JoyQueueCode.CONSUME_POSITION_NULL, new Object[]{"topic=" + topic + ",app=" + app + ",partition=" + partition});
        }
        return position.getPullCurIndex();
    }

    public boolean updateLastMsgPullIndex(TopicName topic, String app, short partition, long index) throws JoyQueueException {
        logger.debug("Update last pull index, topic:{}, app:{}, partition:{}, index:{}", new Object[]{topic, app, partition, index});
        ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), app, partition);
        Position position = this.positionStore.get(consumePartition);
        if (position != null) {
            position.setPullCurIndex(index);
        } else {
            logger.error("Position is null, topic:{}, app:{}, partition:{}, index:{}", new Object[]{topic, app, partition, index});
            this.addAndUpdatePosition(topic, app, partition, index);
        }
        return true;
    }

    private long getMaxMsgIndex(TopicName topic, short partition, int groupId) {
        try {
            PartitionGroupStore store = this.storeService.getStore(topic.getFullName(), groupId);
            long rightIndex = store.getRightIndex(partition);
            return rightIndex;
        }
        catch (Exception e) {
            logger.error("getMaxMsgIndex exception, topic: {}, partition: {}, groupId: {}", new Object[]{topic, partition, groupId});
            return 0L;
        }
    }

    protected void checkState() {
        if (!this.isStarted()) {
            throw new IllegalStateException("offset manager was stopped");
        }
    }

    public void addConsumer(TopicName topic, String app) {
        if (topic == null || app == null || app.isEmpty()) {
            return;
        }
        this.checkState();
        List<Short> partitionList = this.clusterManager.getReplicaPartitions(topic);
        logger.debug("add consumer partitionList:[{}]", (Object)partitionList.toString());
        partitionList.stream().forEach(partition -> {
            ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), app, (short)partition);
            Integer partitionGroupId = this.clusterManager.getPartitionGroupId(topic, (short)partition);
            consumePartition.setPartitionGroup(partitionGroupId);
            long currentIndex = this.getMaxMsgIndex(topic, (short)partition, partitionGroupId);
            currentIndex = Math.max(currentIndex, 0L);
            Position position = new Position(currentIndex, currentIndex, currentIndex, currentIndex);
            this.positionStore.putIfAbsent(consumePartition, position);
            logger.debug("Add ConsumePartition by topic:{}, app:{}, partition:{}, curIndex:{}", new Object[]{topic.getFullName(), app, partition, currentIndex});
        });
        this.positionStore.forceFlush();
    }

    public void removeConsumer(TopicName topic, String app) {
        if (topic == null || app == null || app.isEmpty()) {
            return;
        }
        this.checkState();
        List<Short> partitionList = this.clusterManager.getPartitionList(topic);
        logger.debug("remove consumer partitionList:[{}]", (Object)partitionList.toString());
        partitionList.stream().forEach(partition -> {
            ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), app, (short)partition);
            Position remove = this.positionStore.remove(consumePartition);
            logger.info("Remove ConsumePartition by topic:{}, app:{}, partition:{}, curIndex:{}", new Object[]{consumePartition.getTopic(), consumePartition.getApp(), consumePartition.getPartition(), String.valueOf(remove)});
        });
        this.positionStore.forceFlush();
    }

    public Position getPosition(TopicName topic, String app, short partition) {
        ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), app, partition);
        return this.positionStore.get(consumePartition);
    }

    private void addPartitionGroup(TopicName topic, PartitionGroup partitionGroup) {
        List<String> appList = this.clusterManager.getAppByTopic(topic);
        Set partitions = partitionGroup.getPartitions();
        logger.debug("add partitionGroup appList:[{}], partitions:[{}]", (Object)appList.toString(), (Object)partitions.toString());
        AtomicBoolean changed = new AtomicBoolean(false);
        partitions.stream().forEach(partition -> {
            long currentIndex = this.getMaxMsgIndex(topic, (short)partition, partitionGroup.getGroup());
            long currentIndexVal = Math.max(currentIndex, 0L);
            appList.stream().forEach(app -> {
                ConsumePartition consumePartition = new ConsumePartition(topic.getFullName(), (String)app, (short)partition);
                consumePartition.setPartitionGroup(partitionGroup.getGroup());
                Position position = new Position(currentIndex, currentIndex, currentIndex, currentIndex);
                Position previous = this.positionStore.putIfAbsent(consumePartition, position);
                if (previous != null) {
                    long ackCurIndex = previous.getAckCurIndex();
                    if (ackCurIndex > currentIndex) {
                        previous.setAckCurIndex(currentIndex);
                        changed.set(true);
                        logger.warn("Update consume position topic:{}, app:{}, partition:{}, curIndex:{}, ackIndex:{}", new Object[]{topic.getFullName(), app, partition, currentIndexVal, ackCurIndex});
                    }
                } else {
                    changed.set(true);
                    logger.info("Add consume partition topic:{}, app:{}, partition:{}, curIndex:{}", new Object[]{topic.getFullName(), app, partition, currentIndexVal});
                }
            });
        });
        if (changed.get()) {
            this.positionStore.forceFlush();
        }
    }

    private synchronized void removePartitionGroup(TopicName topic, PartitionGroup partitionGroup) {
        logger.info("remove partitionGroup topic:[{}], partitionGroup:[{}]", (Object)topic.getFullName(), (Object)partitionGroup);
        Iterator<ConsumePartition> iterator = this.positionStore.iterator();
        while (iterator.hasNext()) {
            ConsumePartition consumePartition = iterator.next();
            if (consumePartition == null || consumePartition.getPartitionGroup() != partitionGroup.getGroup() || !StringUtils.equals((CharSequence)consumePartition.getTopic(), (CharSequence)topic.getFullName())) continue;
            iterator.remove();
            logger.info("Remove ConsumePartition by topic:{}, app:{}, partition:{}", new Object[]{consumePartition.getTopic(), consumePartition.getApp(), consumePartition.getPartition()});
        }
        this.positionStore.forceFlush();
    }

    protected void tryForceFlush() {
        long lastFlushTimestamp;
        if (this.config.getIndexFlushInterval() <= 0) {
            this.positionStore.forceFlush();
            return;
        }
        long now = SystemClock.now();
        if (now - (lastFlushTimestamp = this.lastFlushIndexTimestamp.get()) < (long)this.config.getIndexFlushInterval()) {
            return;
        }
        if (!this.lastFlushIndexTimestamp.compareAndSet(lastFlushTimestamp, now)) {
            return;
        }
        this.flushIndexThread.execute(() -> this.positionStore.forceFlush());
    }

    class UpdatePartitionGroupListener
    implements EventListener<MetaEvent> {
        UpdatePartitionGroupListener() {
        }

        public void onEvent(MetaEvent event) {
            try {
                if (event.getEventType() == EventType.UPDATE_PARTITION_GROUP) {
                    UpdatePartitionGroupEvent updatePartitionGroupEvent = (UpdatePartitionGroupEvent)event;
                    logger.info("listen update partition group event:[{}]", (Object)updatePartitionGroupEvent.toString());
                    TopicName topic = updatePartitionGroupEvent.getTopic();
                    PartitionGroup newPartitionGroup = updatePartitionGroupEvent.getNewPartitionGroup();
                    Set newPartitionSet = PositionManager.this.clusterManager.getTopicConfig(topic).fetchAllPartitions();
                    Iterator iterator = PositionManager.this.positionStore.iterator();
                    while (iterator.hasNext()) {
                        ConsumePartition next = (ConsumePartition)iterator.next();
                        if (!StringUtils.equals((CharSequence)next.getTopic(), (CharSequence)topic.getFullName()) || newPartitionSet.contains(next.getPartition())) continue;
                        iterator.remove();
                    }
                    PositionManager.this.addPartitionGroup(topic, newPartitionGroup);
                }
            }
            catch (Exception ex) {
                logger.error("UpdatePartitionGroupListener error.", (Throwable)ex);
            }
        }
    }

    class RemovePartitionGroupListener
    implements EventListener<MetaEvent> {
        RemovePartitionGroupListener() {
        }

        public void onEvent(MetaEvent event) {
            try {
                if (event.getEventType() == EventType.REMOVE_PARTITION_GROUP) {
                    RemovePartitionGroupEvent removePartitionGroupEvent = (RemovePartitionGroupEvent)event;
                    logger.info("listen remove partition group event:[{}]", (Object)removePartitionGroupEvent.toString());
                    PositionManager.this.removePartitionGroup(removePartitionGroupEvent.getTopic(), removePartitionGroupEvent.getPartitionGroup());
                }
            }
            catch (Exception ex) {
                logger.error("RemovePartitionGroupListener error.", (Throwable)ex);
            }
        }
    }

    class AddPartitionGroupListener
    implements EventListener<MetaEvent> {
        AddPartitionGroupListener() {
        }

        public void onEvent(MetaEvent event) {
            try {
                if (event.getEventType() == EventType.ADD_PARTITION_GROUP) {
                    AddPartitionGroupEvent addPartitionGroupEvent = (AddPartitionGroupEvent)event;
                    logger.info("listen add partition group event:[{}]", (Object)addPartitionGroupEvent.toString());
                    PositionManager.this.addPartitionGroup(addPartitionGroupEvent.getTopic(), addPartitionGroupEvent.getPartitionGroup());
                }
            }
            catch (Exception ex) {
                logger.error("AddPartitionGroupListener error.", (Throwable)ex);
            }
        }
    }

    class RemoveConsumeListener
    implements EventListener<MetaEvent> {
        RemoveConsumeListener() {
        }

        public void onEvent(MetaEvent event) {
            try {
                if (event.getEventType() == EventType.REMOVE_CONSUMER) {
                    RemoveConsumerEvent removeConsumerEvent = (RemoveConsumerEvent)event;
                    logger.info("listen remove consume event:[{}]", (Object)removeConsumerEvent.toString());
                    PositionManager.this.removeConsumer(removeConsumerEvent.getTopic(), removeConsumerEvent.getConsumer().getApp());
                }
            }
            catch (Exception ex) {
                logger.error("RemoveConsumeListener error.", (Throwable)ex);
            }
        }
    }

    class AddConsumeListener
    implements EventListener<MetaEvent> {
        AddConsumeListener() {
        }

        public void onEvent(MetaEvent event) {
            try {
                if (event.getEventType() == EventType.ADD_CONSUMER) {
                    AddConsumerEvent addConsumerEvent = (AddConsumerEvent)event;
                    logger.info("listen add consume event:[{}]", (Object)addConsumerEvent.toString());
                    PositionManager.this.addConsumer(addConsumerEvent.getTopic(), addConsumerEvent.getConsumer().getApp());
                }
            }
            catch (Exception ex) {
                logger.error("AddConsumeListener error.", (Throwable)ex);
            }
        }
    }
}

