/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.coordinator;

import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.coordinator.config.CoordinatorConfig;
import org.joyqueue.broker.coordinator.domain.CoordinatorDetail;
import org.joyqueue.broker.coordinator.support.CoordinatorInitializer;
import org.joyqueue.broker.coordinator.support.CoordinatorResolver;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.network.transport.session.session.TransportSessionManager;

public class Coordinator {
    private CoordinatorConfig config;
    private ClusterManager clusterManager;
    private CoordinatorResolver coordinatorResolver;
    private CoordinatorInitializer coordinatorInitializer;
    private TransportSessionManager coordinatorSessionManager;

    public Coordinator(CoordinatorConfig config, ClusterManager clusterManager, CoordinatorResolver coordinatorResolver, CoordinatorInitializer coordinatorInitializer, TransportSessionManager coordinatorSessionManager) {
        this.config = config;
        this.clusterManager = clusterManager;
        this.coordinatorResolver = coordinatorResolver;
        this.coordinatorInitializer = coordinatorInitializer;
        this.coordinatorSessionManager = coordinatorSessionManager;
    }

    public boolean isCurrentGroup(String group) {
        Broker coordinatorBroker = this.findGroup(group);
        return this.clusterManager.getBroker().equals((Object)coordinatorBroker);
    }

    public Broker findGroup(String group) {
        return this.coordinatorResolver.findCoordinator(group, this.config.getGroupTopic());
    }

    public CoordinatorDetail getGroupDetail(String group) {
        return this.coordinatorResolver.getCoordinatorDetail(group, this.config.getGroupTopic());
    }

    public boolean isGroupTopic(TopicName topic) {
        return this.config.getGroupTopic().getFullName().equals(topic.getFullName());
    }

    public boolean isCurrentTransaction(String key) {
        Broker coordinatorBroker = this.findTransaction(key);
        return this.clusterManager.getBroker().equals((Object)coordinatorBroker);
    }

    public Broker findTransaction(String key) {
        return this.coordinatorResolver.findCoordinator(key, this.config.getTransactionTopic());
    }

    public CoordinatorDetail getTransactionDetail(String key) {
        return this.coordinatorResolver.getCoordinatorDetail(key, this.config.getTransactionTopic());
    }

    public boolean isTransactionTopic(TopicName topic) {
        return this.config.getTransactionTopic().getFullName().equals(topic.getFullName());
    }

    public TopicName getTransactionTopic() {
        return this.config.getTransactionTopic();
    }

    public TopicConfig getTransactionTopicConfig() {
        return this.clusterManager.getNameService().getTopicConfig(this.config.getTransactionTopic());
    }

    public PartitionGroup getTransactionPartitionGroup(String key) {
        return this.coordinatorResolver.resolveCoordinatorPartitionGroup(key, this.config.getTransactionTopic());
    }

    public boolean initCoordinator() {
        return this.coordinatorInitializer.init();
    }

    public TransportSessionManager getSessionManager() {
        return this.coordinatorSessionManager;
    }
}

