/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.coordinator;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.coordinator.Coordinator;
import org.joyqueue.broker.coordinator.config.CoordinatorConfig;
import org.joyqueue.broker.coordinator.group.GroupMetadataManager;
import org.joyqueue.broker.coordinator.support.CoordinatorInitializer;
import org.joyqueue.broker.coordinator.support.CoordinatorResolver;
import org.joyqueue.broker.coordinator.transaction.TransactionMetadataManager;
import org.joyqueue.broker.network.support.BrokerTransportClientFactory;
import org.joyqueue.network.transport.TransportClientFactory;
import org.joyqueue.network.transport.config.TransportConfigSupport;
import org.joyqueue.network.transport.session.session.TransportSessionManager;
import org.joyqueue.network.transport.session.session.config.TransportSessionConfig;
import org.joyqueue.nsr.NameService;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.service.Service;

public class CoordinatorService
extends Service {
    private CoordinatorConfig config;
    private ClusterManager clusterManager;
    private NameService nameService;
    private CoordinatorInitializer coordinatorInitializer;
    private CoordinatorResolver coordinatorResolver;
    private TransportSessionManager coordinatorSessionManager;
    private Coordinator coordinator;
    private final ConcurrentMap<String, GroupMetadataManager> groupMetadataManagerMap = Maps.newConcurrentMap();
    private final ConcurrentMap<String, TransactionMetadataManager> transactionMetadataManagerMap = Maps.newConcurrentMap();

    public CoordinatorService(PropertySupplier propertySupplier, ClusterManager clusterManager, NameService nameService) {
        this.config = new CoordinatorConfig(propertySupplier);
        this.clusterManager = clusterManager;
        this.nameService = nameService;
        this.coordinatorInitializer = new CoordinatorInitializer(this.config, clusterManager, nameService);
        this.coordinatorResolver = new CoordinatorResolver(this.config, clusterManager);
        this.coordinatorSessionManager = new TransportSessionManager(new TransportSessionConfig(propertySupplier), TransportConfigSupport.buildClientConfig((PropertySupplier)propertySupplier, (String)"coordinator."), (TransportClientFactory)new BrokerTransportClientFactory());
        this.coordinator = new Coordinator(this.config, clusterManager, this.coordinatorResolver, this.coordinatorInitializer, this.coordinatorSessionManager);
    }

    protected void doStart() throws Exception {
        this.coordinatorInitializer.init();
        this.coordinatorSessionManager.start();
    }

    protected void doStop() {
        if (this.coordinatorSessionManager != null) {
            this.coordinatorSessionManager.stop();
        }
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public GroupMetadataManager getOrCreateGroupMetadataManager(String namespace) {
        GroupMetadataManager oldGroupMetadataManager;
        GroupMetadataManager groupMetadataManager = (GroupMetadataManager)this.groupMetadataManagerMap.get(namespace);
        if (groupMetadataManager == null && (oldGroupMetadataManager = this.groupMetadataManagerMap.putIfAbsent(namespace, groupMetadataManager = this.doCreateGroupMetadataManager(namespace))) != null) {
            groupMetadataManager = oldGroupMetadataManager;
        }
        return groupMetadataManager;
    }

    public TransactionMetadataManager getOrCreateTransactionMetadataManager(String namespace) {
        TransactionMetadataManager oldTransactionMetadataManager;
        TransactionMetadataManager transactionMetadataManager = (TransactionMetadataManager)this.transactionMetadataManagerMap.get(namespace);
        if (transactionMetadataManager == null && (oldTransactionMetadataManager = this.transactionMetadataManagerMap.putIfAbsent(namespace, transactionMetadataManager = this.doCreateTransactionMetadataManager(namespace))) != null) {
            transactionMetadataManager = oldTransactionMetadataManager;
        }
        return transactionMetadataManager;
    }

    protected TransactionMetadataManager doCreateTransactionMetadataManager(String namespace) {
        return new TransactionMetadataManager(namespace, this.config);
    }

    protected GroupMetadataManager doCreateGroupMetadataManager(String namespace) {
        return new GroupMetadataManager(namespace, this.config);
    }
}

