/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.coordinator.config;

import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.coordinator.config.CoordinatorConfigKey;
import org.joyqueue.domain.TopicName;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorConfig {
    protected static final Logger logger = LoggerFactory.getLogger(CoordinatorConfig.class);
    private PropertySupplier propertySupplier;

    public CoordinatorConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
    }

    public String getGroupNamespace() {
        return (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.GROUP_NAMESPACE);
    }

    public TopicName getGroupTopic() {
        String topic = (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.GROUP_TOPIC_CODE);
        String namespace = this.getGroupNamespace();
        if (StringUtils.isBlank((CharSequence)namespace) || namespace.equals("null")) {
            return TopicName.parse((String)topic);
        }
        return TopicName.parse((String)topic, (String)namespace);
    }

    public short getGroupTopicPartitions() {
        return (Short)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.GROUP_TOPIC_PARTITIONS);
    }

    public int getGroupExpireTime() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.GROUP_EXPIRE_TIME);
    }

    public TopicName getTransactionTopic() {
        String topic = (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.TRANSACTION_TOPIC_CODE);
        String namespace = this.getGroupNamespace();
        if (StringUtils.isBlank((CharSequence)namespace) || namespace.equals("null")) {
            return TopicName.parse((String)topic);
        }
        return TopicName.parse((String)topic, (String)namespace);
    }

    public short getTransactionTopicPartitions() {
        return (Short)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.TRANSACTION_TOPIC_PARTITIONS);
    }

    public String getTransactionLogApp() {
        return (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.TRANSACTION_LOG_APP);
    }

    public int getTransactionExpireTime() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.TRANSACTION_EXPIRE_TIME);
    }

    public int getTransactionMaxNum() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.TRANSACTION_MAX_NUM);
    }

    public int getSessionTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.SESSION_SYNC_TIMEOUT);
    }

    public int getSessionExpireTime() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)CoordinatorConfigKey.SESSION_EXPIRE_TIME);
    }
}

