/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.coordinator.group;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.coordinator.config.CoordinatorConfig;
import org.joyqueue.broker.coordinator.group.domain.GroupMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupMetadataManager {
    protected static final Logger logger = LoggerFactory.getLogger(GroupMetadataManager.class);
    private String namespace;
    private CoordinatorConfig config;
    private Cache<String, GroupMetadata> groupCache;

    public GroupMetadataManager(String namespace, CoordinatorConfig config) {
        this.namespace = namespace;
        this.config = config;
        this.groupCache = CacheBuilder.newBuilder().expireAfterAccess((long)config.getGroupExpireTime(), TimeUnit.MILLISECONDS).build();
    }

    public <T extends GroupMetadata> T getGroup(String groupId) {
        if (StringUtils.isBlank((CharSequence)groupId)) {
            return null;
        }
        return (T)((GroupMetadata)this.groupCache.getIfPresent((Object)groupId));
    }

    public <T extends GroupMetadata> List<T> getGroups() {
        return Lists.newArrayList(this.groupCache.asMap().values());
    }

    public <T extends GroupMetadata> T getOrCreateGroup(final GroupMetadata group) {
        return this.getOrCreateGroup(group.getId(), new Callable<GroupMetadata>(){

            @Override
            public GroupMetadata call() throws Exception {
                return group;
            }
        });
    }

    public <T extends GroupMetadata> T getOrCreateGroup(final String groupId) {
        if (StringUtils.isBlank((CharSequence)groupId)) {
            return null;
        }
        return this.getOrCreateGroup(groupId, new Callable<GroupMetadata>(){

            @Override
            public GroupMetadata call() throws Exception {
                return new GroupMetadata(groupId);
            }
        });
    }

    public <T extends GroupMetadata> T getOrCreateGroup(String groupId, Callable<GroupMetadata> callable) {
        if (StringUtils.isBlank((CharSequence)groupId)) {
            return null;
        }
        try {
            return (T)((GroupMetadata)this.groupCache.get((Object)groupId, callable));
        }
        catch (ExecutionException e) {
            logger.error("getOrCreate coordinatorGroup exception, groupId: {}", (Object)groupId, (Object)e);
            return (T)((GroupMetadata)this.groupCache.getIfPresent((Object)groupId));
        }
    }

    public boolean removeGroup(String groupId) {
        this.groupCache.invalidate((Object)groupId);
        return true;
    }
}

