/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.coordinator.group.domain;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joyqueue.toolkit.time.SystemClock;

public class GroupMemberMetadata {
    private String id;
    private String groupId;
    private String connectionId;
    private String connectionHost;
    private long latestHeartbeat;
    private int sessionTimeout;
    private Map<String, List<Short>> assignments;
    private List<Short> assignmentList;

    public GroupMemberMetadata() {
    }

    public GroupMemberMetadata(String id, String groupId, String connectionId, String connectionHost, int sessionTimeout) {
        this.id = id;
        this.groupId = groupId;
        this.connectionId = connectionId;
        this.connectionHost = connectionHost;
        this.sessionTimeout = sessionTimeout;
    }

    public boolean isExpired() {
        return this.latestHeartbeat + (long)this.sessionTimeout < SystemClock.now();
    }

    public void setAssignedTopicPartitions(String topic, List<Short> partitions) {
        Map<String, List<Short>> assignments = this.getOrCreateAssignments();
        assignments.put(topic, partitions);
    }

    public void addAssignedPartition(String topic, short partition) {
        this.getAssignedTopicPartitions(topic).add(partition);
    }

    public void removeAssignedPartition(String topic, short partition) {
        if (this.assignments == null) {
            return;
        }
        List<Short> partitions = this.assignments.get(topic);
        if (partitions == null) {
            return;
        }
        partitions.remove((Object)partition);
    }

    public List<Short> getAssignedTopicPartitions(String topic) {
        Map<String, List<Short>> assignments = this.getOrCreateAssignments();
        ArrayList partitionList = assignments.get(topic);
        if (partitionList == null) {
            partitionList = Lists.newArrayList();
            assignments.put(topic, partitionList);
        }
        return partitionList;
    }

    protected Map<String, List<Short>> getOrCreateAssignments() {
        if (this.assignments == null) {
            this.assignments = Maps.newHashMap();
        }
        return this.assignments;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getConnectionHost() {
        return this.connectionHost;
    }

    public void setConnectionHost(String connectionHost) {
        this.connectionHost = connectionHost;
    }

    public long getLatestHeartbeat() {
        return this.latestHeartbeat;
    }

    public void setLatestHeartbeat(long latestHeartbeat) {
        this.latestHeartbeat = latestHeartbeat;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setAssignments(Map<String, List<Short>> assignments) {
        this.assignments = assignments;
    }

    public Map<String, List<Short>> getAssignments() {
        return this.assignments;
    }

    public void setAssignmentList(List<Short> assignmentList) {
        this.assignmentList = assignmentList;
    }

    public List<Short> getAssignmentList() {
        return this.assignmentList;
    }
}

