/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.coordinator.group.domain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.joyqueue.broker.coordinator.group.domain.ExpiredGroupMemberMetadata;
import org.joyqueue.broker.coordinator.group.domain.GroupMemberMetadata;
import org.joyqueue.toolkit.time.SystemClock;

public class GroupMetadata {
    private static final int MAX_EXPIRED_MEMBER = 100;
    private String id;
    private String extension;
    private ConcurrentMap<String, GroupMemberMetadata> members = Maps.newConcurrentMap();
    private Cache<String, ExpiredGroupMemberMetadata> expiredMembers = CacheBuilder.newBuilder().maximumSize(100L).build();
    private Map<String, ExpiredGroupMemberMetadata> expiredMembersMap;

    public GroupMetadata() {
    }

    public GroupMetadata(String id) {
        this.id = id;
    }

    public void addMember(GroupMemberMetadata member) {
        this.members.put(member.getId(), member);
    }

    public void addExpiredMember(GroupMemberMetadata member) {
        final String host = this.getHost(member.getConnectionHost());
        try {
            ExpiredGroupMemberMetadata expiredMember = (ExpiredGroupMemberMetadata)this.expiredMembers.get((Object)host, (Callable)new Callable<ExpiredGroupMemberMetadata>(){

                @Override
                public ExpiredGroupMemberMetadata call() throws Exception {
                    return new ExpiredGroupMemberMetadata(host);
                }
            });
            expiredMember.setLatestHeartbeat(member.getLatestHeartbeat());
            expiredMember.setExpireTime(SystemClock.now());
            expiredMember.getExpireTimes().incrementAndGet();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public Map<String, ExpiredGroupMemberMetadata> expiredMembersToMap() {
        return this.expiredMembers.asMap();
    }

    protected String getHost(String host) {
        if (host.startsWith("/")) {
            host = host.substring(1);
        }
        if (host.contains(":")) {
            host = host.substring(0, host.indexOf(":"));
        }
        return host;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public ConcurrentMap<String, GroupMemberMetadata> getMembers() {
        return this.members;
    }

    public void setMembers(ConcurrentMap<String, GroupMemberMetadata> members) {
        this.members = members;
    }

    public void setExpiredMembersMap(Map<String, ExpiredGroupMemberMetadata> expiredMembersMap) {
        this.expiredMembersMap = expiredMembersMap;
    }

    public Map<String, ExpiredGroupMemberMetadata> getExpiredMembers() {
        return this.expiredMembersMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupMetadata that = (GroupMetadata)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "GroupMetadata{id='" + this.id + '\'' + ", members=" + this.members + '}';
    }
}

