/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.coordinator.support;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.coordinator.config.CoordinatorConfig;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.NameService;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorInitializer
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(CoordinatorInitializer.class);
    private CoordinatorConfig config;
    private ClusterManager clusterManager;
    private NameService nameService;

    public CoordinatorInitializer(CoordinatorConfig config, ClusterManager clusterManager, NameService nameService) {
        this.config = config;
        this.clusterManager = clusterManager;
        this.nameService = nameService;
    }

    public boolean init() {
        try {
            this.initGroupTopic();
            this.initTransactionTopic();
            return true;
        }
        catch (Exception e) {
            logger.error("init coordinator exception", (Throwable)e);
            return false;
        }
    }

    protected boolean initGroupTopic() {
        return this.initCoordinatorTopic(this.config.getGroupTopic(), this.config.getGroupTopicPartitions());
    }

    protected boolean initTransactionTopic() {
        return this.initCoordinatorTopic(this.config.getTransactionTopic(), this.config.getTransactionTopicPartitions()) && this.initCoordinatorSubscribe(this.config.getTransactionTopic(), this.config.getTransactionLogApp());
    }

    protected boolean initCoordinatorSubscribe(TopicName topic, String app) {
        if (this.nameService.getConsumerByTopicAndApp(topic, app) == null) {
            this.nameService.subscribe(new Subscription(topic, app, Subscription.Type.CONSUMPTION), ClientType.JOYQUEUE);
        }
        if (this.nameService.getProducerByTopicAndApp(topic, app) == null) {
            this.nameService.subscribe(new Subscription(topic, app, Subscription.Type.PRODUCTION), ClientType.JOYQUEUE);
        }
        return true;
    }

    protected boolean initCoordinatorTopic(TopicName topic, int partitions) {
        TopicConfig coordinatorTopic = this.nameService.getTopicConfig(topic);
        if (coordinatorTopic != null) {
            return true;
        }
        Broker currentBroker = this.clusterManager.getBroker();
        LinkedList partitionGroupList = Lists.newLinkedList();
        for (int i = 0; i < partitions; ++i) {
            PartitionGroup partitionGroup = new PartitionGroup();
            partitionGroup.setTopic(topic);
            partitionGroup.setGroup(i);
            partitionGroup.setLeader(currentBroker.getId());
            partitionGroup.setPartitions((Set)Sets.newHashSet((Object[])new Short[]{(short)i}));
            partitionGroup.setReplicas((Set)Sets.newHashSet((Object[])new Integer[]{currentBroker.getId()}));
            partitionGroup.setElectType(PartitionGroup.ElectType.raft);
            partitionGroupList.add(partitionGroup);
        }
        Topic newTopic = new Topic();
        newTopic.setName(topic);
        newTopic.setPartitions((short)partitionGroupList.size());
        newTopic.setType(Topic.Type.TOPIC);
        logger.info("create coordinator topic, topic: {}, partitions: {}", (Object)newTopic.getName().getFullName(), (Object)newTopic.getPartitions());
        this.nameService.addTopic(newTopic, (List)partitionGroupList);
        return true;
    }
}

