/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.coordinator.support;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.coordinator.config.CoordinatorConfig;
import org.joyqueue.broker.coordinator.domain.CoordinatorDetail;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorResolver
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(CoordinatorResolver.class);
    private CoordinatorConfig config;
    private ClusterManager clusterManager;

    public CoordinatorResolver(CoordinatorConfig config, ClusterManager clusterManager) {
        this.config = config;
        this.clusterManager = clusterManager;
    }

    public Broker findCoordinator(String key, TopicName topic) {
        PartitionGroup coordinatorPartitionGroup = this.resolveCoordinatorPartitionGroup(key, topic);
        if (coordinatorPartitionGroup == null) {
            return null;
        }
        return coordinatorPartitionGroup.getLeaderBroker();
    }

    public CoordinatorDetail getCoordinatorDetail(String key, TopicName topic) {
        PartitionGroup coordinatorPartitionGroup = this.resolveCoordinatorPartitionGroup(key, topic);
        if (coordinatorPartitionGroup == null) {
            return null;
        }
        HashMap brokers = Maps.newHashMap((Map)((Map)ObjectUtils.defaultIfNull((Object)coordinatorPartitionGroup.getBrokers(), Collections.emptyMap())));
        Broker leader = coordinatorPartitionGroup.getLeaderBroker();
        if (leader != null) {
            brokers.remove(leader.getId());
        }
        return new CoordinatorDetail(coordinatorPartitionGroup.getTopic(), coordinatorPartitionGroup.getGroup(), leader, Lists.newArrayList(brokers.values()));
    }

    public PartitionGroup resolveCoordinatorPartitionGroup(String key, TopicName topic) {
        TopicConfig coordinatorTopic = this.clusterManager.getNameService().getTopicConfig(topic);
        if (coordinatorTopic == null) {
            return null;
        }
        return this.resolveCoordinatorPartitionGroup(key, coordinatorTopic);
    }

    public PartitionGroup resolveCoordinatorPartitionGroup(String key, TopicConfig topicConfig) {
        List partitionGroups = null;
        partitionGroups = topicConfig.getPartitionGroups() instanceof List ? (List)((Object)topicConfig.getPartitionGroups()) : Lists.newArrayList(topicConfig.getPartitionGroups().values());
        short index = (short)Math.abs(key.hashCode() % partitionGroups.size());
        return (PartitionGroup)partitionGroups.get(index);
    }
}

