/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.coordinator.transaction;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.coordinator.config.CoordinatorConfig;
import org.joyqueue.broker.coordinator.transaction.domain.TransactionMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionMetadataManager {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionMetadataManager.class);
    private String namespace;
    private CoordinatorConfig config;
    private Cache<String, TransactionMetadata> transactionCache;

    public TransactionMetadataManager(String namespace, CoordinatorConfig config) {
        this.namespace = namespace;
        this.config = config;
        this.transactionCache = CacheBuilder.newBuilder().expireAfterAccess((long)config.getTransactionExpireTime(), TimeUnit.MILLISECONDS).maximumSize((long)config.getTransactionMaxNum()).build();
    }

    public <T extends TransactionMetadata> T tryGetTransaction(String transactionId) {
        return (T)((TransactionMetadata)this.transactionCache.asMap().get(transactionId));
    }

    public <T extends TransactionMetadata> T getTransaction(String transactionId) {
        return (T)((TransactionMetadata)this.transactionCache.getIfPresent((Object)transactionId));
    }

    public <T extends TransactionMetadata> List<T> getTransactions() {
        return Lists.newArrayList(this.transactionCache.asMap().values());
    }

    public <T extends TransactionMetadata> T getOrCreateTransaction(final TransactionMetadata transaction) {
        return this.getOrCreateTransaction(transaction.getId(), new Callable<TransactionMetadata>(){

            @Override
            public TransactionMetadata call() throws Exception {
                return transaction;
            }
        });
    }

    public <T extends TransactionMetadata> T getOrCreateTransaction(final String transactionId) {
        return this.getOrCreateTransaction(transactionId, new Callable<TransactionMetadata>(){

            @Override
            public TransactionMetadata call() throws Exception {
                return new TransactionMetadata(transactionId);
            }
        });
    }

    public <T extends TransactionMetadata> T getOrCreateTransaction(String transactionId, Callable<TransactionMetadata> callable) {
        try {
            return (T)((TransactionMetadata)this.transactionCache.get((Object)transactionId, callable));
        }
        catch (ExecutionException e) {
            logger.error("getOrCreate coordinatorGroup exception, transactionId: {}", (Object)transactionId, (Object)e);
            return (T)((TransactionMetadata)this.transactionCache.getIfPresent((Object)transactionId));
        }
    }

    public boolean removeTransaction(String transactionId) {
        this.transactionCache.invalidate((Object)transactionId);
        return true;
    }
}

