/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election;

import java.util.Objects;
import org.joyqueue.broker.election.ElectionNode;
import org.joyqueue.domain.Broker;

public class DefaultElectionNode
implements ElectionNode {
    private ElectionNode.State state = ElectionNode.State.FOLLOWER;
    private long priority;
    private String address;
    private int nodeId;
    private boolean voteGranted = false;

    public DefaultElectionNode() {
    }

    public DefaultElectionNode(String address, int nodeId) {
        this.address = address;
        this.nodeId = nodeId;
        this.state = ElectionNode.State.FOLLOWER;
    }

    @Override
    public ElectionNode.State getState() {
        return this.state;
    }

    @Override
    public void setState(ElectionNode.State state) {
        this.state = state;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public long getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(long priority) {
        this.priority = priority;
    }

    @Override
    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public boolean isVoteGranted() {
        return this.voteGranted;
    }

    @Override
    public void setVoteGranted(boolean voteGranted) {
        this.voteGranted = voteGranted;
    }

    @Override
    public boolean equals(ElectionNode node) {
        return this.nodeId == node.getNodeId();
    }

    public boolean equals(Broker broker) {
        return this.nodeId == broker.getId();
    }

    public String toString() {
        return "DefaultElectionNode:{" + "state:" + (Object)((Object)this.state) + ", address:" + this.address + ", nodeId:" + this.nodeId + ", voteGranted:" + this.voteGranted + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!(o instanceof DefaultElectionNode)) {
            return false;
        }
        DefaultElectionNode that = (DefaultElectionNode)o;
        return this.priority == that.priority && this.nodeId == that.nodeId && this.voteGranted == that.voteGranted && this.state == that.state && this.address.equals(that.address);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.priority, this.address, this.nodeId, this.voteGranted});
    }
}

