/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election;

import org.joyqueue.broker.election.ElectionConfigKey;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;

public class ElectionConfig {
    public static final String ELECTION_META_PATH = "/election";
    private String electionMetaPath;
    private PropertySupplier propertySupplier;
    private int listenPort;
    private String electionMetaPathStub;

    public ElectionConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetadataPath() {
        if (this.electionMetaPathStub != null) {
            return this.electionMetaPathStub;
        }
        if (this.electionMetaPath == null || this.electionMetaPath.isEmpty()) {
            ElectionConfig electionConfig = this;
            synchronized (electionConfig) {
                if (this.electionMetaPath == null) {
                    String prefix = "";
                    if (this.propertySupplier != null) {
                        Property property = this.propertySupplier.getProperty("application.data.path");
                        prefix = property == null ? prefix : property.getString();
                    }
                    this.electionMetaPath = prefix + ELECTION_META_PATH;
                }
            }
        }
        return this.electionMetaPath;
    }

    public int getElectionTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.ELECTION_TIMEOUT);
    }

    public int getVoteTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.VOTE_TIMEOUT);
    }

    public int getExecutorThreadNumMin() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.EXECUTOR_THREAD_NUM_MIN);
    }

    public int getExecutorThreadNumMax() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.EXECUTOR_THREAD_NUM_MAX);
    }

    public int getTimerScheduleThreadNum() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.TIMER_SCHEDULE_THREAD_NUM);
    }

    public int getHeartbeatTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.HEARTBEAT_TIMEOUT);
    }

    public int getSendCommandTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.SEND_COMMAND_TIMEOUT);
    }

    public int getMaxReplicateLength() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.MAX_BATCH_REPLICATE_SIZE);
    }

    public int getDisableStoreTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.DISABLE_STORE_TIMEOUT);
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public int getTransferLeaderTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.TRANSFER_LEADER_TIMEOUT);
    }

    public int getReplicateConsumePosInterval() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.REPLICATE_CONSUME_POS_INTERVAL);
    }

    public int getReplicateThreadNumMin() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.REPLICATE_THREAD_NUM_MIN);
    }

    public int getReplicateThreadNumMax() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.REPLICATE_THREAD_NUM_MAX);
    }

    public int getCommandQueueSize() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.COMMAND_QUEUE_SIZE);
    }

    public int getLogInterval() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.LOG_INTERVAL);
    }

    public long getTransferLeaderMinLag() {
        return (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.TRANSFER_LEADER_MIN_LAG);
    }

    public boolean enableRebalanceLeader() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.ENABLE_REBALANCE_LEADER);
    }

    public int getMinRebalanceLeaderInterval() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.MIN_REBALANCE_INTERVAL);
    }

    public boolean enableReportLeaderPeriodically() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.ENABLE_REPORT_LEADER_PERIODICALLY);
    }

    public boolean enableReportLeaderPeriodicallyForce() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.ENABLE_REPORT_LEADER_PERIODICALLY_FORCE);
    }

    public boolean enableOnlineNodePeriodically() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.ENABLE_ONLINE_NODE_PERIODICALLY);
    }

    public boolean getOutputConsumePos() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ElectionConfigKey.OUTPUT_CONSUME_POS);
    }

    public void setListenPort(String port) {
        this.listenPort = Integer.valueOf(port);
    }

    public void setElectionMetaPath(String electionMetaPath) {
        this.electionMetaPathStub = electionMetaPath;
    }
}

