/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.config.BrokerConfig;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.election.DefaultElectionNode;
import org.joyqueue.broker.election.ElectionConfig;
import org.joyqueue.broker.election.ElectionEvent;
import org.joyqueue.broker.election.ElectionException;
import org.joyqueue.broker.election.ElectionMetadata;
import org.joyqueue.broker.election.ElectionMetadataManager;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.election.FixLeaderElection;
import org.joyqueue.broker.election.LeaderElection;
import org.joyqueue.broker.election.RaftLeaderElection;
import org.joyqueue.broker.election.TopicPartitionGroup;
import org.joyqueue.broker.monitor.BrokerMonitor;
import org.joyqueue.broker.network.support.BrokerTransportClientFactory;
import org.joyqueue.broker.replication.ReplicaGroup;
import org.joyqueue.broker.replication.ReplicationManager;
import org.joyqueue.broker.replication.ReplicationTransportSession;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicName;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.config.ClientConfig;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.store.StoreService;
import org.joyqueue.store.replication.ReplicableStore;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectionManager
extends Service
implements ElectionService,
BrokerContextAware {
    private static Logger logger = LoggerFactory.getLogger(ElectionManager.class);
    private Map<TopicPartitionGroup, LeaderElection> leaderElections;
    private TransportClient transportClient;
    protected ElectionConfig electionConfig;
    private ClusterManager clusterManager;
    private final Map<String, ReplicationTransportSession> sessions = new ConcurrentHashMap<String, ReplicationTransportSession>();
    private ScheduledExecutorService electionTimerExecutor;
    private ExecutorService electionExecutor;
    private EventBus<ElectionEvent> electionEventManager = new EventBus("LeaderElectionEvent");
    private ElectionMetadataManager electionMetadataManager;
    private ReplicationManager replicationManager;
    private StoreService storeService;
    private Consume consume;
    private BrokerMonitor brokerMonitor;
    private BrokerContext brokerContext;
    private BrokerConfig brokerConfig;

    public ElectionManager() {
    }

    public ElectionManager(BrokerConfig brokerConfig, ElectionConfig electionConfig, StoreService storeService, Consume consume, ClusterManager clusterManager, BrokerMonitor brokerMonitor) {
        this.brokerConfig = brokerConfig;
        this.electionConfig = electionConfig;
        this.clusterManager = clusterManager;
        this.storeService = storeService;
        this.consume = consume;
        this.brokerMonitor = brokerMonitor;
    }

    public ElectionManager(ElectionConfig electionConfig, StoreService storeService, Consume consume, ClusterManager clusterManager, BrokerMonitor brokerMonitor) {
        this(null, electionConfig, storeService, consume, clusterManager, brokerMonitor);
    }

    protected void validate() throws Exception {
        super.validate();
        if (this.brokerConfig == null) {
            BrokerConfig brokerConfig = this.brokerConfig = this.brokerContext == null ? null : this.brokerContext.getBrokerConfig();
        }
        if (this.electionConfig == null) {
            this.electionConfig = new ElectionConfig(this.brokerContext == null ? null : this.brokerContext.getPropertySupplier());
        }
        if (this.storeService == null && this.brokerContext != null) {
            this.storeService = this.brokerContext.getStoreService();
        }
        if (this.clusterManager == null && this.brokerContext != null) {
            this.clusterManager = this.brokerContext.getClusterManager();
        }
        if (this.consume == null && this.brokerContext != null) {
            this.consume = this.brokerContext.getConsume();
        }
        if (this.brokerMonitor == null && this.brokerContext != null) {
            this.brokerMonitor = this.brokerContext.getBrokerMonitor();
        }
        if (this.brokerMonitor == null) {
            logger.warn("broker monitor is null.");
        }
        Preconditions.checkArgument((this.electionConfig != null ? 1 : 0) != 0, (Object)"election config is null");
        Preconditions.checkArgument((this.clusterManager != null ? 1 : 0) != 0, (Object)"cluster manager is null");
        Preconditions.checkArgument((this.storeService != null ? 1 : 0) != 0, (Object)"store service is null");
        Preconditions.checkArgument((this.consume != null ? 1 : 0) != 0, (Object)"consume is null");
    }

    public void doStart() throws Exception {
        super.doStart();
        this.electionEventManager.start();
        this.addListener(this.brokerMonitor.new BrokerMonitor.ElectionListener());
        this.leaderElections = new ConcurrentHashMap<TopicPartitionGroup, LeaderElection>();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setIoThreadName("joyqueue-election-io-eventLoop");
        clientConfig.setConnectionTimeout(300);
        clientConfig.getRetryPolicy().setRetryDelay(Integer.valueOf(60000));
        this.transportClient = new BrokerTransportClientFactory().create(clientConfig);
        this.transportClient.start();
        this.electionTimerExecutor = Executors.newScheduledThreadPool(this.electionConfig.getTimerScheduleThreadNum(), (ThreadFactory)new NamedThreadFactory("Election-Timer"));
        this.electionExecutor = new ThreadPoolExecutor(this.electionConfig.getExecutorThreadNumMin(), this.electionConfig.getExecutorThreadNumMax(), 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(this.electionConfig.getCommandQueueSize()), (ThreadFactory)new NamedThreadFactory("Election-sendCommand"));
        this.replicationManager = new ReplicationManager(this.electionConfig, this.brokerConfig, this.storeService, this.consume, this.brokerMonitor);
        this.replicationManager.start();
        Thread.sleep(1000L);
        this.electionMetadataManager = new ElectionMetadataManager(this.electionConfig.getMetadataPath());
        this.electionMetadataManager.recover(this);
        for (Map.Entry<TopicPartitionGroup, ElectionMetadata> entry : this.electionMetadataManager.getAllElectionMetadata().entrySet()) {
            TopicPartitionGroup topicPartitionGroup = entry.getKey();
            ElectionMetadata electionMetadata = entry.getValue();
            this.electionEventManager.add((Object)new ElectionEvent(ElectionEvent.Type.START_ELECTION, electionMetadata.getCurrentTerm(), electionMetadata.getLeaderId(), topicPartitionGroup));
        }
        logger.info("Election manager started.");
    }

    public void doStop() {
        logger.info("Election manager stop");
        for (TopicPartitionGroup topicPartitionGroup : this.leaderElections.keySet()) {
            LeaderElection leaderElection = this.getLeaderElection(topicPartitionGroup.getTopic(), topicPartitionGroup.getPartitionGroupId());
            if (leaderElection == null) continue;
            leaderElection.stop();
        }
        this.leaderElections.clear();
        for (Map.Entry entry : this.sessions.entrySet()) {
            ((ReplicationTransportSession)entry.getValue()).stop();
        }
        Close.close((ExecutorService)this.electionTimerExecutor);
        Close.close((ExecutorService)this.electionExecutor);
        Close.close(this.electionEventManager);
        Close.close((LifeCycle)this.transportClient);
        Close.close((LifeCycle)this.replicationManager);
        super.doStop();
    }

    @Override
    public void onPartitionGroupCreate(PartitionGroup.ElectType electType, TopicName topic, int partitionGroup, List<Broker> brokers, Set<Integer> learners, int localBroker, int leader) throws ElectionException {
        logger.info("Create election of topic {}, partition group {}, election type is {}, localBroker is {}, leader is {}, all nodes is {}", new Object[]{topic, partitionGroup, electType, localBroker, leader, JSON.toJSONString(brokers)});
        List<DefaultElectionNode> allNodes = brokers.stream().map(b -> new DefaultElectionNode(b.getIp() + ":" + b.getBackEndPort(), b.getId())).collect(Collectors.toList());
        ReplicaGroup replicaGroup = this.replicationManager.createReplicaGroup(topic.getFullName(), partitionGroup, allNodes, learners, localBroker, leader, this.brokerMonitor);
        LeaderElection leaderElection = this.createLeaderElection(electType, topic.getFullName(), partitionGroup, allNodes, learners, localBroker, leader, replicaGroup);
        replicaGroup.setLeaderElection(leaderElection);
    }

    @Override
    public void onPartitionGroupRemove(TopicName topic, int partitionGroup) {
        logger.info("Remove election of topic {}, partition group {}", (Object)topic, (Object)partitionGroup);
        this.removeLeaderElection(topic.getFullName(), partitionGroup);
        this.replicationManager.removeReplicaGroup(topic.getFullName(), partitionGroup);
    }

    @Override
    public void onNodeAdd(TopicName topic, int partitionGroup, PartitionGroup.ElectType electType, List<Broker> brokers, Set<Integer> learners, Broker broker, int localBroker, int leader) throws ElectionException {
        logger.info("Add node {} to election of topic {}, partition group {}", new Object[]{broker, topic, partitionGroup});
        LeaderElection leaderElection = this.getLeaderElection(topic, partitionGroup);
        if (leaderElection == null) {
            logger.warn("Add node to election of topic {}/partition group {}, leader election is null", (Object)topic, (Object)partitionGroup);
            if (localBroker != broker.getId()) {
                throw new ElectionException(String.format("Add node to election of topic %s/partition group %d, leader election is null", topic, partitionGroup));
            }
            List<DefaultElectionNode> allNodes = brokers.stream().map(b -> new DefaultElectionNode(b.getIp() + ":" + b.getBackEndPort(), b.getId())).collect(Collectors.toList());
            ReplicaGroup replicaGroup = this.replicationManager.createReplicaGroup(topic.getFullName(), partitionGroup, allNodes, learners, localBroker, leader, this.brokerMonitor);
            LeaderElection leaderElectionNew = this.createLeaderElection(electType, topic.getFullName(), partitionGroup, allNodes, learners, localBroker, leader, replicaGroup);
            replicaGroup.setLeaderElection(leaderElectionNew);
            return;
        }
        leaderElection.addNode(new DefaultElectionNode(broker.getIp() + ":" + broker.getBackEndPort(), broker.getId()));
    }

    @Override
    public void onNodeRemove(TopicName topic, int partitionGroup, int brokerId, int localBroker) {
        logger.info("Remove node {} from election of topic {}, partition group {}", new Object[]{brokerId, topic, partitionGroup});
        if (brokerId == localBroker) {
            this.removeLeaderElection(topic.getFullName(), partitionGroup);
            return;
        }
        LeaderElection leaderElection = this.getLeaderElection(topic, partitionGroup);
        if (leaderElection == null) {
            logger.warn("Remove node from election of topic {}/partition group {}, leader election is null", (Object)topic, (Object)partitionGroup);
            return;
        }
        leaderElection.removeNode(brokerId);
    }

    @Override
    public void onElectionTypeChange(TopicName topic, int partitionGroup, PartitionGroup.ElectType electType, List<Broker> brokers, Set<Integer> learners, int localBroker, int leader) throws ElectionException {
        logger.info("Election of topic {} partition group {}'s election type change to {}", new Object[]{topic, partitionGroup, electType});
        LeaderElection leaderElection = this.getLeaderElection(topic, partitionGroup);
        ReplicaGroup replicaGroup = leaderElection.getReplicaGroup();
        this.removeLeaderElection(topic.getFullName(), partitionGroup);
        try {
            List<DefaultElectionNode> allNodes = brokers.stream().map(b -> new DefaultElectionNode(b.getIp() + ":" + b.getBackEndPort(), b.getId())).collect(Collectors.toList());
            LeaderElection leaderElectionNew = this.createLeaderElection(electType, topic.getFullName(), partitionGroup, allNodes, learners, localBroker, leader, replicaGroup);
            replicaGroup.setLeaderElection(leaderElectionNew);
        }
        catch (Exception e) {
            throw new ElectionException("Create leader election failed", e);
        }
    }

    @Override
    public void onLeaderChange(TopicName topic, int partitionGroup, int leaderId) throws Exception {
        logger.info("Election of topic {} partition group {}'s leader change to {}", new Object[]{topic, partitionGroup, leaderId});
        LeaderElection leaderElection = this.getLeaderElection(topic, partitionGroup);
        if (leaderElection == null) {
            logger.warn("Leader of topic {}/partition group {} change, election is null", (Object)topic, (Object)partitionGroup);
            throw new ElectionException(String.format("Leader of topic %s/partition group %d change, election is null", topic, partitionGroup));
        }
        leaderElection.setLeaderId(leaderId);
    }

    @Override
    public LeaderElection getLeaderElection(TopicName topic, int partitionGroup) {
        return this.getLeaderElection(topic.getFullName(), partitionGroup);
    }

    @Override
    public List<LeaderElection> getLeaderElections() {
        return new ArrayList<LeaderElection>(this.leaderElections.values());
    }

    public LeaderElection getLeaderElection(String topic, int partitionGroup) {
        return this.leaderElections.get(new TopicPartitionGroup(topic, partitionGroup));
    }

    void restoreLeaderElection(TopicPartitionGroup topicPartitionGroup, ElectionMetadata metadata) throws Exception {
        logger.info("Restore election of topic {}, partition group {}, election type is {}, localBroker is {}, leader is {}, all nodes is {}", new Object[]{topicPartitionGroup.getTopic(), topicPartitionGroup.getPartitionGroupId(), metadata.getElectType(), metadata.getLocalNodeId(), metadata.getLeaderId(), JSON.toJSONString(metadata.getAllNodes())});
        ReplicaGroup replicaGroup = this.replicationManager.createReplicaGroup(topicPartitionGroup.getTopic(), topicPartitionGroup.getPartitionGroupId(), new LinkedList<DefaultElectionNode>(metadata.getAllNodes()), metadata.getLearners(), metadata.getLocalNodeId(), metadata.getLeaderId(), this.brokerMonitor);
        LeaderElection leaderElection = this.createLeaderElection(metadata.getElectType(), topicPartitionGroup.getTopic(), topicPartitionGroup.getPartitionGroupId(), new LinkedList<DefaultElectionNode>(metadata.getAllNodes()), metadata.getLearners(), metadata.getLocalNodeId(), metadata.getLeaderId(), replicaGroup);
        replicaGroup.setLeaderElection(leaderElection);
    }

    int getLeaderElectionCount() {
        return this.leaderElections.size();
    }

    private synchronized LeaderElection createLeaderElection(PartitionGroup.ElectType electType, String topic, int partitionGroup, List<DefaultElectionNode> allNodes, Set<Integer> learners, int localNodeId, int leaderId, ReplicaGroup replicaGroup) throws ElectionException {
        ReplicableStore replicableStore;
        TopicPartitionGroup topicPartitionGroup = new TopicPartitionGroup(topic, partitionGroup);
        LeaderElection leaderElection = this.leaderElections.get(topicPartitionGroup);
        if (leaderElection != null) {
            logger.warn("Create leader election for topic {}/partition group {}, election is not null", (Object)topic, (Object)partitionGroup);
            this.removeLeaderElection(topic, partitionGroup);
        }
        if ((replicableStore = this.storeService.getReplicableStore(topic, partitionGroup)) == null) {
            throw new ElectionException(String.format("Replicable store of topic %s partition group %d is null", topic, partitionGroup));
        }
        if (electType == PartitionGroup.ElectType.fix) {
            leaderElection = new FixLeaderElection(topicPartitionGroup, this.electionConfig, this, this.clusterManager, this.electionMetadataManager, replicableStore, replicaGroup, this.electionEventManager, leaderId, localNodeId, allNodes);
        } else if (electType == PartitionGroup.ElectType.raft) {
            leaderElection = new RaftLeaderElection(topicPartitionGroup, this.electionConfig, this, this.clusterManager, this.electionMetadataManager, replicableStore, replicaGroup, this.electionTimerExecutor, this.electionExecutor, this.electionEventManager, localNodeId, allNodes, learners);
        } else {
            throw new ElectionException("Incorrect election type {}" + electType);
        }
        try {
            leaderElection.start();
        }
        catch (Exception e) {
            throw new ElectionException("Leader election start fail" + e);
        }
        this.leaderElections.put(topicPartitionGroup, leaderElection);
        return leaderElection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLeaderElection(String topic, int partitionGroupId) {
        ElectionManager electionManager = this;
        synchronized (electionManager) {
            TopicPartitionGroup topicPartitionGroup = new TopicPartitionGroup(topic, partitionGroupId);
            LeaderElection leaderElection = this.leaderElections.get(topicPartitionGroup);
            if (leaderElection == null) {
                logger.warn("Remove leader election of partition group {}, leader election is null", (Object)topicPartitionGroup);
                return;
            }
            this.electionMetadataManager.removeElectionMetadata(topicPartitionGroup);
            leaderElection.stop();
            this.leaderElections.remove(topicPartitionGroup);
        }
    }

    @Override
    public void addListener(EventListener<ElectionEvent> listener) {
        this.electionEventManager.addListener(listener);
    }

    @Override
    public void removeListener(EventListener<ElectionEvent> listener) {
        this.electionEventManager.removeListener(listener);
    }

    @Override
    public String describe(String topic, int partitionGroup) {
        return this.electionMetadataManager.describe(topic, partitionGroup);
    }

    @Override
    public String describe() {
        return this.electionMetadataManager.describe();
    }

    @Override
    public void syncElectionMetadataFromNameService() {
        this.electionMetadataManager.syncElectionMetadataFromNameService(this.clusterManager);
    }

    @Override
    public void updateTerm(String topic, int partitionGroup, int term) {
        this.electionMetadataManager.updateTerm(topic, partitionGroup, term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCommand(String address, Command command, int timeout, CommandCallback callback) throws TransportException {
        if (!this.isStarted()) {
            logger.info("Send election command but election manager is stopped");
            return;
        }
        ReplicationTransportSession transport = this.sessions.get(address);
        if (transport == null) {
            Map<String, ReplicationTransportSession> map = this.sessions;
            synchronized (map) {
                transport = this.sessions.get(address);
                if (transport == null) {
                    logger.info("Send election command, create transport of address {}", (Object)address);
                    transport = new ReplicationTransportSession(address, this.transportClient);
                    this.sessions.put(address, transport);
                }
            }
        }
        transport.sendCommand(command, timeout, callback);
    }

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
    }
}

