/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.joyqueue.broker.election.DefaultElectionNode;
import org.joyqueue.broker.election.TopicPartitionGroup;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.toolkit.io.DoubleCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectionMetadata
extends DoubleCopy {
    private static Logger logger = LoggerFactory.getLogger(ElectionMetadata.class);
    private int version = 1;
    private PartitionGroup.ElectType electType;
    private Collection<DefaultElectionNode> allNodes;
    private Set<Integer> learners = new HashSet<Integer>();
    private int localNodeId = -1;
    private int leaderId = -1;
    private int votedFor = -1;
    private int currentTerm = 0;
    private static int MAX_LENGTH = 10240;

    public ElectionMetadata(File file) throws IOException {
        super(file, MAX_LENGTH);
    }

    protected String getName() {
        return "electionMetadata";
    }

    protected byte[] serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(MAX_LENGTH);
        this.serializeString(byteBuffer, "version:");
        this.serializeString(byteBuffer, Integer.valueOf(this.version).toString());
        this.serializeString(byteBuffer, "electType:");
        this.serializeString(byteBuffer, String.valueOf(this.electType.type()));
        this.serializeString(byteBuffer, JSON.toJSONString(this.allNodes));
        this.serializeString(byteBuffer, JSON.toJSONString(this.learners));
        this.serializeString(byteBuffer, "localNodeId:");
        this.serializeString(byteBuffer, Integer.valueOf(this.localNodeId).toString());
        this.serializeString(byteBuffer, "leaderId:");
        this.serializeString(byteBuffer, Integer.valueOf(this.leaderId).toString());
        this.serializeString(byteBuffer, "voteFor:");
        this.serializeString(byteBuffer, Integer.valueOf(this.votedFor).toString());
        this.serializeString(byteBuffer, "currentTerm:");
        this.serializeString(byteBuffer, Integer.valueOf(this.currentTerm).toString());
        this.serializeString(byteBuffer, "-end");
        logger.info("Metadata serialize length is {}", (Object)byteBuffer.position());
        byte[] bytes = new byte[byteBuffer.position()];
        byteBuffer.flip();
        byteBuffer.get(bytes);
        return bytes;
    }

    private void serializeString(ByteBuffer byteBuffer, String value) {
        byte[] valueBytes = value.getBytes();
        byteBuffer.putInt(valueBytes.length);
        byteBuffer.put(valueBytes);
    }

    protected void parse(byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        this.parseString(byteBuffer);
        this.version = Integer.valueOf(this.parseString(byteBuffer));
        this.parseString(byteBuffer);
        this.electType = PartitionGroup.ElectType.valueOf((int)Integer.valueOf(this.parseString(byteBuffer)));
        String allNodesStr = this.parseString(byteBuffer);
        this.allNodes = (Collection)JSON.parseObject((String)allNodesStr, (TypeReference)new TypeReference<Collection<DefaultElectionNode>>(){}, (Feature[])new Feature[0]);
        String learnersStr = this.parseString(byteBuffer);
        this.learners = (Set)JSON.parseObject((String)learnersStr, (TypeReference)new TypeReference<Set<Integer>>(){}, (Feature[])new Feature[0]);
        this.parseString(byteBuffer);
        this.localNodeId = Integer.valueOf(this.parseString(byteBuffer));
        this.parseString(byteBuffer);
        this.leaderId = Integer.valueOf(this.parseString(byteBuffer));
        this.parseString(byteBuffer);
        this.votedFor = Integer.valueOf(this.parseString(byteBuffer));
        this.parseString(byteBuffer);
        this.currentTerm = Integer.valueOf(this.parseString(byteBuffer));
    }

    private String parseString(ByteBuffer byteBuffer) {
        int length = byteBuffer.getInt();
        byte[] bytes = new byte[length];
        byteBuffer.get(bytes);
        return new String(bytes);
    }

    public PartitionGroup.ElectType getElectType() {
        return this.electType;
    }

    public void setElectType(PartitionGroup.ElectType electType) {
        this.electType = electType;
    }

    public Collection<DefaultElectionNode> getAllNodes() {
        return this.allNodes;
    }

    public void setAllNodes(Collection<DefaultElectionNode> allNodes) {
        this.allNodes = allNodes;
    }

    public Set<Integer> getLearners() {
        return this.learners;
    }

    public void setLearners(Set<Integer> learners) {
        this.learners = learners;
    }

    public int getLeaderId() {
        return this.leaderId;
    }

    public void setLeaderId(int leaderId) {
        this.leaderId = leaderId;
    }

    public int getLocalNodeId() {
        return this.localNodeId;
    }

    public void setLocalNodeId(int localNodeId) {
        this.localNodeId = localNodeId;
    }

    public void setVotedFor(int votedFor) {
        this.votedFor = votedFor;
    }

    public int getVotedFor() {
        return this.votedFor;
    }

    public int getCurrentTerm() {
        return this.currentTerm;
    }

    public void setCurrentTerm(int currentTerm) {
        this.currentTerm = currentTerm;
    }

    public String toString() {
        return new StringBuffer("ElectionMetadata{").append("electType:").append(this.electType).append(", allNodes:").append(JSON.toJSONString(this.allNodes)).append(", learners:").append(JSON.toJSONString(this.learners)).append(", localId:").append(this.localNodeId).append(", currentTerm:").append(this.currentTerm).append(", votedFor:").append(this.votedFor).append("}").toString();
    }

    public static class Build {
        private ElectionMetadata metadata;

        private Build(String fileName) throws IOException {
            this.metadata = new ElectionMetadata(new File(fileName));
        }

        public static Build create(String path, TopicPartitionGroup topicPartitionGroup) throws IOException {
            String fileName = path + File.separator + topicPartitionGroup.getTopic().replace(File.separatorChar, '@') + File.separator + topicPartitionGroup.getPartitionGroupId();
            return new Build(fileName);
        }

        public Build electionType(PartitionGroup.ElectType electType) {
            this.metadata.setElectType(electType);
            return this;
        }

        public Build allNodes(Collection<DefaultElectionNode> allNodes) {
            this.metadata.setAllNodes(allNodes);
            return this;
        }

        public Build learners(Set<Integer> learners) {
            this.metadata.setLearners(learners);
            return this;
        }

        public Build localNode(int localNode) {
            this.metadata.setLocalNodeId(localNode);
            return this;
        }

        public Build leaderId(int leaderId) {
            this.metadata.setLeaderId(leaderId);
            return this;
        }

        public Build currentTerm(int currentTerm) {
            this.metadata.setCurrentTerm(currentTerm);
            return this;
        }

        public Build votedFor(int votedFor) {
            this.metadata.setVotedFor(votedFor);
            return this;
        }

        public ElectionMetadata build() {
            return this.metadata;
        }
    }
}

