/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.election.DefaultElectionNode;
import org.joyqueue.broker.election.ElectionManager;
import org.joyqueue.broker.election.ElectionMetadata;
import org.joyqueue.broker.election.TopicPartitionGroup;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectionMetadataManager {
    private static Logger logger = LoggerFactory.getLogger(ElectionMetadataManager.class);
    private String path;
    private Map<TopicPartitionGroup, ElectionMetadata> metadataMap = new ConcurrentHashMap<TopicPartitionGroup, ElectionMetadata>();

    public ElectionMetadataManager(String path) {
        this.path = path;
    }

    void recover(ElectionManager electionManager) {
        try {
            this.recoverMetadata();
            this.restoreLeaderElections(electionManager);
        }
        catch (Exception e) {
            logger.info("Recover election metadata fail", (Throwable)e);
        }
    }

    private void recoverMetadata() throws IOException {
        boolean ret;
        File root = new File(this.path);
        if (!root.exists() && !(ret = root.mkdir())) {
            logger.info("Recover election metadata create dir {} fail", (Object)root.getAbsoluteFile());
            throw new IOException("Delete file " + root.getAbsoluteFile() + " fail");
        }
        File[] topicDirs = root.listFiles();
        if (topicDirs == null) {
            return;
        }
        for (File topicDir : topicDirs) {
            if (!topicDir.isDirectory()) continue;
            String topic = topicDir.getName().replace('@', File.separatorChar);
            File[] pgsFiles = topicDir.listFiles();
            if (pgsFiles == null) continue;
            for (File filePg : pgsFiles) {
                if (!StringUtils.isNumeric((CharSequence)filePg.getName())) {
                    logger.warn("Recover election metadata of topic {} fail, pg is {}", (Object)topic, (Object)filePg.getName());
                    continue;
                }
                TopicPartitionGroup partitionGroup = new TopicPartitionGroup(topic, Integer.valueOf(filePg.getName()));
                try (ElectionMetadata metadata = ElectionMetadata.Build.create(this.path, partitionGroup).build();){
                    metadata.recover();
                    this.metadataMap.put(partitionGroup, metadata);
                }
                catch (Exception e) {
                    logger.info("Create election metadata fail", (Throwable)e);
                }
            }
        }
    }

    Map<TopicPartitionGroup, ElectionMetadata> getAllElectionMetadata() {
        return this.metadataMap;
    }

    ElectionMetadata getElectionMetadata(TopicPartitionGroup topicPartitionGroup) {
        return this.metadataMap.get(topicPartitionGroup);
    }

    synchronized void updateElectionMetadata(TopicPartitionGroup topicPartitionGroup, ElectionMetadata metadata) {
        this.metadataMap.put(topicPartitionGroup, metadata);
        metadata.flush();
    }

    synchronized void removeElectionMetadata(TopicPartitionGroup topicPartitionGroup) {
        try {
            boolean ret;
            this.metadataMap.remove(topicPartitionGroup);
            File topicDir = new File(this.path + File.separator + topicPartitionGroup.getTopic().replace(File.separatorChar, '@'));
            File[] pgFiles = topicDir.listFiles();
            if (pgFiles == null) {
                logger.info("Remove election metadata of {} no file", (Object)topicPartitionGroup);
                return;
            }
            for (File pgFile : pgFiles) {
                boolean ret2;
                if (Integer.valueOf(pgFile.getName()).intValue() != topicPartitionGroup.getPartitionGroupId() || (ret2 = pgFile.delete())) continue;
                logger.info("Remove election metadata, delete file {} fail", (Object)pgFile.getAbsoluteFile());
            }
            pgFiles = topicDir.listFiles();
            if (!(pgFiles != null && pgFiles.length != 0 || (ret = topicDir.delete()))) {
                logger.info("Remove election metadata, delete dir {} fail", (Object)topicDir.getAbsoluteFile());
            }
        }
        catch (Exception e) {
            logger.error("Remove election metadata of {} fail", (Object)topicPartitionGroup, (Object)e);
        }
    }

    private synchronized void clearElectionMetadata() {
        this.metadataMap.clear();
        File path = new File(this.path);
        boolean ret = path.delete();
        if (!ret) {
            logger.info("Clear election metadata, delete dir {} fail", (Object)path.getAbsoluteFile());
        }
    }

    private synchronized void restoreLeaderElections(ElectionManager electionManager) {
        for (TopicPartitionGroup topicPartitionGroup : this.metadataMap.keySet()) {
            try {
                electionManager.restoreLeaderElection(topicPartitionGroup, this.metadataMap.get(topicPartitionGroup));
            }
            catch (Exception e) {
                logger.warn("Restore leader election fail", (Throwable)e);
            }
        }
    }

    synchronized String describe() {
        return JSON.toJSONString(this.metadataMap);
    }

    synchronized String describe(String topic, int partitionGroup) {
        return JSON.toJSONString((Object)((Object)this.metadataMap.get(new TopicPartitionGroup(topic, partitionGroup))));
    }

    private ElectionMetadata generateMetadataFromPartitionGroup(String topic, PartitionGroup partitionGroup, int localBrokerId) throws IOException {
        return ElectionMetadata.Build.create(this.path, new TopicPartitionGroup(topic, partitionGroup.getGroup())).electionType(partitionGroup.getElectType()).leaderId(partitionGroup.getLeader()).learners(partitionGroup.getLearners()).localNode(localBrokerId).currentTerm(partitionGroup.getTerm()).allNodes(partitionGroup.getBrokers().values().stream().map(broker -> new DefaultElectionNode(broker.getIp() + ":" + broker.getBackEndPort(), broker.getId())).collect(Collectors.toList())).build();
    }

    synchronized void syncElectionMetadataFromNameService(ClusterManager clusterManager) {
        this.clearElectionMetadata();
        Map topicConfigs = clusterManager.getNameService().getTopicConfigByBroker(clusterManager.getBrokerId());
        for (TopicConfig topicConfig : topicConfigs.values()) {
            topicConfig.getPartitionGroups().values().stream().filter(pg -> pg.getReplicas().contains(clusterManager.getBrokerId())).forEach(pg -> {
                try (ElectionMetadata metadata = this.generateMetadataFromPartitionGroup(topicConfig.getName().getFullName(), (PartitionGroup)pg, clusterManager.getBrokerId());){
                    this.updateElectionMetadata(new TopicPartitionGroup(topicConfig.getName().getFullName(), pg.getGroup()), metadata);
                }
                catch (Exception e) {
                    logger.info("Sync election metadata of topic {} pg {} from name service fail", new Object[]{pg.getTopic(), pg.getGroup(), e});
                }
            });
        }
    }

    synchronized void updateTerm(String topic, int partitionGroup, int term) {
        ElectionMetadata metadata = this.metadataMap.get(new TopicPartitionGroup(topic, partitionGroup));
        metadata.setCurrentTerm(term);
        metadata.flush();
    }

    public void close() {
        this.metadataMap.clear();
    }
}

