/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election;

import java.util.Collection;
import java.util.List;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.election.DefaultElectionNode;
import org.joyqueue.broker.election.ElectionConfig;
import org.joyqueue.broker.election.ElectionEvent;
import org.joyqueue.broker.election.ElectionManager;
import org.joyqueue.broker.election.ElectionMetadata;
import org.joyqueue.broker.election.ElectionMetadataManager;
import org.joyqueue.broker.election.LeaderElection;
import org.joyqueue.broker.election.TopicPartitionGroup;
import org.joyqueue.broker.election.command.AppendEntriesRequest;
import org.joyqueue.broker.election.command.AppendEntriesResponse;
import org.joyqueue.broker.replication.ReplicaGroup;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.store.replication.ReplicableStore;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixLeaderElection
extends LeaderElection {
    private static Logger logger = LoggerFactory.getLogger(FixLeaderElection.class);
    private List<DefaultElectionNode> allNodes;

    public FixLeaderElection(TopicPartitionGroup topicPartitionGroup, ElectionConfig electionConfig, ElectionManager electionManager, ClusterManager clusterManager, ElectionMetadataManager metadataManager, ReplicableStore replicableStore, ReplicaGroup replicaGroup, EventBus<ElectionEvent> electionEventManager, int leaderId, int localNodeId, List<DefaultElectionNode> allNodes) {
        this.topicPartitionGroup = topicPartitionGroup;
        this.electionConfig = electionConfig;
        this.electionManager = electionManager;
        this.clusterManager = clusterManager;
        this.electionMetadataManager = metadataManager;
        this.replicableStore = replicableStore;
        this.replicaGroup = replicaGroup;
        this.electionEventManager = electionEventManager;
        this.leaderId = leaderId;
        this.localNodeId = localNodeId;
        this.allNodes = allNodes;
    }

    public void doStart() throws Exception {
        super.doStart();
        if (this.leaderId == this.localNodeId) {
            this.becomeLeader();
        } else {
            this.becomeFollower();
        }
        this.updateElectionMetadata();
        this.electionEventManager.add((Object)new ElectionEvent(ElectionEvent.Type.LEADER_FOUND, 0, this.leaderId, this.topicPartitionGroup));
    }

    public void doStop() {
        this.replicaGroup.stop();
        super.doStop();
    }

    @Override
    public Collection<DefaultElectionNode> getAllNodes() {
        return this.allNodes;
    }

    @Override
    public void setLeaderId(int leaderId) {
        if (leaderId != this.leaderId && this.leaderId != -1) {
            if (leaderId == this.localNodeId) {
                this.becomeLeader();
            } else {
                this.becomeFollower();
            }
            this.updateElectionMetadata();
            this.electionEventManager.add((Object)new ElectionEvent(ElectionEvent.Type.LEADER_FOUND, 0, leaderId, this.topicPartitionGroup));
        } else {
            this.leaderId = leaderId;
        }
    }

    private void updateElectionMetadata() {
        try (ElectionMetadata metadata = ElectionMetadata.Build.create(this.electionConfig.getMetadataPath(), this.topicPartitionGroup).electionType(PartitionGroup.ElectType.fix).allNodes(this.allNodes).leaderId(this.leaderId).localNode(this.localNodeId).build();){
            this.electionMetadataManager.updateElectionMetadata(this.topicPartitionGroup, metadata);
        }
        catch (Exception e) {
            logger.warn("Partition group {}/node {} update election metadata fail", new Object[]{this.topicPartitionGroup, this.localNodeId, e});
        }
    }

    private void becomeLeader() {
        this.replicaGroup.becomeLeader(0, this.leaderId);
        try {
            if (!this.replicableStore.serviceStatus()) {
                this.replicableStore.enable();
            }
        }
        catch (Exception e) {
            logger.info("Partition group {}/node {} enable store fail, exception is {}", new Object[]{this.topicPartitionGroup, this.leaderId, e});
        }
    }

    private void becomeFollower() {
        this.replicaGroup.becomeFollower(0, this.leaderId);
        try {
            if (this.replicableStore.serviceStatus()) {
                this.replicableStore.disable();
            }
        }
        catch (Exception e) {
            logger.info("Partition group {}/node {} disable store fail, exception is {}", new Object[]{this.topicPartitionGroup, this.leaderId, e});
        }
    }

    @Override
    public Command handleAppendEntriesRequest(AppendEntriesRequest request) {
        if (!this.isStarted()) {
            logger.warn("Partition group{}/node{} receive append entries request, election not started", (Object)this.topicPartitionGroup, (Object)this.localNodeId);
            return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -45), (Object)new AppendEntriesResponse.Build().success(false).build());
        }
        logger.debug("Partition group{}/node {} receive append entries request from {}", new Object[]{this.topicPartitionGroup, this.localNodeId, request.getLeaderId()});
        return this.replicaGroup.appendEntries(request);
    }
}

