/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election;

import java.util.Collection;
import java.util.HashSet;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.election.DefaultElectionNode;
import org.joyqueue.broker.election.ElectionConfig;
import org.joyqueue.broker.election.ElectionEvent;
import org.joyqueue.broker.election.ElectionException;
import org.joyqueue.broker.election.ElectionManager;
import org.joyqueue.broker.election.ElectionMetadataManager;
import org.joyqueue.broker.election.TopicPartitionGroup;
import org.joyqueue.broker.election.command.AppendEntriesRequest;
import org.joyqueue.broker.replication.ReplicaGroup;
import org.joyqueue.domain.TopicName;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.store.replication.ReplicableStore;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LeaderElection
extends Service {
    private static Logger logger = LoggerFactory.getLogger(LeaderElection.class);
    protected ElectionConfig electionConfig;
    protected TopicPartitionGroup topicPartitionGroup;
    protected ElectionManager electionManager;
    protected ClusterManager clusterManager;
    protected int leaderId = -1;
    protected int localNodeId = -1;
    protected EventBus<ElectionEvent> electionEventManager;
    protected ElectionMetadataManager electionMetadataManager;
    protected ReplicaGroup replicaGroup;
    protected ReplicableStore replicableStore;

    public abstract Collection<DefaultElectionNode> getAllNodes();

    public int getLeaderId() {
        return this.leaderId;
    }

    public abstract void setLeaderId(int var1) throws Exception;

    public void addNode(DefaultElectionNode node) throws ElectionException {
        this.replicaGroup.addNode(node);
    }

    public void removeNode(int brokerId) {
        this.replicaGroup.removeNode(brokerId);
    }

    public boolean isLeader() {
        return this.leaderId == this.localNodeId;
    }

    public ReplicaGroup getReplicaGroup() {
        return this.replicaGroup;
    }

    public TopicPartitionGroup getTopicPartitionGroup() {
        return this.topicPartitionGroup;
    }

    void updateMetadata(int leaderId, int term) {
        HashSet<Integer> isrId = new HashSet<Integer>();
        long startTime = SystemClock.now();
        try {
            this.clusterManager.leaderReport(TopicName.parse((String)this.topicPartitionGroup.getTopic()), this.topicPartitionGroup.getPartitionGroupId(), leaderId, isrId, term);
        }
        catch (Exception e) {
            logger.warn("Partition group {}/node {} report leader fail", new Object[]{this.topicPartitionGroup, this.localNodeId, e});
        }
        logger.info("Leader report, topic is {}, group id is {}, leader is {}, term is {}, elapse {} ms", new Object[]{this.topicPartitionGroup.getTopic(), this.topicPartitionGroup.getPartitionGroupId(), leaderId, term, SystemClock.now() - startTime});
    }

    public abstract Command handleAppendEntriesRequest(AppendEntriesRequest var1);

    public void stepDown(int term) {
    }

    public int getLocalNodeId() {
        return this.localNodeId;
    }
}

