/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.election.DefaultElectionNode;
import org.joyqueue.broker.election.ElectionConfig;
import org.joyqueue.broker.election.ElectionEvent;
import org.joyqueue.broker.election.ElectionException;
import org.joyqueue.broker.election.ElectionManager;
import org.joyqueue.broker.election.ElectionMetadata;
import org.joyqueue.broker.election.ElectionMetadataManager;
import org.joyqueue.broker.election.ElectionNode;
import org.joyqueue.broker.election.LeaderElection;
import org.joyqueue.broker.election.TopicPartitionGroup;
import org.joyqueue.broker.election.command.AppendEntriesRequest;
import org.joyqueue.broker.election.command.AppendEntriesResponse;
import org.joyqueue.broker.election.command.TimeoutNowRequest;
import org.joyqueue.broker.election.command.TimeoutNowResponse;
import org.joyqueue.broker.election.command.VoteRequest;
import org.joyqueue.broker.election.command.VoteResponse;
import org.joyqueue.broker.replication.ReplicaGroup;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.store.replication.ReplicableStore;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftLeaderElection
extends LeaderElection {
    private final int INVALID_VOTE_FOR = -1;
    private static Logger logger = LoggerFactory.getLogger(RaftLeaderElection.class);
    private Map<Integer, DefaultElectionNode> allNodes = new ConcurrentHashMap<Integer, DefaultElectionNode>();
    private ElectionNode localNode;
    private Set<Integer> learners;
    private int currentTerm;
    private int votedFor = -1;
    private int transferee = -1;
    private ScheduledExecutorService electionTimerExecutor;
    private ScheduledFuture electionTimerFuture;
    private ScheduledFuture voteTimerFuture;
    private ScheduledFuture heartbeatTimerFuture;
    private ScheduledFuture transferLeaderTimerFuture;
    private ScheduledFuture reportLeaderFuture;
    private ScheduledFuture leaderRebalanceFuture;
    private ExecutorService electionExecutor;
    private long lastRebalanceTime;

    RaftLeaderElection(TopicPartitionGroup topicPartitionGroup, ElectionConfig electionConfig, ElectionManager electionManager, ClusterManager clusterManager, ElectionMetadataManager metadataManager, ReplicableStore replicableStore, ReplicaGroup replicaGroup, ScheduledExecutorService electionTimerExecutor, ExecutorService electionExecutor, EventBus<ElectionEvent> electionEventManager, int localNodeId, List<DefaultElectionNode> allNodes, Set<Integer> learners) {
        this.topicPartitionGroup = topicPartitionGroup;
        this.electionConfig = electionConfig;
        this.electionManager = electionManager;
        this.clusterManager = clusterManager;
        this.electionMetadataManager = metadataManager;
        this.replicableStore = replicableStore;
        this.replicaGroup = replicaGroup;
        this.electionTimerExecutor = electionTimerExecutor;
        this.electionExecutor = electionExecutor;
        this.electionEventManager = electionEventManager;
        this.localNodeId = localNodeId;
        this.learners = learners;
        this.setAllNodes(allNodes, learners);
        this.localNode = this.getNode(localNodeId);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ElectionMetadata metadata = this.electionMetadataManager.getElectionMetadata(this.topicPartitionGroup);
        if (metadata != null) {
            this.currentTerm = metadata.getCurrentTerm();
            this.votedFor = metadata.getVotedFor();
        } else {
            this.updateElectionMetadata();
        }
        this.resetElectionTimer();
        this.leaderRebalanceFuture = this.electionTimerExecutor.scheduleAtFixedRate(this::rebalanceLeader, 60 + new Random().nextInt(60), 60L, TimeUnit.SECONDS);
        this.reportLeaderFuture = this.electionTimerExecutor.scheduleAtFixedRate(this::reportLeadership, 60 + new Random().nextInt(60), 60L, TimeUnit.SECONDS);
        logger.info("Raft leader election of {}, local node {}, all node {} started, term is {}, vote for is {}", new Object[]{this.topicPartitionGroup, this.localNode, JSON.toJSONString(this.allNodes), this.currentTerm, this.votedFor});
    }

    protected void doStop() {
        this.cancelElectionTimer();
        this.cancelHeartbeatTimer();
        this.cancelTransferLeaderTimer();
        this.nodeOffline(this.currentTerm);
        this.replicaGroup.stop();
        if (this.leaderRebalanceFuture != null) {
            this.leaderRebalanceFuture.cancel(true);
        }
        if (this.reportLeaderFuture != null) {
            this.reportLeaderFuture.cancel(true);
        }
        super.doStop();
        logger.info("Raft leader election of partition group {}/node {} stoped", (Object)this.topicPartitionGroup, (Object)this.localNode);
    }

    @Override
    public Collection<DefaultElectionNode> getAllNodes() {
        return this.allNodes.values();
    }

    private ElectionNode getNode(int nodeId) {
        return this.allNodes.get(nodeId);
    }

    private Set<Integer> getLearners() {
        return this.learners;
    }

    private void setAllNodes(List<DefaultElectionNode> allNodes, Set<Integer> learners) {
        allNodes.stream().filter(n -> !learners.contains(n.getNodeId())).forEach(n -> {
            n.setState(ElectionNode.State.FOLLOWER);
            n.setVoteGranted(false);
            this.allNodes.put(n.getNodeId(), (DefaultElectionNode)n);
        });
    }

    public ElectionNode.State state() {
        return this.localNode.getState();
    }

    public void state(ElectionNode.State state) {
        this.localNode.setState(state);
    }

    private void updateElectionMetadata() {
        try (ElectionMetadata metadata = ElectionMetadata.Build.create(this.electionConfig.getMetadataPath(), this.topicPartitionGroup).electionType(PartitionGroup.ElectType.raft).allNodes(this.getAllNodes()).learners(this.getLearners()).leaderId(this.leaderId).localNode(this.localNodeId).currentTerm(this.currentTerm).votedFor(this.votedFor).build();){
            logger.info("Partition group {}/node {} update metadata of {}", new Object[]{this.topicPartitionGroup, this.localNode, metadata});
            this.electionMetadataManager.updateElectionMetadata(this.topicPartitionGroup, metadata);
        }
        catch (Exception e) {
            logger.warn("Partition group {}/node {} update election metadata fail", new Object[]{this.topicPartitionGroup, this.localNode, e});
        }
    }

    @Override
    public void addNode(DefaultElectionNode node) throws ElectionException {
        this.allNodes.put(node.getNodeId(), node);
        this.updateElectionMetadata();
        super.addNode(node);
    }

    @Override
    public void removeNode(int nodeId) {
        this.allNodes.remove(nodeId);
        this.updateElectionMetadata();
        super.removeNode(nodeId);
    }

    @Override
    public void setLeaderId(int leaderId) throws Exception {
        if (leaderId != -1 && this.leaderId != -1) {
            this.transferLeadership(leaderId);
        }
    }

    private void transitionTo(ElectionNode.State state) {
        this.localNode.setState(state);
        this.replicaGroup.setState(state);
    }

    private int getLastLogTerm() {
        return this.replicableStore.lastEntryTerm();
    }

    private long getLastLogPosition() {
        return this.replicableStore.rightPosition();
    }

    private synchronized void resetElectionTimer() {
        if (this.electionTimerFuture != null && !this.electionTimerFuture.isDone()) {
            this.electionTimerFuture.cancel(true);
            this.electionTimerFuture = null;
        }
        this.electionTimerFuture = this.electionTimerExecutor.schedule(this::handleElectionTimeout, (long)this.getElectionTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    private synchronized void cancelElectionTimer() {
        if (this.electionTimerFuture != null && !this.electionTimerFuture.isDone()) {
            this.electionTimerFuture.cancel(true);
            this.electionTimerFuture = null;
        }
    }

    private int getElectionTimeoutMs() {
        Random random = new Random();
        return this.electionConfig.getElectionTimeout() + random.nextInt(this.electionConfig.getElectionTimeout());
    }

    private synchronized void resetVoteTimer() {
        if (this.voteTimerFuture != null && !this.voteTimerFuture.isDone()) {
            this.voteTimerFuture.cancel(true);
            this.voteTimerFuture = null;
        }
        this.voteTimerFuture = this.electionTimerExecutor.schedule(this::handleVoteTimeout, (long)this.electionConfig.getVoteTimeout(), TimeUnit.MILLISECONDS);
    }

    private synchronized void cancelVoteTimer() {
        if (this.voteTimerFuture != null && !this.voteTimerFuture.isDone()) {
            this.voteTimerFuture.cancel(true);
            this.voteTimerFuture = null;
        }
    }

    private synchronized void handleElectionTimeout() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Election timeout, election service not start");
        }
        if (this.electionTimerFuture == null) {
            logger.info("Partition group {}/node {} election timeout, timer future is null", (Object)this.topicPartitionGroup, (Object)this.localNode);
        }
        if (this.getAllNodes().size() == 1) {
            this.becomeLeader();
            return;
        }
        if (this.state() != ElectionNode.State.FOLLOWER) {
            logger.info("Partition group {}/node {} election timeout, state is {}", new Object[]{this.topicPartitionGroup, this.localNode, this.state()});
            if (this.state() == ElectionNode.State.LEADER) {
                return;
            }
        }
        logger.info("Partition group {}/node {} election timeout, current term is {}.", new Object[]{this.topicPartitionGroup, this.localNode, this.currentTerm});
        this.leaderId = -1;
        try {
            this.preVote();
        }
        catch (Throwable t) {
            logger.warn("Partition group {}/node {} preVote fail", (Object)this.topicPartitionGroup, (Object)this.localNode);
        }
        this.resetElectionTimer();
    }

    private void preVote() {
        this.localNode.setVoteGranted(true);
        int lastLogTerm = this.getLastLogTerm();
        long lastLogPos = this.getLastLogPosition();
        for (ElectionNode electionNode : this.getAllNodes()) {
            if (electionNode.equals(this.localNode)) continue;
            this.electionExecutor.submit(() -> {
                node.setVoteGranted(false);
                VoteRequest voteRequest = new VoteRequest(this.topicPartitionGroup, this.currentTerm, this.localNodeId, lastLogTerm, lastLogPos, true);
                JoyQueueHeader header = new JoyQueueHeader(Direction.REQUEST, 43);
                Command command = new Command((Header)header, (Object)voteRequest);
                logger.info("Partition group {}/node{} send prevote request to node {}", new Object[]{this.topicPartitionGroup, this.localNode, node});
                try {
                    this.electionManager.sendCommand(node.getAddress(), command, this.electionConfig.getSendCommandTimeout(), new VoteRequestCallback(this.currentTerm, node));
                }
                catch (Exception e) {
                    logger.info("Partition group {}/node{} send pre vote request to node {} fail", new Object[]{this.topicPartitionGroup, this.localNode, node, e});
                }
            });
        }
    }

    private void electSelf() {
        ++this.currentTerm;
        this.transitionTo(ElectionNode.State.CONDIDATE);
        this.leaderId = -1;
        this.votedFor = this.localNode.getNodeId();
        this.localNode.setVoteGranted(true);
        this.nodeOffline(this.currentTerm);
        this.updateElectionMetadata();
        this.electionEventManager.add((Object)new ElectionEvent(ElectionEvent.Type.START_ELECTION, this.currentTerm, -1, this.topicPartitionGroup));
        this.resetVoteTimer();
        int lastLogTerm = this.getLastLogTerm();
        long lastLogPos = this.getLastLogPosition();
        for (ElectionNode electionNode : this.getAllNodes()) {
            if (electionNode.equals(this.localNode)) continue;
            this.electionExecutor.submit(() -> {
                node.setVoteGranted(false);
                VoteRequest voteRequest = new VoteRequest(this.topicPartitionGroup, this.currentTerm, this.localNodeId, lastLogTerm, lastLogPos, false);
                JoyQueueHeader header = new JoyQueueHeader(Direction.REQUEST, 43);
                Command command = new Command((Header)header, (Object)voteRequest);
                logger.info("Partition group {}/node{} send vote request to node {}", new Object[]{this.topicPartitionGroup, this.localNode, node});
                try {
                    this.electionManager.sendCommand(node.getAddress(), command, this.electionConfig.getSendCommandTimeout(), new VoteRequestCallback(this.currentTerm, node));
                }
                catch (Exception e) {
                    logger.info("Partition group {}/node{} send vote request to node {} fail", new Object[]{this.topicPartitionGroup, this.localNode, node, e});
                }
            });
        }
    }

    private synchronized void handleVoteTimeout() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Vote timeout, election service not start");
        }
        if (this.voteTimerFuture == null) {
            logger.info("Partition group {}/node {} vote timeout, timer future is null", (Object)this.topicPartitionGroup, (Object)this.localNode);
        }
        logger.info("Partition group {}/node {} vote timeout, term is {}, state is {}", new Object[]{this.topicPartitionGroup, this.localNode, this.currentTerm, this.state()});
        if (this.state() != ElectionNode.State.CONDIDATE) {
            return;
        }
        this.stepDown(this.currentTerm);
    }

    public synchronized Command handleVoteRequest(VoteRequest voteRequest) {
        boolean voteGranted = false;
        if (voteRequest == null) {
            logger.warn("Partition group {}/node{} receive vote request, request is null", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return null;
        }
        if (!this.isStarted()) {
            logger.warn("Partition group {}/node{} receive vote request, election not started", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return null;
        }
        if (!this.allNodes.containsKey(voteRequest.getCandidateId())) {
            logger.warn("Partition group {}/node{} receive pre vote request from unknown node {}", new Object[]{this.topicPartitionGroup, this.localNode, voteRequest.getCandidateId()});
            return null;
        }
        if (this.currentTerm > voteRequest.getTerm()) {
            logger.info("Partition group {}/node{} receive vote request from {}, currentTerm {} is great than request term {}", new Object[]{this.topicPartitionGroup, this.localNode, voteRequest.getCandidateId(), this.currentTerm, voteRequest.getTerm()});
            return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -43), (Object)new VoteResponse(this.currentTerm, voteRequest.getCandidateId(), this.localNodeId, voteGranted));
        }
        if (this.currentTerm < voteRequest.getTerm()) {
            logger.info("Partition group {}/node{} receive vote request from {}, currentTerm {} is less than request term {}", new Object[]{this.topicPartitionGroup, this.localNode, voteRequest.getCandidateId(), this.currentTerm, voteRequest.getTerm()});
            this.stepDown(voteRequest.getTerm());
        }
        int lastLogTerm = this.getLastLogTerm();
        long lastLogPos = this.getLastLogPosition();
        logger.info("Partition group {}/node{} receive vote request from {}, lastLogTerm is {}, lastLogIndex is {}, request lastLogTerm is {}, request lastLogIndex is {}, voteFor is {}, request candidateId is {}", new Object[]{this.topicPartitionGroup, this.localNode, voteRequest.getCandidateId(), lastLogTerm, lastLogPos, voteRequest.getLastLogTerm(), voteRequest.getLastLogPos(), this.votedFor, voteRequest.getCandidateId()});
        if ((lastLogTerm < voteRequest.getLastLogTerm() || lastLogTerm == voteRequest.getLastLogTerm() && lastLogPos <= voteRequest.getLastLogPos()) && (this.votedFor == -1 || this.votedFor == voteRequest.getCandidateId())) {
            this.votedFor = voteRequest.getCandidateId();
            this.updateElectionMetadata();
            voteGranted = true;
            this.stepDown(voteRequest.getTerm());
        }
        return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -43), (Object)new VoteResponse(this.currentTerm, voteRequest.getCandidateId(), this.localNodeId, voteGranted));
    }

    public synchronized Command handlePreVoteRequest(VoteRequest voteRequest) {
        boolean voteGranted = false;
        if (voteRequest == null) {
            logger.warn("Partition group {}/node{} receive pre vote request, request is null", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return null;
        }
        if (!this.isStarted()) {
            logger.warn("Partition group {}/node{} receive pre vote request, election not started", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return null;
        }
        if (!this.allNodes.containsKey(voteRequest.getCandidateId())) {
            logger.warn("Partition group {}/node{} receive pre vote request from unknown node {}", new Object[]{this.topicPartitionGroup, this.localNode, voteRequest.getCandidateId()});
            return null;
        }
        if (this.currentTerm > voteRequest.getTerm()) {
            logger.info("Partition group {}/node{} receive pre vote request from {}, currentTerm {} is great than request term {}", new Object[]{this.topicPartitionGroup, this.localNode, voteRequest.getCandidateId(), this.currentTerm, voteRequest.getTerm()});
            return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -43), (Object)new VoteResponse(this.currentTerm, voteRequest.getCandidateId(), this.localNodeId, voteGranted));
        }
        int lastLogTerm = this.getLastLogTerm();
        long lastLogPos = this.getLastLogPosition();
        logger.info("Partition group {}/node{} receive pre vote request from {}, lastLogTerm is {}, lastLogIndex is {}, request lastLogTerm is {}, request lastLogIndex is {}, voteFor is {}, request term is {}", new Object[]{this.topicPartitionGroup, this.localNode, voteRequest.getCandidateId(), lastLogTerm, lastLogPos, voteRequest.getLastLogTerm(), voteRequest.getLastLogPos(), this.votedFor, voteRequest.getTerm()});
        if (lastLogTerm < voteRequest.getLastLogTerm() || lastLogTerm == voteRequest.getLastLogTerm() && lastLogPos <= voteRequest.getLastLogPos()) {
            voteGranted = true;
        }
        return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -43), (Object)new VoteResponse(this.currentTerm, voteRequest.getCandidateId(), this.localNodeId, voteGranted));
    }

    private synchronized void handleVoteResponse(Command command) {
        if (command == null) {
            logger.warn("Partition group {}/node{} receive vote response is null", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return;
        }
        if (!(command.getPayload() instanceof VoteResponse)) {
            logger.info("Partition group {}/node{} receive vote response object type error", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return;
        }
        VoteResponse voteResponse = (VoteResponse)((Object)command.getPayload());
        logger.info("Partition group {}/node{} receive vote response from {}, term is {}, vote candidateId is {}, vote granted is {}", new Object[]{this.topicPartitionGroup, this.localNode, voteResponse.getVoteNodeId(), voteResponse.getTerm(), voteResponse.getCandidateId(), voteResponse.isVoteGranted()});
        if (this.state() != ElectionNode.State.CONDIDATE) {
            logger.warn("Partition group {}/node{} receive vote response, local node state is {}", new Object[]{this.topicPartitionGroup, this.localNode, this.state()});
            return;
        }
        if (voteResponse.getTerm() > this.currentTerm) {
            logger.info("Partition group {}/node{} receive vote response, current term is {}, response term is {}", new Object[]{this.topicPartitionGroup, this.localNode, this.currentTerm, voteResponse.getTerm()});
            this.stepDown(voteResponse.getTerm());
        }
        ElectionNode voteNode = this.getNode(voteResponse.getVoteNodeId());
        voteNode.setVoteGranted(voteResponse.isVoteGranted());
        int voteGranted = 0;
        for (ElectionNode electionNode : this.getAllNodes()) {
            logger.info("Partition group {}/node {} voteGranted is {}", new Object[]{this.topicPartitionGroup, electionNode, electionNode.isVoteGranted()});
            if (!electionNode.isVoteGranted()) continue;
            ++voteGranted;
        }
        logger.info("Partition group {}/node {} receive {} votes", new Object[]{this.topicPartitionGroup, this.localNode, voteGranted});
        if (voteGranted > this.getAllNodes().size() / 2) {
            logger.info("Partition group {}/node{} receive {} votes, become leader term is {}.", new Object[]{this.topicPartitionGroup, this.localNode, voteGranted, this.currentTerm});
            this.becomeLeader();
        }
    }

    private synchronized void handlePreVoteResponse(Command command) {
        if (command == null) {
            logger.warn("Partition group {}/node{} receive pre vote response is null", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return;
        }
        if (!(command.getPayload() instanceof VoteResponse)) {
            logger.info("Partition group {}/node{} receive pre vote response object type error", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return;
        }
        VoteResponse voteResponse = (VoteResponse)((Object)command.getPayload());
        logger.info("Partition group {}/node{} receive pre vote response from {}, term is {}, vote candidateId is {}, vote granted is {}", new Object[]{this.topicPartitionGroup, this.localNode, voteResponse.getVoteNodeId(), voteResponse.getTerm(), voteResponse.getCandidateId(), voteResponse.isVoteGranted()});
        if (this.state() != ElectionNode.State.FOLLOWER) {
            logger.info("Partition group {}/node {} receive pre vote response, state is {}", new Object[]{this.topicPartitionGroup, this.localNode, this.state()});
            return;
        }
        if (voteResponse.getTerm() > this.currentTerm) {
            logger.info("Partition group {}/node{} receive pre vote response, current term is {}, response term is {}", new Object[]{this.topicPartitionGroup, this.localNode, this.currentTerm, voteResponse.getTerm()});
            this.stepDown(voteResponse.getTerm());
            return;
        }
        ElectionNode voteNode = this.getNode(voteResponse.getVoteNodeId());
        voteNode.setVoteGranted(voteResponse.isVoteGranted());
        int voteGranted = 0;
        for (ElectionNode electionNode : this.getAllNodes()) {
            logger.info("Partition group {}/node {} pre vote voteGranted is {}", new Object[]{this.topicPartitionGroup, electionNode, electionNode.isVoteGranted()});
            if (!electionNode.isVoteGranted()) continue;
            ++voteGranted;
        }
        logger.info("Partition group {}/node {} receive {} pre votes", new Object[]{this.topicPartitionGroup, this.localNode, voteGranted});
        if (voteGranted > this.getAllNodes().size() / 2) {
            logger.info("Partition group {}/node{} receive {} pre votes, start vote, term is {}.", new Object[]{this.topicPartitionGroup, this.localNode, voteGranted, this.currentTerm});
            this.electSelf();
        }
    }

    @Override
    public synchronized Command handleAppendEntriesRequest(AppendEntriesRequest request) {
        if (!this.isStarted()) {
            logger.warn("Partition group {}/node{} receive append entries request, election not started", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return null;
        }
        logger.debug("Partition group {}/node {} receive append entries request, currentTerm is {}, request term is {}, leaderId is {}", new Object[]{this.topicPartitionGroup, this.localNode, this.currentTerm, request.getTerm(), request.getLeaderId()});
        if (!this.allNodes.containsKey(request.getLeaderId())) {
            logger.warn("Partition group {}/node{} receive append entries request from unknown node {}", new Object[]{this.topicPartitionGroup, this.localNode, request.getLeaderId()});
            return null;
        }
        if (request.getTerm() < this.currentTerm) {
            logger.info("Partition group {}/node {} receive append entries request from {}, current term {} is bigger than request term {}, length is {}", new Object[]{this.topicPartitionGroup, this.localNode, this.currentTerm, request.getLeaderId(), request.getTerm(), request.getEntriesLength()});
            return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -45), (Object)new AppendEntriesResponse.Build().success(false).term(this.currentTerm).nextPosition(request.getStartPosition()).build());
        }
        this.checkStepDown(request.getTerm(), request.getLeaderId());
        this.resetElectionTimer();
        if (request.getEntries() != null && request.getEntries().hasRemaining()) {
            return this.replicaGroup.appendEntries(request);
        }
        return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -45), (Object)new AppendEntriesResponse.Build().success(true).term(this.currentTerm).nextPosition(request.getStartPosition()).writePosition(this.replicableStore.rightPosition()).build());
    }

    private synchronized void startNewHeartbeat() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Start new heartbeat leader, election service not start");
        }
        if (!this.isLeader() && this.state() != ElectionNode.State.TRANSFERRING) {
            logger.info("Partition group {}/node {} start new heartbeat, state is {}", new Object[]{this.topicPartitionGroup, this.localNode, this.state()});
            return;
        }
        AppendEntriesRequest appendEntriesRequest = AppendEntriesRequest.Build.create().partitionGroup(this.topicPartitionGroup).term(this.currentTerm).leader(this.leaderId).build();
        for (ElectionNode electionNode : this.getAllNodes()) {
            if (electionNode.equals(this.localNode)) continue;
            try {
                this.electionExecutor.submit(() -> {
                    JoyQueueHeader header = new JoyQueueHeader(Direction.REQUEST, 45);
                    Command command = new Command((Header)header, (Object)appendEntriesRequest);
                    logger.debug("Partition group {}/node{} send heartbeat request {} to {}", new Object[]{this.topicPartitionGroup, this.localNode, appendEntriesRequest, node.getNodeId()});
                    try {
                        this.electionManager.sendCommand(node.getAddress(), command, this.electionConfig.getSendCommandTimeout(), new HeartbeatRequestCallback(node));
                    }
                    catch (Exception e) {
                        logger.warn("Partition group {}/node{} send heartbeat to {} fail", new Object[]{this.topicPartitionGroup, this.localNode, node, e});
                    }
                });
            }
            catch (Exception e) {
                logger.warn("Partition group {}/node {} submit new heartbeat task fail", new Object[]{this.topicPartitionGroup, this.localNode, e});
            }
        }
        this.resetHeartbeatTimer();
    }

    private synchronized void handleHeartbeatResponse(Command command, ElectionNode node) {
        if (command == null) {
            logger.warn("Partition group {}/node{} receive heartbeat response is null", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return;
        }
        if (!(command.getPayload() instanceof AppendEntriesResponse)) {
            logger.info("Partition group {}/node{} receive append entries response object type error", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return;
        }
        AppendEntriesResponse response = (AppendEntriesResponse)((Object)command.getPayload());
        logger.debug("Partition group {}/node{} receive heartbeat response from {}, term is {}", new Object[]{this.topicPartitionGroup, this.localNode, node.getNodeId(), response.getTerm()});
        if (response.getTerm() > this.currentTerm) {
            logger.info("Partition group{}/node{} receive heartbeat response from {}, response term {} is greater than current term {}", new Object[]{this.topicPartitionGroup, this.localNode, node, response.getTerm(), this.currentTerm});
            this.stepDown(response.getTerm());
        }
    }

    private synchronized void cancelHeartbeatTimer() {
        if (this.heartbeatTimerFuture != null && !this.heartbeatTimerFuture.isDone()) {
            this.heartbeatTimerFuture.cancel(true);
            this.heartbeatTimerFuture = null;
        }
    }

    private synchronized void resetHeartbeatTimer() {
        if (this.heartbeatTimerFuture != null && !this.heartbeatTimerFuture.isDone()) {
            this.heartbeatTimerFuture.cancel(true);
            this.heartbeatTimerFuture = null;
        }
        this.heartbeatTimerFuture = this.electionTimerExecutor.schedule(this::startNewHeartbeat, (long)this.electionConfig.getHeartbeatTimeout(), TimeUnit.MILLISECONDS);
    }

    private synchronized void becomeLeader() {
        this.transitionTo(ElectionNode.State.LEADER);
        this.leaderId = this.localNode.getNodeId();
        this.getAllNodes().forEach(node -> {
            if (!node.equals(this.localNode)) {
                node.setState(ElectionNode.State.FOLLOWER);
            }
            node.setVoteGranted(false);
        });
        this.startNewHeartbeat();
        try {
            this.replicaGroup.becomeLeader(this.currentTerm, this.leaderId);
            this.nodeOnline(this.currentTerm);
            this.updateElectionMetadata();
            this.updateMetadata(this.leaderId, this.currentTerm);
            this.electionEventManager.add((Object)new ElectionEvent(ElectionEvent.Type.LEADER_FOUND, this.currentTerm, this.localNode.getNodeId(), this.topicPartitionGroup));
            this.cancelElectionTimer();
            this.cancelVoteTimer();
        }
        catch (Exception e) {
            logger.warn("Partition group {}/node {} as leader fail", new Object[]{this.topicPartitionGroup, this.localNode, e});
        }
    }

    private synchronized void becomeFollower(int leaderId, int term) {
        logger.info("Partition group {}/node{} become follower, leaderId is {}, term is {}", new Object[]{this.topicPartitionGroup, this.localNode, leaderId, term});
        this.transitionTo(ElectionNode.State.FOLLOWER);
        this.leaderId = leaderId;
        this.currentTerm = term;
        this.getAllNodes().forEach(node -> {
            node.setState(node.getNodeId() == leaderId ? ElectionNode.State.LEADER : ElectionNode.State.FOLLOWER);
            node.setVoteGranted(false);
        });
        this.replicaGroup.becomeFollower(this.currentTerm, leaderId);
        this.nodeOffline(term);
        this.updateElectionMetadata();
        this.updateMetadata(leaderId, this.currentTerm);
        this.electionEventManager.add((Object)new ElectionEvent(ElectionEvent.Type.LEADER_FOUND, this.currentTerm, leaderId, this.topicPartitionGroup));
        this.cancelHeartbeatTimer();
    }

    private void checkStepDown(int requestTerm, int requestLeaderId) {
        if (this.currentTerm < requestTerm) {
            logger.info("Partition group {}/node {} receive heartbeat from new leader {} with higher term {}", new Object[]{this.topicPartitionGroup, this.localNode, requestLeaderId, requestTerm});
            this.stepDown(requestTerm);
        } else if (this.state() != ElectionNode.State.FOLLOWER) {
            logger.info("Partition group {}/node {} receive heartbeat from leader {}", new Object[]{this.topicPartitionGroup, this.localNode, requestLeaderId});
            this.stepDown(requestTerm);
        } else if (this.leaderId == -1) {
            logger.info("Partition group {}/node {} receive heartbeat from new leader {}", new Object[]{this.topicPartitionGroup, this.localNode, requestLeaderId});
            this.stepDown(requestTerm);
        } else if (this.leaderId != requestLeaderId) {
            logger.info("Partition group {}/node {} receive heartbeat from another leader {}", new Object[]{this.topicPartitionGroup, this.localNode, this.leaderId});
            this.leaderId = requestLeaderId;
        }
        if (this.leaderId == -1) {
            this.becomeFollower(requestLeaderId, requestTerm);
        }
    }

    @Override
    public synchronized void stepDown(int term) {
        logger.info("Partition group {}/node {} step down, term is {}, current term is {}, vote for is {}", new Object[]{this.topicPartitionGroup, this.localNode, term, this.currentTerm, this.votedFor});
        this.leaderId = -1;
        if (term > this.currentTerm) {
            this.votedFor = -1;
            this.currentTerm = term;
            this.updateElectionMetadata();
        }
        this.nodeOffline(term);
        switch (this.state()) {
            case CONDIDATE: {
                this.cancelElectionTimer();
                this.cancelVoteTimer();
                break;
            }
            case LEADER: {
                this.updateMetadata(this.leaderId, this.currentTerm);
                this.replicaGroup.becomeFollower(this.currentTerm, this.leaderId);
                this.cancelHeartbeatTimer();
                break;
            }
        }
        if (this.transferee != -1) {
            this.transferee = -1;
            this.cancelTransferLeaderTimer();
        }
        this.transitionTo(ElectionNode.State.FOLLOWER);
        this.resetElectionTimer();
    }

    private synchronized void nodeOffline(int term) {
        long startTime = SystemClock.now();
        try {
            if (this.replicableStore.serviceStatus()) {
                this.replicableStore.disable();
            }
            this.replicableStore.term(term);
        }
        catch (Exception e) {
            logger.warn("Partition group {}/node {} disable store fail", new Object[]{this.topicPartitionGroup, this.localNode, e});
        }
        logger.info("Partition group {}/node {} disable store elapse {} ms", new Object[]{this.topicPartitionGroup, this.localNode, SystemClock.now() - startTime});
    }

    private void maybeNodeOnline() {
        if (!this.replicableStore.serviceStatus()) {
            this.replicableStore.enable();
        }
    }

    private synchronized void nodeOnline(int term) {
        long startTime = SystemClock.now();
        try {
            if (!this.replicableStore.serviceStatus()) {
                this.replicableStore.enable();
            }
            this.replicableStore.term(term);
        }
        catch (Exception e) {
            logger.warn("Partition group {}/node {} enable store fail", new Object[]{this.topicPartitionGroup, this.localNode, e});
        }
        logger.info("Partition group {}/node {} enable store elapse {} ms", new Object[]{this.topicPartitionGroup, this.localNode, SystemClock.now() - startTime});
    }

    private synchronized void transferLeadership(int transferee) throws ElectionException {
        if (!this.isLeader()) {
            return;
        }
        if (transferee == this.localNodeId) {
            logger.warn("Partition group {} transfer leader to self {}", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return;
        }
        if (!this.allNodes.containsKey(transferee)) {
            logger.warn("Partition group {} transfer leader transferee {} is incorrect node", (Object)this.topicPartitionGroup, (Object)transferee);
            throw new ElectionException("Transfer leader to incorrection node");
        }
        if (transferee == -1 && (transferee = this.replicaGroup.findTheNextCandidate(this.leaderId)) == -1) {
            logger.warn("Partition group {}/node {} transfer leader, cannot find candidate", (Object)this.topicPartitionGroup, (Object)this.localNode);
            throw new ElectionException("Transfer leader cannot find candidate");
        }
        if (this.transferee != -1) {
            logger.info("Partition group {} transfer leader, anoter transfer still not finish", (Object)this.topicPartitionGroup);
            throw new ElectionException("Transfer leader, another transfer still in process");
        }
        logger.info("Partition group {}/node {} start transfer leader to {}", new Object[]{this.topicPartitionGroup, this.localNode, transferee});
        this.nodeOffline(this.currentTerm);
        this.replicaGroup.transferLeadershipTo(transferee, this.getLastLogPosition());
        this.transferee = transferee;
        this.transitionTo(ElectionNode.State.TRANSFERRING);
        this.transferLeaderTimerFuture = this.electionTimerExecutor.schedule(new TransferLeaderTimerCallback(this.currentTerm), (long)this.electionConfig.getTransferLeaderTimeout(), TimeUnit.MILLISECONDS);
    }

    private synchronized void cancelTransferLeaderTimer() {
        if (this.transferLeaderTimerFuture != null && !this.transferLeaderTimerFuture.isDone()) {
            this.transferLeaderTimerFuture.cancel(true);
            this.transferLeaderTimerFuture = null;
        }
    }

    private synchronized void stopTransferLeadership(int term) {
        logger.info("Partition group {}/node {} transfer leadership time out, term is {}, current term is {}", new Object[]{this.topicPartitionGroup, this.localNode, term, this.currentTerm});
        this.cancelTransferLeaderTimer();
        if (term == this.currentTerm) {
            this.replicaGroup.stopTransferLeadership();
            if (this.state() == ElectionNode.State.TRANSFERRING) {
                this.transitionTo(ElectionNode.State.LEADER);
                this.nodeOnline(this.currentTerm);
                this.transferee = -1;
            }
        }
    }

    public synchronized Command handleTimeoutNowRequest(TimeoutNowRequest request) {
        TimeoutNowResponse response = new TimeoutNowResponse(true, this.currentTerm);
        if (request.getTerm() != this.currentTerm) {
            logger.info("Partition group {}/node {} receive timeout now request, current term {} and request term {} not match", new Object[]{this.topicPartitionGroup, this.localNode, this.currentTerm, request.getTerm()});
            if (request.getTerm() > this.currentTerm) {
                this.stepDown(request.getTerm());
            }
            response.setSuccess(false);
        } else if (this.state() != ElectionNode.State.FOLLOWER) {
            logger.info("Partition group {}/node {} receive timeout now request", (Object)this.topicPartitionGroup, (Object)this.localNode);
            response.setSuccess(false);
        } else {
            response.setTerm(this.currentTerm + 1);
            this.resetElectionTimer();
            this.electSelf();
        }
        JoyQueueHeader header = new JoyQueueHeader(Direction.RESPONSE, -46);
        return new Command((Header)header, (Object)response);
    }

    private void reportLeadership() {
        if (!this.isStarted()) {
            logger.info("Partition group {}/node {} election is close when report leader", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Partition group {}/node {} enable report leader periodically is {}, state is {}", new Object[]{this.topicPartitionGroup, this.localNode, this.electionConfig.enableReportLeaderPeriodically(), this.state()});
        }
        if (this.state() == ElectionNode.State.LEADER) {
            if (this.electionConfig.enableReportLeaderPeriodically()) {
                if (this.electionConfig.enableReportLeaderPeriodicallyForce()) {
                    this.updateMetadata(this.localNodeId, this.currentTerm);
                } else {
                    PartitionGroup partitionGroup;
                    TopicConfig topicConfig = this.clusterManager.getNameService().getTopicConfig(TopicName.parse((String)this.topicPartitionGroup.getTopic()));
                    if (!(topicConfig == null || (partitionGroup = topicConfig.fetchPartitionGroupByGroup(this.topicPartitionGroup.getPartitionGroupId())) == null || partitionGroup.getTerm() == null || partitionGroup.getTerm() != null && partitionGroup.getTerm().equals(this.currentTerm) && partitionGroup.getLeader() != null && partitionGroup.getLeader().equals(this.localNodeId))) {
                        this.updateMetadata(this.localNodeId, this.currentTerm);
                    }
                }
            }
            if (this.electionConfig.enableOnlineNodePeriodically()) {
                this.maybeNodeOnline();
            }
        }
    }

    private int getRecommendLeader() {
        TopicConfig topicConfig = this.clusterManager.getNameService().getTopicConfig(TopicName.parse((String)this.topicPartitionGroup.getTopic()));
        PartitionGroup pg = (PartitionGroup)topicConfig.getPartitionGroups().get(this.topicPartitionGroup.getPartitionGroupId());
        if (pg.getRecLeader() == null) {
            return -1;
        }
        return pg.getRecLeader();
    }

    private boolean shouldRebalanceLeader(int recommendLeader) {
        if (!this.electionConfig.enableRebalanceLeader()) {
            return false;
        }
        if (!this.isLeader()) {
            return false;
        }
        if (this.localNodeId == recommendLeader || recommendLeader == -1 || !this.allNodes.containsKey(recommendLeader)) {
            return false;
        }
        long recommendLeaderLag = this.replicaGroup.lagLength(recommendLeader);
        if (recommendLeaderLag == -1L || this.replicaGroup.lagLength(recommendLeader) > this.electionConfig.getTransferLeaderMinLag()) {
            return false;
        }
        return SystemClock.now() - this.lastRebalanceTime >= (long)this.electionConfig.getMinRebalanceLeaderInterval();
    }

    private void rebalanceLeader() {
        if (!this.isStarted()) {
            logger.info("Partition group {}/node {} election is close when rebalance leader", (Object)this.topicPartitionGroup, (Object)this.localNode);
            return;
        }
        try {
            int recommendLeader = this.getRecommendLeader();
            if (recommendLeader == -1) {
                logger.info("Partition group {}/node {} rebalance leader, recommend leader is -1", (Object)this.topicPartitionGroup, (Object)this.localNode);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Partition group {}/node {} rebalance leader, recommend leader is {}, lag length is {} last rebalance time is {}, enable is {}", new Object[]{this.topicPartitionGroup, this.localNode, recommendLeader, this.replicaGroup.lagLength(recommendLeader), this.lastRebalanceTime, this.electionConfig.enableRebalanceLeader()});
            }
            if (this.shouldRebalanceLeader(recommendLeader)) {
                logger.info("Partition group {}/node {} transfer leadership to {}", new Object[]{this.topicPartitionGroup, this.localNode, recommendLeader});
                this.transferLeadership(recommendLeader);
                this.lastRebalanceTime = SystemClock.now();
            }
        }
        catch (Exception e) {
            logger.warn("Partition group {}/node {} rebalance leader fail", new Object[]{this.topicPartitionGroup, this.localNode, e});
        }
    }

    private class TransferLeaderTimerCallback
    implements Runnable {
        private int term;

        TransferLeaderTimerCallback(int term) {
            this.term = term;
        }

        public int term() {
            return this.term;
        }

        @Override
        public void run() {
            RaftLeaderElection.this.stopTransferLeadership(this.term);
        }
    }

    private class HeartbeatRequestCallback
    implements CommandCallback {
        private ElectionNode node;

        HeartbeatRequestCallback(ElectionNode node) {
            this.node = node;
        }

        public void onSuccess(Command request, Command responseCommand) {
            RaftLeaderElection.this.handleHeartbeatResponse(responseCommand, this.node);
        }

        public void onException(Command request, Throwable cause) {
            logger.info("Partition group {}/node {} send heartbeat request to {} failed", new Object[]{RaftLeaderElection.this.topicPartitionGroup, RaftLeaderElection.this.localNode, this.node, cause});
        }
    }

    private class VoteRequestCallback
    implements CommandCallback {
        private int term;
        private ElectionNode node;

        VoteRequestCallback(int term, ElectionNode node) {
            this.term = term;
            this.node = node;
        }

        public void onSuccess(Command request, Command responseCommand) {
            if (!(request.getPayload() instanceof VoteRequest)) {
                return;
            }
            VoteRequest voteRequest = (VoteRequest)((Object)request.getPayload());
            if (RaftLeaderElection.this.currentTerm != this.term) {
                logger.info("Partition group {}/node {} receive vote response from {}, current term is {}, term is {}", new Object[]{RaftLeaderElection.this.topicPartitionGroup, RaftLeaderElection.this.localNode, this.node.getNodeId(), RaftLeaderElection.this.currentTerm, this.term});
                return;
            }
            try {
                if (voteRequest.isPreVote()) {
                    RaftLeaderElection.this.handlePreVoteResponse(responseCommand);
                } else {
                    RaftLeaderElection.this.handleVoteResponse(responseCommand);
                }
            }
            catch (Throwable t) {
                logger.warn("Partition group {}/node {} handle vote response fail", (Object)RaftLeaderElection.this.topicPartitionGroup, (Object)RaftLeaderElection.this.localNode);
            }
        }

        public void onException(Command request, Throwable cause) {
            logger.info("Partition group {}/node {} send vote request to {} failed", new Object[]{RaftLeaderElection.this.topicPartitionGroup, RaftLeaderElection.this.localNode, this.node.getNodeId(), cause});
        }
    }
}

