/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election.command;

import java.nio.ByteBuffer;
import org.joyqueue.broker.election.TopicPartitionGroup;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.joyqueue.network.transport.command.Releasable;

public class AppendEntriesRequest
extends JoyQueuePayload
implements Releasable {
    private TopicPartitionGroup topicPartitionGroup;
    private int term;
    private int leaderId;
    private long prevPosition;
    private int prevTerm;
    private long startPosition;
    private long commitPosition;
    private long leftPosition;
    private boolean match;
    private int entriesTerm;
    private ByteBuffer entries;

    public TopicPartitionGroup getTopicPartitionGroup() {
        return this.topicPartitionGroup;
    }

    public void setTopicPartitionGroup(TopicPartitionGroup topicPartitionGroup) {
        this.topicPartitionGroup = topicPartitionGroup;
    }

    public String getTopic() {
        return this.topicPartitionGroup.getTopic();
    }

    public int getPartitionGroup() {
        return this.topicPartitionGroup.getPartitionGroupId();
    }

    public int getTerm() {
        return this.term;
    }

    public void setTerm(int term) {
        this.term = term;
    }

    public int getLeaderId() {
        return this.leaderId;
    }

    public void setLeaderId(int leaderId) {
        this.leaderId = leaderId;
    }

    public long getPrevPosition() {
        return this.prevPosition;
    }

    public void setPrevPosition(long prevPosition) {
        this.prevPosition = prevPosition;
    }

    public int getPrevTerm() {
        return this.prevTerm;
    }

    public void setPrevTerm(int prevTerm) {
        this.prevTerm = prevTerm;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(long startPosition) {
        this.startPosition = startPosition;
    }

    public long getCommitPosition() {
        return this.commitPosition;
    }

    public void setCommitPosition(long commitPosition) {
        this.commitPosition = commitPosition;
    }

    public long getLeftPosition() {
        return this.leftPosition;
    }

    public void setLeftPosition(long leftPosition) {
        this.leftPosition = leftPosition;
    }

    public boolean isMatch() {
        return this.match;
    }

    public void setMatch(boolean match) {
        this.match = match;
    }

    public int getEntriesTerm() {
        return this.entriesTerm;
    }

    public void setEntriesTerm(int entriesTerm) {
        this.entriesTerm = entriesTerm;
    }

    public ByteBuffer getEntries() {
        return this.entries;
    }

    public void setEntries(ByteBuffer entries) {
        this.entries = entries;
    }

    public int getEntriesLength() {
        return this.entries.remaining();
    }

    public int type() {
        return 45;
    }

    public String toString() {
        return "appendEntiresRequest:{" + "topic:" + this.getTopic() + ", partitionGroup:" + this.getPartitionGroup() + ", term:" + this.term + ", leaderId:" + this.leaderId + ", prevTerm:" + this.prevTerm + ", prevPosition:" + this.prevPosition + ", startPosition:" + this.startPosition + ", commitPosition:" + this.commitPosition + ", leftPosition:" + this.leftPosition + ", match:" + this.match + ", entriesTerm:" + this.entriesTerm + ", entryLength:" + (this.entries == null ? 0 : this.entries.remaining()) + "}";
    }

    public void release() {
        if (this.entries != null) {
            this.entries = null;
        }
    }

    public static class Build {
        private AppendEntriesRequest appendEntriesRequest = new AppendEntriesRequest();

        public static Build create() {
            return new Build();
        }

        public AppendEntriesRequest build() {
            return this.appendEntriesRequest;
        }

        public Build partitionGroup(TopicPartitionGroup partitionGroup) {
            this.appendEntriesRequest.setTopicPartitionGroup(partitionGroup);
            return this;
        }

        public Build term(int term) {
            this.appendEntriesRequest.setTerm(term);
            return this;
        }

        public Build leader(int leader) {
            this.appendEntriesRequest.setLeaderId(leader);
            return this;
        }

        public Build commitPosition(long commitPosition) {
            this.appendEntriesRequest.setCommitPosition(commitPosition);
            return this;
        }

        public Build startPosition(long startPosition) {
            this.appendEntriesRequest.setStartPosition(startPosition);
            return this;
        }

        public Build leftPosition(long leftPosition) {
            this.appendEntriesRequest.setLeftPosition(leftPosition);
            return this;
        }

        public Build match(boolean match) {
            this.appendEntriesRequest.setMatch(match);
            return this;
        }

        public Build prevTerm(int prevTerm) {
            this.appendEntriesRequest.setPrevTerm(prevTerm);
            return this;
        }

        public Build prevPosition(long prevPosition) {
            this.appendEntriesRequest.setPrevPosition(prevPosition);
            return this;
        }

        public Build entriesTerm(int entriesTerm) {
            this.appendEntriesRequest.setEntriesTerm(entriesTerm);
            return this;
        }

        public Build entries(ByteBuffer entries) {
            this.appendEntriesRequest.setEntries(entries);
            return this;
        }
    }
}

