/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election.handler;

import com.google.common.base.Preconditions;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.election.ElectionManager;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.election.LeaderElection;
import org.joyqueue.broker.election.command.AppendEntriesRequest;
import org.joyqueue.broker.election.command.AppendEntriesResponse;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendEntriesRequestHandler
implements CommandHandler,
Type {
    private static Logger logger = LoggerFactory.getLogger(AppendEntriesRequestHandler.class);
    private ElectionManager electionManager;

    public AppendEntriesRequestHandler(BrokerContext brokerContext) {
        Preconditions.checkArgument((brokerContext != null ? 1 : 0) != 0, (Object)"broker context is null");
        Preconditions.checkArgument((brokerContext.getElectionService() != null ? 1 : 0) != 0, (Object)"election service is null");
        if (!(brokerContext.getElectionService() instanceof ElectionManager)) {
            logger.info("Append entries request handler, election service {} not election manager", (Object)brokerContext.getElectionService());
            throw new IllegalArgumentException();
        }
        this.electionManager = (ElectionManager)brokerContext.getElectionService();
    }

    public AppendEntriesRequestHandler(ElectionService electionService) {
        if (!(electionService instanceof ElectionManager)) {
            logger.info("Append entries request handler, election service {} not election manager", (Object)electionService);
            throw new IllegalArgumentException();
        }
        this.electionManager = (ElectionManager)electionService;
    }

    public Command handle(Transport transport, Command command) throws TransportException {
        if (!(command.getPayload() instanceof AppendEntriesRequest)) {
            throw new IllegalArgumentException();
        }
        AppendEntriesRequest request = (AppendEntriesRequest)((Object)command.getPayload());
        if (request == null) {
            logger.warn("Receive append entries request from {}, request is null", (Object)transport.remoteAddress());
            throw new TransportException("Append entries request payload is null", JoyQueueCode.CT_MESSAGE_BODY_NULL.getCode());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Receive append entries request {} from {}", (Object)request, (Object)transport.remoteAddress());
        }
        try {
            LeaderElection leaderElection = this.electionManager.getLeaderElection(request.getTopic(), request.getPartitionGroup());
            if (leaderElection == null) {
                logger.warn("Handle append entries request of topic {} partition group {} election is null", (Object)request.getTopic(), (Object)request.getPartitionGroup());
                return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -45), (Object)new AppendEntriesResponse.Build().success(false).nextPosition(-1L).build());
            }
            Command response = leaderElection.handleAppendEntriesRequest(request);
            if (null == response) {
                response = new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -45), (Object)new AppendEntriesResponse.Build().success(false).nextPosition(-1L).build());
            }
            return response;
        }
        catch (Exception e) {
            logger.warn("Handle append entries request of topic {} partition group {} fail", new Object[]{request.getTopic(), request.getPartitionGroup(), e});
            return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -45), (Object)new AppendEntriesResponse.Build().success(false).nextPosition(-1L).build());
        }
    }

    public int type() {
        return 45;
    }
}

