/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election.handler;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.model.ConsumePartition;
import org.joyqueue.broker.consumer.position.model.Position;
import org.joyqueue.broker.election.ElectionConfig;
import org.joyqueue.broker.election.command.ReplicateConsumePosRequest;
import org.joyqueue.broker.election.command.ReplicateConsumePosResponse;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicateConsumePosRequestHandler
implements CommandHandler,
Type {
    private static Logger logger = LoggerFactory.getLogger(ReplicateConsumePosRequestHandler.class);
    private Consume consume;
    private ElectionConfig electionConfig;

    public ReplicateConsumePosRequestHandler(ElectionConfig electionConfig, Consume consume) {
        Preconditions.checkArgument((consume != null ? 1 : 0) != 0, (Object)"consume is null");
        this.electionConfig = electionConfig;
        this.consume = consume;
    }

    public ReplicateConsumePosRequestHandler(BrokerContext brokerContext) {
        Preconditions.checkArgument((brokerContext != null ? 1 : 0) != 0, (Object)"broker context is null");
        Preconditions.checkArgument((brokerContext.getConsume() != null ? 1 : 0) != 0, (Object)"consume is null");
        this.consume = brokerContext.getConsume();
        this.electionConfig = new ElectionConfig(brokerContext.getPropertySupplier());
    }

    public Command handle(Transport transport, Command command) throws TransportException {
        if (!(command.getPayload() instanceof ReplicateConsumePosRequest)) {
            throw new IllegalArgumentException();
        }
        ReplicateConsumePosRequest request = (ReplicateConsumePosRequest)((Object)command.getPayload());
        JoyQueueHeader header = new JoyQueueHeader(Direction.RESPONSE, -49);
        ReplicateConsumePosResponse response = new ReplicateConsumePosResponse(false);
        if (request.getConsumePositions() == null) {
            logger.info("Receive consume pos request, consume position is null");
            return new Command((Header)header, (Object)response);
        }
        if (logger.isDebugEnabled() || this.electionConfig.getOutputConsumePos()) {
            logger.info("Receive consume pos request {}", request.getConsumePositions());
        }
        try {
            Map<ConsumePartition, Position> consumePositions = request.getConsumePositions();
            this.consume.setConsumePosition(consumePositions);
            response.setSuccess(true);
        }
        catch (Exception e) {
            logger.warn("Set consume info {} fail", request.getConsumePositions(), (Object)e);
            response.setSuccess(false);
        }
        return new Command((Header)header, (Object)response);
    }

    public int type() {
        return 49;
    }
}

