/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election.handler;

import com.google.common.base.Preconditions;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.election.ElectionManager;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.election.RaftLeaderElection;
import org.joyqueue.broker.election.command.TimeoutNowRequest;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.exception.TransportException;

public class TimeoutNowRequestHandler
implements CommandHandler,
Type {
    private ElectionManager electionManager;

    public TimeoutNowRequestHandler(BrokerContext brokerContext) {
        Preconditions.checkArgument((brokerContext != null ? 1 : 0) != 0, (Object)"broker context is null");
        Preconditions.checkArgument((brokerContext.getElectionService() != null ? 1 : 0) != 0, (Object)"election manager is null");
        if (!(brokerContext.getElectionService() instanceof ElectionManager)) {
            throw new IllegalArgumentException();
        }
        this.electionManager = (ElectionManager)brokerContext.getElectionService();
    }

    public TimeoutNowRequestHandler(ElectionService electionService) {
        if (!(electionService instanceof ElectionManager)) {
            throw new IllegalArgumentException();
        }
        this.electionManager = (ElectionManager)electionService;
    }

    public Command handle(Transport transport, Command command) throws TransportException {
        if (!(command.getPayload() instanceof TimeoutNowRequest)) {
            throw new IllegalArgumentException();
        }
        TimeoutNowRequest request = (TimeoutNowRequest)((Object)command.getPayload());
        RaftLeaderElection leaderElection = (RaftLeaderElection)this.electionManager.getLeaderElection(request.getTopic(), request.getPartitionGroup());
        return leaderElection.handleTimeoutNowRequest(request);
    }

    public int type() {
        return 46;
    }
}

