/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.election.handler;

import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.election.ElectionManager;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.election.RaftLeaderElection;
import org.joyqueue.broker.election.command.VoteRequest;
import org.joyqueue.broker.election.command.VoteResponse;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoteRequestHandler
implements CommandHandler,
Type {
    private static Logger logger = LoggerFactory.getLogger(VoteRequestHandler.class);
    private ElectionManager electionManager;

    public VoteRequestHandler(BrokerContext brokerContext) {
        if (!(brokerContext.getElectionService() instanceof ElectionManager)) {
            throw new IllegalArgumentException();
        }
        this.electionManager = (ElectionManager)brokerContext.getElectionService();
    }

    public VoteRequestHandler(ElectionService electionService) {
        if (!(electionService instanceof ElectionManager)) {
            throw new IllegalArgumentException();
        }
        this.electionManager = (ElectionManager)electionService;
    }

    public int type() {
        return 43;
    }

    public Command handle(Transport transport, Command command) throws TransportException {
        if (command == null) {
            logger.error("Receive vote request command is null");
            return null;
        }
        if (!(command.getPayload() instanceof VoteRequest)) {
            throw new IllegalArgumentException();
        }
        VoteRequest voteRequest = (VoteRequest)((Object)command.getPayload());
        Command response = null;
        try {
            RaftLeaderElection election = (RaftLeaderElection)this.electionManager.getLeaderElection(voteRequest.getTopic(), voteRequest.getPartitionGroup());
            if (election == null) {
                logger.warn("Receive vote request of {}, election is null", (Object)voteRequest.getTopicPartitionGroup());
            } else {
                response = voteRequest.isPreVote() ? election.handlePreVoteRequest(voteRequest) : election.handleVoteRequest(voteRequest);
            }
            if (null == response) {
                response = new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -43), (Object)new VoteResponse(voteRequest.getTerm(), voteRequest.getCandidateId(), election == null ? -1 : election.getLocalNodeId(), false));
            }
            return response;
        }
        catch (Throwable t) {
            logger.warn("Handle vote request exception, request: {}, exception: ", (Object)voteRequest, (Object)t);
            return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -43), (Object)new VoteResponse(voteRequest.getTerm(), voteRequest.getCandidateId(), -1, false));
        }
    }
}

