/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.extension;

import com.google.common.collect.Lists;
import java.util.List;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.extension.ExtensionService;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;

public class ExtensionManager
extends Service {
    private BrokerContext brokerContext;
    private List<ExtensionService> extensionServices;

    public ExtensionManager(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
        this.extensionServices = this.loadExtensionServices();
    }

    protected List<ExtensionService> loadExtensionServices() {
        return Lists.newArrayList((Iterable)com.jd.laf.extension.ExtensionManager.getOrLoadExtensions(ExtensionService.class));
    }

    public void before() {
        for (ExtensionService extensionService : this.extensionServices) {
            extensionService.before(this.brokerContext);
        }
    }

    public void after() {
        for (ExtensionService extensionService : this.extensionServices) {
            extensionService.after(this.brokerContext);
        }
    }

    protected void doStart() throws Exception {
        for (ExtensionService extensionService : this.extensionServices) {
            if (!(extensionService instanceof LifeCycle)) continue;
            ((LifeCycle)extensionService).start();
        }
    }

    protected void doStop() {
        for (ExtensionService extensionService : this.extensionServices) {
            if (!(extensionService instanceof LifeCycle)) continue;
            ((LifeCycle)extensionService).stop();
        }
    }
}

